% Job - Representation of a job run by an engine  Attributes:     gear_id (str): The id of the gear to run     gear_info (Optional[GearInfo]): Extra information about the gear     inputs (JobInputs): The input dictionary of the job     rule_id (Optional[str]): The id of the gear rule if spawned via a rule     role_id (Optional[str]): The id of the role which the job was created with         if spawned via a rule     legacy_inputs: (Optional[List[LegacyInput]]): TODO: description     destination (ContainerReference): The destination of the outputs of the         job     tags (List[str]): List of tags for the jobs     priority: JobPriority: The priority of the job     attempt (int): The number of attempts made for the job     previous_job_id (Optional[str]): The id of the previous job that this         job is retry of     created (datetime.datetime): Timestamp of when the job was created     modified (datetime.datetime): Timestamp of when the job record was last         modified     retried (Optional[datetime.datetime]): Timestamp of when the job was         retried as another job     state (JobState): Current state of the job     request (Optional[JobRequest)]: Request object for the job, used by the         engine for downloading inputs, uploading outputs, etc.     id (str): The id of the job     config (dict): Configuration object of the job     origin (Origin): The origin of the job, who/what created it     saved_files (List[str]): Output files uploaded by the engine from the         job     produced_metadata (Optional[dict]): Raw content of the .metadata.json         file to be attached to the flywheel hierarchy     batch (Optional[str]): The id of the batch the job belongs to     failed_output_accepted (bool): Flag as to whether to upload outputs if         the job failed     profile (Optional[JobProfile]): The profile of the job, contains         information of execution time and resources     failure_reason (Optional[str]): Description of how the job failed     related_container_ids (List[str]): List of ids of all containers the         job has ever been associated with     label (Optional[str]): The label of the job     compute_provider_id (Optional[str]): The id of the compute provider     parents (JobParents): The hierarchy of the jobs destination     transitions (Transitions): Mapping of state to timestamp of when the         job transitioned to that state     parent_info: (Optional[JobDetailParentInfo]): TODO: description
%
% Job Properties:
%    id                   - Unique database ID
%    origin              
%    gearId              
%    gearInfo            
%    previousJobId       
%    inputs              
%    destination         
%    computeProviderId    - Unique database ID
%    group               
%    project              - Unique database ID
%    tags                
%    priority            
%    state               
%    failureReason        - An optional suspected reason for job failure
%    attempt             
%    created              - Creation time (automatically set)
%    modified             - Last modification time (automatically updated)
%    retried              - Retried time (automatically set)
%    config              
%    transitions         
%    request             
%    savedFiles          
%    profile             
%    relatedContainerIds  - The set of all related container ids
%    label                - Application-specific label
%
% Job Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Job < flywheel.ModelBase & flywheel.mixins.JobMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'origin', 'gearId', 'gearInfo', 'previousJobId', 'inputs', 'destination', 'computeProviderId', 'group', 'project', 'tags', 'priority', 'state', 'failureReason', 'attempt', 'created', 'modified', 'retried', 'config', 'transitions', 'request', 'savedFiles', 'profile', 'relatedContainerIds', 'label' }, ...
            { 'id', 'origin', 'gear_id', 'gear_info', 'previous_job_id', 'inputs', 'destination', 'compute_provider_id', 'group', 'project', 'tags', 'priority', 'state', 'failure_reason', 'attempt', 'created', 'modified', 'retried', 'config', 'transitions', 'request', 'saved_files', 'profile', 'related_container_ids', 'label' });
    end
    properties(Dependent)
        id
        origin
        gearId
        gearInfo
        previousJobId
        inputs
        destination
        computeProviderId
        group
        project
        tags
        priority
        state
        failureReason
        attempt
        created
        modified
        retried
        config
        transitions
        request
        savedFiles
        profile
        relatedContainerIds
        label
    end
    methods
        function obj = Job(varargin)
            obj@flywheel.ModelBase(flywheel.model.Job.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'gearId', []);
                addParameter(p, 'gearInfo', []);
                addParameter(p, 'previousJobId', []);
                addParameter(p, 'inputs', []);
                addParameter(p, 'destination', []);
                addParameter(p, 'computeProviderId', []);
                addParameter(p, 'group', []);
                addParameter(p, 'project', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'priority', []);
                addParameter(p, 'state', []);
                addParameter(p, 'failureReason', []);
                addParameter(p, 'attempt', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'retried', []);
                addParameter(p, 'config', []);
                addParameter(p, 'transitions', []);
                addParameter(p, 'request', []);
                addParameter(p, 'savedFiles', []);
                addParameter(p, 'profile', []);
                addParameter(p, 'relatedContainerIds', []);
                addParameter(p, 'label', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.gearId)
                    obj.props_('gear_id') = p.Results.gearId;
                end
                if ~isempty(p.Results.gearInfo)
                    obj.props_('gear_info') = p.Results.gearInfo;
                end
                if ~isempty(p.Results.previousJobId)
                    obj.props_('previous_job_id') = p.Results.previousJobId;
                end
                if ~isempty(p.Results.inputs)
                    obj.props_('inputs') = p.Results.inputs;
                end
                if ~isempty(p.Results.destination)
                    obj.props_('destination') = p.Results.destination;
                end
                if ~isempty(p.Results.computeProviderId)
                    obj.props_('compute_provider_id') = p.Results.computeProviderId;
                end
                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.priority)
                    obj.props_('priority') = p.Results.priority;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.failureReason)
                    obj.props_('failure_reason') = p.Results.failureReason;
                end
                if ~isempty(p.Results.attempt)
                    obj.props_('attempt') = p.Results.attempt;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.retried)
                    obj.props_('retried') = p.Results.retried;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.transitions)
                    obj.props_('transitions') = p.Results.transitions;
                end
                if ~isempty(p.Results.request)
                    obj.props_('request') = p.Results.request;
                end
                if ~isempty(p.Results.savedFiles)
                    obj.props_('saved_files') = p.Results.savedFiles;
                end
                if ~isempty(p.Results.profile)
                    obj.props_('profile') = p.Results.profile;
                end
                if ~isempty(p.Results.relatedContainerIds)
                    obj.props_('related_container_ids') = p.Results.relatedContainerIds;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.gearId(obj)
            if ismethod(obj, 'get_gearId')
                result = obj.get_gearId();
            else
                if isKey(obj.props_, 'gear_id')
                    result = obj.props_('gear_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearId(obj, value)
            obj.props_('gear_id') = value;
        end
        function result = get.gearInfo(obj)
            if ismethod(obj, 'get_gearInfo')
                result = obj.get_gearInfo();
            else
                if isKey(obj.props_, 'gear_info')
                    result = obj.props_('gear_info');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearInfo(obj, value)
            obj.props_('gear_info') = value;
        end
        function result = get.previousJobId(obj)
            if ismethod(obj, 'get_previousJobId')
                result = obj.get_previousJobId();
            else
                if isKey(obj.props_, 'previous_job_id')
                    result = obj.props_('previous_job_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.previousJobId(obj, value)
            obj.props_('previous_job_id') = value;
        end
        function result = get.inputs(obj)
            if ismethod(obj, 'get_inputs')
                result = obj.get_inputs();
            else
                if isKey(obj.props_, 'inputs')
                    result = obj.props_('inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.inputs(obj, value)
            obj.props_('inputs') = value;
        end
        function result = get.destination(obj)
            if ismethod(obj, 'get_destination')
                result = obj.get_destination();
            else
                if isKey(obj.props_, 'destination')
                    result = obj.props_('destination');
                else
                    result = [];
                end
            end
        end
        function obj = set.destination(obj, value)
            obj.props_('destination') = value;
        end
        function result = get.computeProviderId(obj)
            if ismethod(obj, 'get_computeProviderId')
                result = obj.get_computeProviderId();
            else
                if isKey(obj.props_, 'compute_provider_id')
                    result = obj.props_('compute_provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeProviderId(obj, value)
            obj.props_('compute_provider_id') = value;
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.priority(obj)
            if ismethod(obj, 'get_priority')
                result = obj.get_priority();
            else
                if isKey(obj.props_, 'priority')
                    result = obj.props_('priority');
                else
                    result = [];
                end
            end
        end
        function obj = set.priority(obj, value)
            obj.props_('priority') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.failureReason(obj)
            if ismethod(obj, 'get_failureReason')
                result = obj.get_failureReason();
            else
                if isKey(obj.props_, 'failure_reason')
                    result = obj.props_('failure_reason');
                else
                    result = [];
                end
            end
        end
        function obj = set.failureReason(obj, value)
            obj.props_('failure_reason') = value;
        end
        function result = get.attempt(obj)
            if ismethod(obj, 'get_attempt')
                result = obj.get_attempt();
            else
                if isKey(obj.props_, 'attempt')
                    result = obj.props_('attempt');
                else
                    result = [];
                end
            end
        end
        function obj = set.attempt(obj, value)
            obj.props_('attempt') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.retried(obj)
            if ismethod(obj, 'get_retried')
                result = obj.get_retried();
            else
                if isKey(obj.props_, 'retried')
                    result = obj.props_('retried');
                else
                    result = [];
                end
            end
        end
        function obj = set.retried(obj, value)
            obj.props_('retried') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.transitions(obj)
            if ismethod(obj, 'get_transitions')
                result = obj.get_transitions();
            else
                if isKey(obj.props_, 'transitions')
                    result = obj.props_('transitions');
                else
                    result = [];
                end
            end
        end
        function obj = set.transitions(obj, value)
            obj.props_('transitions') = value;
        end
        function result = get.request(obj)
            if ismethod(obj, 'get_request')
                result = obj.get_request();
            else
                if isKey(obj.props_, 'request')
                    result = obj.props_('request');
                else
                    result = [];
                end
            end
        end
        function obj = set.request(obj, value)
            obj.props_('request') = value;
        end
        function result = get.savedFiles(obj)
            if ismethod(obj, 'get_savedFiles')
                result = obj.get_savedFiles();
            else
                if isKey(obj.props_, 'saved_files')
                    result = obj.props_('saved_files');
                else
                    result = [];
                end
            end
        end
        function obj = set.savedFiles(obj, value)
            obj.props_('saved_files') = value;
        end
        function result = get.profile(obj)
            if ismethod(obj, 'get_profile')
                result = obj.get_profile();
            else
                if isKey(obj.props_, 'profile')
                    result = obj.props_('profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.profile(obj, value)
            obj.props_('profile') = value;
        end
        function result = get.relatedContainerIds(obj)
            if ismethod(obj, 'get_relatedContainerIds')
                result = obj.get_relatedContainerIds();
            else
                if isKey(obj.props_, 'related_container_ids')
                    result = obj.props_('related_container_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.relatedContainerIds(obj, value)
            obj.props_('related_container_ids') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'gear_id')
                result('gear_id') = flywheel.ModelBase.serializeValue(obj.props_('gear_id'), 'char');
            end
            if isKey(obj.props_, 'gear_info')
                result('gear_info') = obj.props_('gear_info').toJson();
            end
            if isKey(obj.props_, 'previous_job_id')
                result('previous_job_id') = flywheel.ModelBase.serializeValue(obj.props_('previous_job_id'), 'char');
            end
            if isKey(obj.props_, 'inputs')
                result('inputs') = obj.props_('inputs').toJson();
            end
            if isKey(obj.props_, 'destination')
                result('destination') = obj.props_('destination').toJson();
            end
            if isKey(obj.props_, 'compute_provider_id')
                result('compute_provider_id') = flywheel.ModelBase.serializeValue(obj.props_('compute_provider_id'), 'char');
            end
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'char');
            end
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'priority')
                result('priority') = flywheel.ModelBase.serializeValue(obj.props_('priority'), 'char');
            end
            if isKey(obj.props_, 'state')
                result('state') = flywheel.ModelBase.serializeValue(obj.props_('state'), 'char');
            end
            if isKey(obj.props_, 'failure_reason')
                result('failure_reason') = flywheel.ModelBase.serializeValue(obj.props_('failure_reason'), 'char');
            end
            if isKey(obj.props_, 'attempt')
                result('attempt') = flywheel.ModelBase.serializeValue(obj.props_('attempt'), 'integer');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'retried')
                result('retried') = flywheel.ModelBase.serializeValue(obj.props_('retried'), 'datetime');
            end
            if isKey(obj.props_, 'config')
                result('config') = obj.props_('config').toJson();
            end
            if isKey(obj.props_, 'transitions')
                result('transitions') = obj.props_('transitions').toJson();
            end
            if isKey(obj.props_, 'request')
                result('request') = obj.props_('request').toJson();
            end
            if isKey(obj.props_, 'saved_files')
                result('saved_files') = flywheel.ModelBase.serializeValue(obj.props_('saved_files'), 'vector[char]');
            end
            if isKey(obj.props_, 'profile')
                result('profile') = obj.props_('profile').toJson();
            end
            if isKey(obj.props_, 'related_container_ids')
                result('related_container_ids') = flywheel.ModelBase.serializeValue(obj.props_('related_container_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'gear_id')
                result.gearId = obj.props_('gear_id');
            else
                result.gearId = [];
            end
            if isKey(obj.props_, 'gear_info')
                result.gearInfo = struct(obj.props_('gear_info'));
            else
                result.gearInfo = [];
            end
            if isKey(obj.props_, 'previous_job_id')
                result.previousJobId = obj.props_('previous_job_id');
            else
                result.previousJobId = [];
            end
            if isKey(obj.props_, 'inputs')
                result.inputs = struct(obj.props_('inputs'));
            else
                result.inputs = [];
            end
            if isKey(obj.props_, 'destination')
                result.destination = struct(obj.props_('destination'));
            else
                result.destination = [];
            end
            if isKey(obj.props_, 'compute_provider_id')
                result.computeProviderId = obj.props_('compute_provider_id');
            else
                result.computeProviderId = [];
            end
            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'priority')
                result.priority = obj.props_('priority');
            else
                result.priority = [];
            end
            if isKey(obj.props_, 'state')
                result.state = obj.props_('state');
            else
                result.state = [];
            end
            if isKey(obj.props_, 'failure_reason')
                result.failureReason = obj.props_('failure_reason');
            else
                result.failureReason = [];
            end
            if isKey(obj.props_, 'attempt')
                result.attempt = obj.props_('attempt');
            else
                result.attempt = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'retried')
                result.retried = obj.props_('retried');
            else
                result.retried = [];
            end
            if isKey(obj.props_, 'config')
                result.config = struct(obj.props_('config'));
            else
                result.config = [];
            end
            if isKey(obj.props_, 'transitions')
                result.transitions = struct(obj.props_('transitions'));
            else
                result.transitions = [];
            end
            if isKey(obj.props_, 'request')
                result.request = struct(obj.props_('request'));
            else
                result.request = [];
            end
            if isKey(obj.props_, 'saved_files')
                result.savedFiles = obj.props_('saved_files');
            else
                result.savedFiles = [];
            end
            if isKey(obj.props_, 'profile')
                result.profile = struct(obj.props_('profile'));
            else
                result.profile = [];
            end
            if isKey(obj.props_, 'related_container_ids')
                result.relatedContainerIds = obj.props_('related_container_ids');
            else
                result.relatedContainerIds = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'gear_id')
                    propList.gearId = obj.props_('gear_id');
                else
                    propList.gearId = [];
                end
                if isKey(obj.props_, 'gear_info')
                    propList.gearInfo = obj.props_('gear_info');
                else
                    propList.gearInfo = [];
                end
                if isKey(obj.props_, 'previous_job_id')
                    propList.previousJobId = obj.props_('previous_job_id');
                else
                    propList.previousJobId = [];
                end
                if isKey(obj.props_, 'inputs')
                    propList.inputs = obj.props_('inputs');
                else
                    propList.inputs = [];
                end
                if isKey(obj.props_, 'destination')
                    propList.destination = obj.props_('destination');
                else
                    propList.destination = [];
                end
                if isKey(obj.props_, 'compute_provider_id')
                    propList.computeProviderId = obj.props_('compute_provider_id');
                else
                    propList.computeProviderId = [];
                end
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'priority')
                    propList.priority = obj.props_('priority');
                else
                    propList.priority = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'failure_reason')
                    propList.failureReason = obj.props_('failure_reason');
                else
                    propList.failureReason = [];
                end
                if isKey(obj.props_, 'attempt')
                    propList.attempt = obj.props_('attempt');
                else
                    propList.attempt = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'retried')
                    propList.retried = obj.props_('retried');
                else
                    propList.retried = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'transitions')
                    propList.transitions = obj.props_('transitions');
                else
                    propList.transitions = [];
                end
                if isKey(obj.props_, 'request')
                    propList.request = obj.props_('request');
                else
                    propList.request = [];
                end
                if isKey(obj.props_, 'saved_files')
                    propList.savedFiles = obj.props_('saved_files');
                else
                    propList.savedFiles = [];
                end
                if isKey(obj.props_, 'profile')
                    propList.profile = obj.props_('profile');
                else
                    propList.profile = [];
                end
                if isKey(obj.props_, 'related_container_ids')
                    propList.relatedContainerIds = obj.props_('related_container_ids');
                else
                    propList.relatedContainerIds = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Job;
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.JobOrigin.fromJson(json.origin, context);
            end
            if isfield(json, 'gear_id')
                obj.props_('gear_id') = flywheel.ModelBase.deserializeValue(json.gear_id, 'char');
            end
            if isfield(json, 'gear_info')
                obj.props_('gear_info') = flywheel.model.GearInfo.fromJson(json.gear_info, context);
            end
            if isfield(json, 'previous_job_id')
                obj.props_('previous_job_id') = flywheel.ModelBase.deserializeValue(json.previous_job_id, 'char');
            end
            if isfield(json, 'inputs')
                obj.props_('inputs') = flywheel.model.JobInputsObject.fromJson(json.inputs, context);
            end
            if isfield(json, 'destination')
                obj.props_('destination') = flywheel.model.JobDestination.fromJson(json.destination, context);
            end
            if isfield(json, 'compute_provider_id')
                obj.props_('compute_provider_id') = flywheel.ModelBase.deserializeValue(json.compute_provider_id, 'char');
            end
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'char');
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'priority')
                obj.props_('priority') = flywheel.ModelBase.deserializeValue(json.priority, 'char');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.ModelBase.deserializeValue(json.state, 'char');
            end
            if isfield(json, 'failure_reason')
                obj.props_('failure_reason') = flywheel.ModelBase.deserializeValue(json.failure_reason, 'char');
            end
            if isfield(json, 'attempt')
                obj.props_('attempt') = flywheel.ModelBase.deserializeValue(json.attempt, 'integer');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'retried')
                obj.props_('retried') = flywheel.ModelBase.deserializeValue(json.retried, 'datetime');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.model.JobConfig.fromJson(json.config, context);
            end
            if isfield(json, 'transitions')
                obj.props_('transitions') = flywheel.model.JobTransitionTimes.fromJson(json.transitions, context);
            end
            if isfield(json, 'request')
                obj.props_('request') = flywheel.model.JobRequest.fromJson(json.request, context);
            end
            if isfield(json, 'saved_files')
                obj.props_('saved_files') = flywheel.ModelBase.deserializeValue(json.saved_files, 'vector[char]');
            end
            if isfield(json, 'profile')
                obj.props_('profile') = flywheel.model.JobProfile.fromJson(json.profile, context);
            end
            if isfield(json, 'related_container_ids')
                obj.props_('related_container_ids') = flywheel.ModelBase.deserializeValue(json.related_container_ids, 'vector[char]');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Job')
                    obj = flywheel.model.Job(obj);
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.JobOrigin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'gear_id')
                end
                if isKey(obj.props_, 'gear_info')
                    obj.props_('gear_info') =  flywheel.model.GearInfo.ensureIsInstance(obj.props_('gear_info'));
                end
                if isKey(obj.props_, 'previous_job_id')
                end
                if isKey(obj.props_, 'inputs')
                    obj.props_('inputs') =  flywheel.model.JobInputsObject.ensureIsInstance(obj.props_('inputs'));
                end
                if isKey(obj.props_, 'destination')
                    obj.props_('destination') =  flywheel.model.JobDestination.ensureIsInstance(obj.props_('destination'));
                end
                if isKey(obj.props_, 'compute_provider_id')
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'priority')
                end
                if isKey(obj.props_, 'state')
                end
                if isKey(obj.props_, 'failure_reason')
                end
                if isKey(obj.props_, 'attempt')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'retried')
                end
                if isKey(obj.props_, 'config')
                    obj.props_('config') =  flywheel.model.JobConfig.ensureIsInstance(obj.props_('config'));
                end
                if isKey(obj.props_, 'transitions')
                    obj.props_('transitions') =  flywheel.model.JobTransitionTimes.ensureIsInstance(obj.props_('transitions'));
                end
                if isKey(obj.props_, 'request')
                    obj.props_('request') =  flywheel.model.JobRequest.ensureIsInstance(obj.props_('request'));
                end
                if isKey(obj.props_, 'saved_files')
                end
                if isKey(obj.props_, 'profile')
                    obj.props_('profile') =  flywheel.model.JobProfile.ensureIsInstance(obj.props_('profile'));
                end
                if isKey(obj.props_, 'related_container_ids')
                end
                if isKey(obj.props_, 'label')
                end
            end
        end
    end
end
