% JobAsk - Represents a query made by a job executor to retrieve a job
%
% JobAsk Properties:
%    whitelist    
%    blacklist    
%    capabilities 
%    xReturn      
%    limit        
%    jobStates    
%
% JobAsk Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobAsk < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'whitelist', 'blacklist', 'capabilities', 'xReturn', 'limit', 'jobStates' }, ...
            { 'whitelist', 'blacklist', 'capabilities', 'return', 'limit', 'job_states' });
    end
    properties(Dependent)
        whitelist
        blacklist
        capabilities
        xReturn
        limit
        jobStates
    end
    methods
        function obj = JobAsk(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobAsk.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'whitelist', []);
                addParameter(p, 'blacklist', []);
                addParameter(p, 'capabilities', []);
                addParameter(p, 'xReturn', []);
                addParameter(p, 'limit', 1000);
                addParameter(p, 'jobStates', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.whitelist)
                    obj.props_('whitelist') = p.Results.whitelist;
                end
                if ~isempty(p.Results.blacklist)
                    obj.props_('blacklist') = p.Results.blacklist;
                end
                if ~isempty(p.Results.capabilities)
                    obj.props_('capabilities') = p.Results.capabilities;
                end
                if ~isempty(p.Results.xReturn)
                    obj.props_('return') = p.Results.xReturn;
                end
                if ~isempty(p.Results.limit)
                    obj.props_('limit') = p.Results.limit;
                end
                if ~isempty(p.Results.jobStates)
                    obj.props_('job_states') = p.Results.jobStates;
                end
            end
        end
        function result = get.whitelist(obj)
            if ismethod(obj, 'get_whitelist')
                result = obj.get_whitelist();
            else
                if isKey(obj.props_, 'whitelist')
                    result = obj.props_('whitelist');
                else
                    result = [];
                end
            end
        end
        function obj = set.whitelist(obj, value)
            obj.props_('whitelist') = value;
        end
        function result = get.blacklist(obj)
            if ismethod(obj, 'get_blacklist')
                result = obj.get_blacklist();
            else
                if isKey(obj.props_, 'blacklist')
                    result = obj.props_('blacklist');
                else
                    result = [];
                end
            end
        end
        function obj = set.blacklist(obj, value)
            obj.props_('blacklist') = value;
        end
        function result = get.capabilities(obj)
            if ismethod(obj, 'get_capabilities')
                result = obj.get_capabilities();
            else
                if isKey(obj.props_, 'capabilities')
                    result = obj.props_('capabilities');
                else
                    result = [];
                end
            end
        end
        function obj = set.capabilities(obj, value)
            obj.props_('capabilities') = value;
        end
        function result = get.xReturn(obj)
            if ismethod(obj, 'get_xReturn')
                result = obj.get_xReturn();
            else
                if isKey(obj.props_, 'return')
                    result = obj.props_('return');
                else
                    result = [];
                end
            end
        end
        function obj = set.xReturn(obj, value)
            obj.props_('return') = value;
        end
        function result = get.limit(obj)
            if ismethod(obj, 'get_limit')
                result = obj.get_limit();
            else
                if isKey(obj.props_, 'limit')
                    result = obj.props_('limit');
                else
                    result = [];
                end
            end
        end
        function obj = set.limit(obj, value)
            obj.props_('limit') = value;
        end
        function result = get.jobStates(obj)
            if ismethod(obj, 'get_jobStates')
                result = obj.get_jobStates();
            else
                if isKey(obj.props_, 'job_states')
                    result = obj.props_('job_states');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobStates(obj, value)
            obj.props_('job_states') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'whitelist')
                result('whitelist') = obj.props_('whitelist').toJson();
            end
            if isKey(obj.props_, 'blacklist')
                result('blacklist') = obj.props_('blacklist').toJson();
            end
            if isKey(obj.props_, 'capabilities')
                result('capabilities') = flywheel.ModelBase.serializeValue(obj.props_('capabilities'), 'vector[char]');
            end
            if isKey(obj.props_, 'return')
                result('return') = obj.props_('return').toJson();
            end
            if isKey(obj.props_, 'limit')
                result('limit') = flywheel.ModelBase.serializeValue(obj.props_('limit'), 'integer');
            end
            if isKey(obj.props_, 'job_states')
                result('job_states') = flywheel.ModelBase.cellmap(@toJson, obj.props_('job_states'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'whitelist')
                result.whitelist = struct(obj.props_('whitelist'));
            else
                result.whitelist = [];
            end
            if isKey(obj.props_, 'blacklist')
                result.blacklist = struct(obj.props_('blacklist'));
            else
                result.blacklist = [];
            end
            if isKey(obj.props_, 'capabilities')
                result.capabilities = obj.props_('capabilities');
            else
                result.capabilities = [];
            end
            if isKey(obj.props_, 'return')
                result.xReturn = struct(obj.props_('return'));
            else
                result.xReturn = [];
            end
            if isKey(obj.props_, 'limit')
                result.limit = obj.props_('limit');
            else
                result.limit = [];
            end
            if isKey(obj.props_, 'job_states')
                result.jobStates = flywheel.ModelBase.cellmap(@struct, obj.props_('job_states'));
            else
                result.jobStates = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'whitelist')
                    propList.whitelist = obj.props_('whitelist');
                else
                    propList.whitelist = [];
                end
                if isKey(obj.props_, 'blacklist')
                    propList.blacklist = obj.props_('blacklist');
                else
                    propList.blacklist = [];
                end
                if isKey(obj.props_, 'capabilities')
                    propList.capabilities = obj.props_('capabilities');
                else
                    propList.capabilities = [];
                end
                if isKey(obj.props_, 'return')
                    propList.xReturn = obj.props_('return');
                else
                    propList.xReturn = [];
                end
                if isKey(obj.props_, 'limit')
                    propList.limit = obj.props_('limit');
                else
                    propList.limit = [];
                end
                if isKey(obj.props_, 'job_states')
                    propList.jobStates = obj.props_('job_states');
                else
                    propList.jobStates = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobAsk;
            if isfield(json, 'whitelist')
                obj.props_('whitelist') = flywheel.model.JobConfigInput.fromJson(json.whitelist, context);
            end
            if isfield(json, 'blacklist')
                obj.props_('blacklist') = flywheel.model.JobConfigInput.fromJson(json.blacklist, context);
            end
            if isfield(json, 'capabilities')
                obj.props_('capabilities') = flywheel.ModelBase.deserializeValue(json.capabilities, 'vector[char]');
            end
            if isfield(json, 'return')
                obj.props_('return') = flywheel.model.AllOfJobAskXReturn.fromJson(json.return, context);
            end
            if isfield(json, 'limit')
                obj.props_('limit') = flywheel.ModelBase.deserializeValue(json.limit, 'integer');
            end
            if isfield(json, 'job_states')
                obj.props_('job_states') = flywheel.ModelBase.cellmap(@(x) flywheel.model.JobState.fromJson(x, context), json.job_states);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobAsk')
                    obj = flywheel.model.JobAsk(obj);
                end
                if isKey(obj.props_, 'whitelist')
                    obj.props_('whitelist') =  flywheel.model.JobConfigInput.ensureIsInstance(obj.props_('whitelist'));
                end
                if isKey(obj.props_, 'blacklist')
                    obj.props_('blacklist') =  flywheel.model.JobConfigInput.ensureIsInstance(obj.props_('blacklist'));
                end
                if isKey(obj.props_, 'capabilities')
                end
                if isKey(obj.props_, 'return')
                    obj.props_('return') =  flywheel.model.AllOfJobAskXReturn.ensureIsInstance(obj.props_('return'));
                end
                if isKey(obj.props_, 'limit')
                end
                if isKey(obj.props_, 'job_states')
                    obj.props_('job_states') = flywheel.ModelBase.cellmap(@flywheel.model.JobState.ensureIsInstance, obj.props_('job_states'));
                end
            end
        end
    end
end
