% JobAskResponse - Represents the API's response to a query for jobs  Attributes:     jobs (Optional[List[Job]]): The list of jobs matching the ask query     states (Optional[JobsByState]): The number of jobs in each state
%
% JobAskResponse Properties:
%    jobs   
%    states 
%
% JobAskResponse Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobAskResponse < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'jobs', 'states' }, ...
            { 'jobs', 'states' });
    end
    properties(Dependent)
        jobs
        states
    end
    methods
        function obj = JobAskResponse(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobAskResponse.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'jobs', []);
                addParameter(p, 'states', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.jobs)
                    obj.props_('jobs') = p.Results.jobs;
                end
                if ~isempty(p.Results.states)
                    obj.props_('states') = p.Results.states;
                end
            end
        end
        function result = get.jobs(obj)
            if ismethod(obj, 'get_jobs')
                result = obj.get_jobs();
            else
                if isKey(obj.props_, 'jobs')
                    result = obj.props_('jobs');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobs(obj, value)
            obj.props_('jobs') = value;
        end
        function result = get.states(obj)
            if ismethod(obj, 'get_states')
                result = obj.get_states();
            else
                if isKey(obj.props_, 'states')
                    result = obj.props_('states');
                else
                    result = [];
                end
            end
        end
        function obj = set.states(obj, value)
            obj.props_('states') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'jobs')
                result('jobs') = flywheel.ModelBase.cellmap(@toJson, obj.props_('jobs'));
            end
            if isKey(obj.props_, 'states')
                result('states') = obj.props_('states').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'jobs')
                result.jobs = flywheel.ModelBase.cellmap(@struct, obj.props_('jobs'));
            else
                result.jobs = [];
            end
            if isKey(obj.props_, 'states')
                result.states = struct(obj.props_('states'));
            else
                result.states = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'jobs')
                    propList.jobs = obj.props_('jobs');
                else
                    propList.jobs = [];
                end
                if isKey(obj.props_, 'states')
                    propList.states = obj.props_('states');
                else
                    propList.states = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobAskResponse;
            if isfield(json, 'jobs')
                obj.props_('jobs') = flywheel.ModelBase.cellmap(@(x) flywheel.model.JobAskResponseJob.fromJson(x, context), json.jobs);
            end
            if isfield(json, 'states')
                obj.props_('states') = flywheel.model.JobsByState.fromJson(json.states, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobAskResponse')
                    obj = flywheel.model.JobAskResponse(obj);
                end
                if isKey(obj.props_, 'jobs')
                    obj.props_('jobs') = flywheel.ModelBase.cellmap(@flywheel.model.JobAskResponseJob.ensureIsInstance, obj.props_('jobs'));
                end
                if isKey(obj.props_, 'states')
                    obj.props_('states') =  flywheel.model.JobsByState.ensureIsInstance(obj.props_('states'));
                end
            end
        end
    end
end
