% JobAskResponseJob
%
% JobAskResponseJob Properties:
%    computeProviderId    
%    failureReason        
%    label                
%    priority             
%    modified             
%    parents              
%    producedMetadata     
%    relatedContainerIds  
%    request              
%    retried              
%    savedFiles           
%    state                
%    profile              
%    transitions          
%    gearId               
%    gearInfo             
%    ruleId               
%    roleId               
%    inputs               
%    legacyInputs         
%    destination          
%    tags                 
%    attempt              
%    previousJobId        
%    created              
%    id                   
%    config               
%    origin               
%    batch                
%    failedOutputAccepted 
%    parentInfo           
%
% JobAskResponseJob Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobAskResponseJob < flywheel.ModelBase & flywheel.mixins.JobMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'computeProviderId', 'failureReason', 'label', 'priority', 'modified', 'parents', 'producedMetadata', 'relatedContainerIds', 'request', 'retried', 'savedFiles', 'state', 'profile', 'transitions', 'gearId', 'gearInfo', 'ruleId', 'roleId', 'inputs', 'legacyInputs', 'destination', 'tags', 'attempt', 'previousJobId', 'created', 'id', 'config', 'origin', 'batch', 'failedOutputAccepted', 'parentInfo' }, ...
            { 'compute_provider_id', 'failure_reason', 'label', 'priority', 'modified', 'parents', 'produced_metadata', 'related_container_ids', 'request', 'retried', 'saved_files', 'state', 'profile', 'transitions', 'gear_id', 'gear_info', 'rule_id', 'role_id', 'inputs', 'legacy_inputs', 'destination', 'tags', 'attempt', 'previous_job_id', 'created', 'id', 'config', 'origin', 'batch', 'failed_output_accepted', 'parent_info' });
    end
    properties(Dependent)
        computeProviderId
        failureReason
        label
        priority
        modified
        parents
        producedMetadata
        relatedContainerIds
        request
        retried
        savedFiles
        state
        profile
        transitions
        gearId
        gearInfo
        ruleId
        roleId
        inputs
        legacyInputs
        destination
        tags
        attempt
        previousJobId
        created
        id
        config
        origin
        batch
        failedOutputAccepted
        parentInfo
    end
    methods
        function obj = JobAskResponseJob(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobAskResponseJob.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'computeProviderId', []);
                addParameter(p, 'failureReason', []);
                addParameter(p, 'label', []);
                addParameter(p, 'priority', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'parents', []);
                addParameter(p, 'producedMetadata', []);
                addParameter(p, 'relatedContainerIds', []);
                addParameter(p, 'request', []);
                addParameter(p, 'retried', []);
                addParameter(p, 'savedFiles', []);
                addParameter(p, 'state', []);
                addParameter(p, 'profile', []);
                addParameter(p, 'transitions', []);
                addParameter(p, 'gearId', []);
                addParameter(p, 'gearInfo', []);
                addParameter(p, 'ruleId', []);
                addParameter(p, 'roleId', []);
                addParameter(p, 'inputs', []);
                addParameter(p, 'legacyInputs', []);
                addParameter(p, 'destination', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'attempt', []);
                addParameter(p, 'previousJobId', []);
                addParameter(p, 'created', []);
                addParameter(p, 'id', []);
                addParameter(p, 'config', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'batch', []);
                addParameter(p, 'failedOutputAccepted', []);
                addParameter(p, 'parentInfo', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.computeProviderId)
                    obj.props_('compute_provider_id') = p.Results.computeProviderId;
                end
                if ~isempty(p.Results.failureReason)
                    obj.props_('failure_reason') = p.Results.failureReason;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.priority)
                    obj.props_('priority') = p.Results.priority;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.parents)
                    obj.props_('parents') = p.Results.parents;
                end
                if ~isempty(p.Results.producedMetadata)
                    obj.props_('produced_metadata') = p.Results.producedMetadata;
                end
                if ~isempty(p.Results.relatedContainerIds)
                    obj.props_('related_container_ids') = p.Results.relatedContainerIds;
                end
                if ~isempty(p.Results.request)
                    obj.props_('request') = p.Results.request;
                end
                if ~isempty(p.Results.retried)
                    obj.props_('retried') = p.Results.retried;
                end
                if ~isempty(p.Results.savedFiles)
                    obj.props_('saved_files') = p.Results.savedFiles;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.profile)
                    obj.props_('profile') = p.Results.profile;
                end
                if ~isempty(p.Results.transitions)
                    obj.props_('transitions') = p.Results.transitions;
                end
                if ~isempty(p.Results.gearId)
                    obj.props_('gear_id') = p.Results.gearId;
                end
                if ~isempty(p.Results.gearInfo)
                    obj.props_('gear_info') = p.Results.gearInfo;
                end
                if ~isempty(p.Results.ruleId)
                    obj.props_('rule_id') = p.Results.ruleId;
                end
                if ~isempty(p.Results.roleId)
                    obj.props_('role_id') = p.Results.roleId;
                end
                if ~isempty(p.Results.inputs)
                    obj.props_('inputs') = p.Results.inputs;
                end
                if ~isempty(p.Results.legacyInputs)
                    obj.props_('legacy_inputs') = p.Results.legacyInputs;
                end
                if ~isempty(p.Results.destination)
                    obj.props_('destination') = p.Results.destination;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.attempt)
                    obj.props_('attempt') = p.Results.attempt;
                end
                if ~isempty(p.Results.previousJobId)
                    obj.props_('previous_job_id') = p.Results.previousJobId;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.batch)
                    obj.props_('batch') = p.Results.batch;
                end
                if ~isempty(p.Results.failedOutputAccepted)
                    obj.props_('failed_output_accepted') = p.Results.failedOutputAccepted;
                end
                if ~isempty(p.Results.parentInfo)
                    obj.props_('parent_info') = p.Results.parentInfo;
                end
            end
        end
        function result = get.computeProviderId(obj)
            if ismethod(obj, 'get_computeProviderId')
                result = obj.get_computeProviderId();
            else
                if isKey(obj.props_, 'compute_provider_id')
                    result = obj.props_('compute_provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeProviderId(obj, value)
            obj.props_('compute_provider_id') = value;
        end
        function result = get.failureReason(obj)
            if ismethod(obj, 'get_failureReason')
                result = obj.get_failureReason();
            else
                if isKey(obj.props_, 'failure_reason')
                    result = obj.props_('failure_reason');
                else
                    result = [];
                end
            end
        end
        function obj = set.failureReason(obj, value)
            obj.props_('failure_reason') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.priority(obj)
            if ismethod(obj, 'get_priority')
                result = obj.get_priority();
            else
                if isKey(obj.props_, 'priority')
                    result = obj.props_('priority');
                else
                    result = [];
                end
            end
        end
        function obj = set.priority(obj, value)
            obj.props_('priority') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.parents(obj)
            if ismethod(obj, 'get_parents')
                result = obj.get_parents();
            else
                if isKey(obj.props_, 'parents')
                    result = obj.props_('parents');
                else
                    result = [];
                end
            end
        end
        function obj = set.parents(obj, value)
            obj.props_('parents') = value;
        end
        function result = get.producedMetadata(obj)
            if ismethod(obj, 'get_producedMetadata')
                result = obj.get_producedMetadata();
            else
                if isKey(obj.props_, 'produced_metadata')
                    result = obj.props_('produced_metadata');
                else
                    result = [];
                end
            end
        end
        function obj = set.producedMetadata(obj, value)
            obj.props_('produced_metadata') = value;
        end
        function result = get.relatedContainerIds(obj)
            if ismethod(obj, 'get_relatedContainerIds')
                result = obj.get_relatedContainerIds();
            else
                if isKey(obj.props_, 'related_container_ids')
                    result = obj.props_('related_container_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.relatedContainerIds(obj, value)
            obj.props_('related_container_ids') = value;
        end
        function result = get.request(obj)
            if ismethod(obj, 'get_request')
                result = obj.get_request();
            else
                if isKey(obj.props_, 'request')
                    result = obj.props_('request');
                else
                    result = [];
                end
            end
        end
        function obj = set.request(obj, value)
            obj.props_('request') = value;
        end
        function result = get.retried(obj)
            if ismethod(obj, 'get_retried')
                result = obj.get_retried();
            else
                if isKey(obj.props_, 'retried')
                    result = obj.props_('retried');
                else
                    result = [];
                end
            end
        end
        function obj = set.retried(obj, value)
            obj.props_('retried') = value;
        end
        function result = get.savedFiles(obj)
            if ismethod(obj, 'get_savedFiles')
                result = obj.get_savedFiles();
            else
                if isKey(obj.props_, 'saved_files')
                    result = obj.props_('saved_files');
                else
                    result = [];
                end
            end
        end
        function obj = set.savedFiles(obj, value)
            obj.props_('saved_files') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.profile(obj)
            if ismethod(obj, 'get_profile')
                result = obj.get_profile();
            else
                if isKey(obj.props_, 'profile')
                    result = obj.props_('profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.profile(obj, value)
            obj.props_('profile') = value;
        end
        function result = get.transitions(obj)
            if ismethod(obj, 'get_transitions')
                result = obj.get_transitions();
            else
                if isKey(obj.props_, 'transitions')
                    result = obj.props_('transitions');
                else
                    result = [];
                end
            end
        end
        function obj = set.transitions(obj, value)
            obj.props_('transitions') = value;
        end
        function result = get.gearId(obj)
            if ismethod(obj, 'get_gearId')
                result = obj.get_gearId();
            else
                if isKey(obj.props_, 'gear_id')
                    result = obj.props_('gear_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearId(obj, value)
            obj.props_('gear_id') = value;
        end
        function result = get.gearInfo(obj)
            if ismethod(obj, 'get_gearInfo')
                result = obj.get_gearInfo();
            else
                if isKey(obj.props_, 'gear_info')
                    result = obj.props_('gear_info');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearInfo(obj, value)
            obj.props_('gear_info') = value;
        end
        function result = get.ruleId(obj)
            if ismethod(obj, 'get_ruleId')
                result = obj.get_ruleId();
            else
                if isKey(obj.props_, 'rule_id')
                    result = obj.props_('rule_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.ruleId(obj, value)
            obj.props_('rule_id') = value;
        end
        function result = get.roleId(obj)
            if ismethod(obj, 'get_roleId')
                result = obj.get_roleId();
            else
                if isKey(obj.props_, 'role_id')
                    result = obj.props_('role_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.roleId(obj, value)
            obj.props_('role_id') = value;
        end
        function result = get.inputs(obj)
            if ismethod(obj, 'get_inputs')
                result = obj.get_inputs();
            else
                if isKey(obj.props_, 'inputs')
                    result = obj.props_('inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.inputs(obj, value)
            obj.props_('inputs') = value;
        end
        function result = get.legacyInputs(obj)
            if ismethod(obj, 'get_legacyInputs')
                result = obj.get_legacyInputs();
            else
                if isKey(obj.props_, 'legacy_inputs')
                    result = obj.props_('legacy_inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.legacyInputs(obj, value)
            obj.props_('legacy_inputs') = value;
        end
        function result = get.destination(obj)
            if ismethod(obj, 'get_destination')
                result = obj.get_destination();
            else
                if isKey(obj.props_, 'destination')
                    result = obj.props_('destination');
                else
                    result = [];
                end
            end
        end
        function obj = set.destination(obj, value)
            obj.props_('destination') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.attempt(obj)
            if ismethod(obj, 'get_attempt')
                result = obj.get_attempt();
            else
                if isKey(obj.props_, 'attempt')
                    result = obj.props_('attempt');
                else
                    result = [];
                end
            end
        end
        function obj = set.attempt(obj, value)
            obj.props_('attempt') = value;
        end
        function result = get.previousJobId(obj)
            if ismethod(obj, 'get_previousJobId')
                result = obj.get_previousJobId();
            else
                if isKey(obj.props_, 'previous_job_id')
                    result = obj.props_('previous_job_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.previousJobId(obj, value)
            obj.props_('previous_job_id') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.batch(obj)
            if ismethod(obj, 'get_batch')
                result = obj.get_batch();
            else
                if isKey(obj.props_, 'batch')
                    result = obj.props_('batch');
                else
                    result = [];
                end
            end
        end
        function obj = set.batch(obj, value)
            obj.props_('batch') = value;
        end
        function result = get.failedOutputAccepted(obj)
            if ismethod(obj, 'get_failedOutputAccepted')
                result = obj.get_failedOutputAccepted();
            else
                if isKey(obj.props_, 'failed_output_accepted')
                    result = obj.props_('failed_output_accepted');
                else
                    result = [];
                end
            end
        end
        function obj = set.failedOutputAccepted(obj, value)
            obj.props_('failed_output_accepted') = value;
        end
        function result = get.parentInfo(obj)
            if ismethod(obj, 'get_parentInfo')
                result = obj.get_parentInfo();
            else
                if isKey(obj.props_, 'parent_info')
                    result = obj.props_('parent_info');
                else
                    result = [];
                end
            end
        end
        function obj = set.parentInfo(obj, value)
            obj.props_('parent_info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'compute_provider_id')
                result('compute_provider_id') = flywheel.ModelBase.serializeValue(obj.props_('compute_provider_id'), 'char');
            end
            if isKey(obj.props_, 'failure_reason')
                result('failure_reason') = flywheel.ModelBase.serializeValue(obj.props_('failure_reason'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'priority')
                result('priority') = obj.props_('priority').toJson();
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'parents')
                result('parents') = obj.props_('parents').toJson();
            end
            if isKey(obj.props_, 'produced_metadata')
                result('produced_metadata') = flywheel.ModelBase.serializeValue(obj.props_('produced_metadata'), 'containers.Map');
            end
            if isKey(obj.props_, 'related_container_ids')
                result('related_container_ids') = flywheel.ModelBase.serializeValue(obj.props_('related_container_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 'request')
                result('request') = obj.props_('request').toJson();
            end
            if isKey(obj.props_, 'retried')
                result('retried') = flywheel.ModelBase.serializeValue(obj.props_('retried'), 'datetime');
            end
            if isKey(obj.props_, 'saved_files')
                result('saved_files') = flywheel.ModelBase.serializeValue(obj.props_('saved_files'), 'vector[char]');
            end
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
            if isKey(obj.props_, 'profile')
                result('profile') = obj.props_('profile').toJson();
            end
            if isKey(obj.props_, 'transitions')
                result('transitions') = obj.props_('transitions').toJson();
            end
            if isKey(obj.props_, 'gear_id')
                result('gear_id') = flywheel.ModelBase.serializeValue(obj.props_('gear_id'), 'char');
            end
            if isKey(obj.props_, 'gear_info')
                result('gear_info') = obj.props_('gear_info').toJson();
            end
            if isKey(obj.props_, 'rule_id')
                result('rule_id') = flywheel.ModelBase.serializeValue(obj.props_('rule_id'), 'char');
            end
            if isKey(obj.props_, 'role_id')
                result('role_id') = flywheel.ModelBase.serializeValue(obj.props_('role_id'), 'char');
            end
            if isKey(obj.props_, 'inputs')
                result('inputs') = obj.props_('inputs').toJson();
            end
            if isKey(obj.props_, 'legacy_inputs')
                result('legacy_inputs') = flywheel.ModelBase.cellmap(@toJson, obj.props_('legacy_inputs'));
            end
            if isKey(obj.props_, 'destination')
                result('destination') = obj.props_('destination').toJson();
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'attempt')
                result('attempt') = flywheel.ModelBase.serializeValue(obj.props_('attempt'), 'integer');
            end
            if isKey(obj.props_, 'previous_job_id')
                result('previous_job_id') = flywheel.ModelBase.serializeValue(obj.props_('previous_job_id'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'batch')
                result('batch') = flywheel.ModelBase.serializeValue(obj.props_('batch'), 'char');
            end
            if isKey(obj.props_, 'failed_output_accepted')
                result('failed_output_accepted') = flywheel.ModelBase.serializeValue(obj.props_('failed_output_accepted'), 'logical');
            end
            if isKey(obj.props_, 'parent_info')
                result('parent_info') = obj.props_('parent_info').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'compute_provider_id')
                result.computeProviderId = obj.props_('compute_provider_id');
            else
                result.computeProviderId = [];
            end
            if isKey(obj.props_, 'failure_reason')
                result.failureReason = obj.props_('failure_reason');
            else
                result.failureReason = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'priority')
                result.priority = struct(obj.props_('priority'));
            else
                result.priority = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'parents')
                result.parents = struct(obj.props_('parents'));
            else
                result.parents = [];
            end
            if isKey(obj.props_, 'produced_metadata')
                result.producedMetadata = obj.props_('produced_metadata');
            else
                result.producedMetadata = [];
            end
            if isKey(obj.props_, 'related_container_ids')
                result.relatedContainerIds = obj.props_('related_container_ids');
            else
                result.relatedContainerIds = [];
            end
            if isKey(obj.props_, 'request')
                result.request = struct(obj.props_('request'));
            else
                result.request = [];
            end
            if isKey(obj.props_, 'retried')
                result.retried = obj.props_('retried');
            else
                result.retried = [];
            end
            if isKey(obj.props_, 'saved_files')
                result.savedFiles = obj.props_('saved_files');
            else
                result.savedFiles = [];
            end
            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
            if isKey(obj.props_, 'profile')
                result.profile = struct(obj.props_('profile'));
            else
                result.profile = [];
            end
            if isKey(obj.props_, 'transitions')
                result.transitions = struct(obj.props_('transitions'));
            else
                result.transitions = [];
            end
            if isKey(obj.props_, 'gear_id')
                result.gearId = obj.props_('gear_id');
            else
                result.gearId = [];
            end
            if isKey(obj.props_, 'gear_info')
                result.gearInfo = struct(obj.props_('gear_info'));
            else
                result.gearInfo = [];
            end
            if isKey(obj.props_, 'rule_id')
                result.ruleId = obj.props_('rule_id');
            else
                result.ruleId = [];
            end
            if isKey(obj.props_, 'role_id')
                result.roleId = obj.props_('role_id');
            else
                result.roleId = [];
            end
            if isKey(obj.props_, 'inputs')
                result.inputs = struct(obj.props_('inputs'));
            else
                result.inputs = [];
            end
            if isKey(obj.props_, 'legacy_inputs')
                result.legacyInputs = flywheel.ModelBase.cellmap(@struct, obj.props_('legacy_inputs'));
            else
                result.legacyInputs = [];
            end
            if isKey(obj.props_, 'destination')
                result.destination = struct(obj.props_('destination'));
            else
                result.destination = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'attempt')
                result.attempt = obj.props_('attempt');
            else
                result.attempt = [];
            end
            if isKey(obj.props_, 'previous_job_id')
                result.previousJobId = obj.props_('previous_job_id');
            else
                result.previousJobId = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'batch')
                result.batch = obj.props_('batch');
            else
                result.batch = [];
            end
            if isKey(obj.props_, 'failed_output_accepted')
                result.failedOutputAccepted = obj.props_('failed_output_accepted');
            else
                result.failedOutputAccepted = [];
            end
            if isKey(obj.props_, 'parent_info')
                result.parentInfo = struct(obj.props_('parent_info'));
            else
                result.parentInfo = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'compute_provider_id')
                    propList.computeProviderId = obj.props_('compute_provider_id');
                else
                    propList.computeProviderId = [];
                end
                if isKey(obj.props_, 'failure_reason')
                    propList.failureReason = obj.props_('failure_reason');
                else
                    propList.failureReason = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'priority')
                    propList.priority = obj.props_('priority');
                else
                    propList.priority = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'parents')
                    propList.parents = obj.props_('parents');
                else
                    propList.parents = [];
                end
                if isKey(obj.props_, 'produced_metadata')
                    propList.producedMetadata = obj.props_('produced_metadata');
                else
                    propList.producedMetadata = [];
                end
                if isKey(obj.props_, 'related_container_ids')
                    propList.relatedContainerIds = obj.props_('related_container_ids');
                else
                    propList.relatedContainerIds = [];
                end
                if isKey(obj.props_, 'request')
                    propList.request = obj.props_('request');
                else
                    propList.request = [];
                end
                if isKey(obj.props_, 'retried')
                    propList.retried = obj.props_('retried');
                else
                    propList.retried = [];
                end
                if isKey(obj.props_, 'saved_files')
                    propList.savedFiles = obj.props_('saved_files');
                else
                    propList.savedFiles = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'profile')
                    propList.profile = obj.props_('profile');
                else
                    propList.profile = [];
                end
                if isKey(obj.props_, 'transitions')
                    propList.transitions = obj.props_('transitions');
                else
                    propList.transitions = [];
                end
                if isKey(obj.props_, 'gear_id')
                    propList.gearId = obj.props_('gear_id');
                else
                    propList.gearId = [];
                end
                if isKey(obj.props_, 'gear_info')
                    propList.gearInfo = obj.props_('gear_info');
                else
                    propList.gearInfo = [];
                end
                if isKey(obj.props_, 'rule_id')
                    propList.ruleId = obj.props_('rule_id');
                else
                    propList.ruleId = [];
                end
                if isKey(obj.props_, 'role_id')
                    propList.roleId = obj.props_('role_id');
                else
                    propList.roleId = [];
                end
                if isKey(obj.props_, 'inputs')
                    propList.inputs = obj.props_('inputs');
                else
                    propList.inputs = [];
                end
                if isKey(obj.props_, 'legacy_inputs')
                    propList.legacyInputs = obj.props_('legacy_inputs');
                else
                    propList.legacyInputs = [];
                end
                if isKey(obj.props_, 'destination')
                    propList.destination = obj.props_('destination');
                else
                    propList.destination = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'attempt')
                    propList.attempt = obj.props_('attempt');
                else
                    propList.attempt = [];
                end
                if isKey(obj.props_, 'previous_job_id')
                    propList.previousJobId = obj.props_('previous_job_id');
                else
                    propList.previousJobId = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'batch')
                    propList.batch = obj.props_('batch');
                else
                    propList.batch = [];
                end
                if isKey(obj.props_, 'failed_output_accepted')
                    propList.failedOutputAccepted = obj.props_('failed_output_accepted');
                else
                    propList.failedOutputAccepted = [];
                end
                if isKey(obj.props_, 'parent_info')
                    propList.parentInfo = obj.props_('parent_info');
                else
                    propList.parentInfo = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobAskResponseJob;
            if isfield(json, 'compute_provider_id')
                obj.props_('compute_provider_id') = flywheel.ModelBase.deserializeValue(json.compute_provider_id, 'char');
            end
            if isfield(json, 'failure_reason')
                obj.props_('failure_reason') = flywheel.ModelBase.deserializeValue(json.failure_reason, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'priority')
                obj.props_('priority') = flywheel.model.AllOfJobAskResponseJobPriority.fromJson(json.priority, context);
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'parents')
                obj.props_('parents') = flywheel.model.JobParents.fromJson(json.parents, context);
            end
            if isfield(json, 'produced_metadata')
                obj.props_('produced_metadata') = flywheel.ModelBase.deserializeValue(json.produced_metadata, 'containers.Map');
            end
            if isfield(json, 'related_container_ids')
                obj.props_('related_container_ids') = flywheel.ModelBase.deserializeValue(json.related_container_ids, 'vector[char]');
            end
            if isfield(json, 'request')
                obj.props_('request') = flywheel.model.JobRequest.fromJson(json.request, context);
            end
            if isfield(json, 'retried')
                obj.props_('retried') = flywheel.ModelBase.deserializeValue(json.retried, 'datetime');
            end
            if isfield(json, 'saved_files')
                obj.props_('saved_files') = flywheel.ModelBase.deserializeValue(json.saved_files, 'vector[char]');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.JobState.fromJson(json.state, context);
            end
            if isfield(json, 'profile')
                obj.props_('profile') = flywheel.model.JobProfile.fromJson(json.profile, context);
            end
            if isfield(json, 'transitions')
                obj.props_('transitions') = flywheel.model.AllOfJobAskResponseJobTransitions.fromJson(json.transitions, context);
            end
            if isfield(json, 'gear_id')
                obj.props_('gear_id') = flywheel.ModelBase.deserializeValue(json.gear_id, 'char');
            end
            if isfield(json, 'gear_info')
                obj.props_('gear_info') = flywheel.model.GearInfo.fromJson(json.gear_info, context);
            end
            if isfield(json, 'rule_id')
                obj.props_('rule_id') = flywheel.ModelBase.deserializeValue(json.rule_id, 'char');
            end
            if isfield(json, 'role_id')
                obj.props_('role_id') = flywheel.ModelBase.deserializeValue(json.role_id, 'char');
            end
            if isfield(json, 'inputs')
                obj.props_('inputs') = flywheel.model.Object.fromJson(json.inputs, context);
            end
            if isfield(json, 'legacy_inputs')
                obj.props_('legacy_inputs') = flywheel.ModelBase.cellmap(@(x) flywheel.model.LegacyInput.fromJson(x, context), json.legacy_inputs);
            end
            if isfield(json, 'destination')
                obj.props_('destination') = flywheel.model.ContainerReference.fromJson(json.destination, context);
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'attempt')
                obj.props_('attempt') = flywheel.ModelBase.deserializeValue(json.attempt, 'integer');
            end
            if isfield(json, 'previous_job_id')
                obj.props_('previous_job_id') = flywheel.ModelBase.deserializeValue(json.previous_job_id, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'batch')
                obj.props_('batch') = flywheel.ModelBase.deserializeValue(json.batch, 'char');
            end
            if isfield(json, 'failed_output_accepted')
                obj.props_('failed_output_accepted') = flywheel.ModelBase.deserializeValue(json.failed_output_accepted, 'logical');
            end
            if isfield(json, 'parent_info')
                obj.props_('parent_info') = flywheel.model.JobDetailParentInfo.fromJson(json.parent_info, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobAskResponseJob')
                    obj = flywheel.model.JobAskResponseJob(obj);
                end
                if isKey(obj.props_, 'compute_provider_id')
                end
                if isKey(obj.props_, 'failure_reason')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'priority')
                    obj.props_('priority') =  flywheel.model.AllOfJobAskResponseJobPriority.ensureIsInstance(obj.props_('priority'));
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'parents')
                    obj.props_('parents') =  flywheel.model.JobParents.ensureIsInstance(obj.props_('parents'));
                end
                if isKey(obj.props_, 'produced_metadata')
                end
                if isKey(obj.props_, 'related_container_ids')
                end
                if isKey(obj.props_, 'request')
                    obj.props_('request') =  flywheel.model.JobRequest.ensureIsInstance(obj.props_('request'));
                end
                if isKey(obj.props_, 'retried')
                end
                if isKey(obj.props_, 'saved_files')
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.JobState.ensureIsInstance(obj.props_('state'));
                end
                if isKey(obj.props_, 'profile')
                    obj.props_('profile') =  flywheel.model.JobProfile.ensureIsInstance(obj.props_('profile'));
                end
                if isKey(obj.props_, 'transitions')
                    obj.props_('transitions') =  flywheel.model.AllOfJobAskResponseJobTransitions.ensureIsInstance(obj.props_('transitions'));
                end
                if isKey(obj.props_, 'gear_id')
                end
                if isKey(obj.props_, 'gear_info')
                    obj.props_('gear_info') =  flywheel.model.GearInfo.ensureIsInstance(obj.props_('gear_info'));
                end
                if isKey(obj.props_, 'rule_id')
                end
                if isKey(obj.props_, 'role_id')
                end
                if isKey(obj.props_, 'inputs')
                    obj.props_('inputs') =  flywheel.model.Object.ensureIsInstance(obj.props_('inputs'));
                end
                if isKey(obj.props_, 'legacy_inputs')
                    obj.props_('legacy_inputs') = flywheel.ModelBase.cellmap(@flywheel.model.LegacyInput.ensureIsInstance, obj.props_('legacy_inputs'));
                end
                if isKey(obj.props_, 'destination')
                    obj.props_('destination') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('destination'));
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'attempt')
                end
                if isKey(obj.props_, 'previous_job_id')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'batch')
                end
                if isKey(obj.props_, 'failed_output_accepted')
                end
                if isKey(obj.props_, 'parent_info')
                    obj.props_('parent_info') =  flywheel.model.JobDetailParentInfo.ensureIsInstance(obj.props_('parent_info'));
                end
            end
        end
    end
end
