% JobAskReturnCriteria - Model that specifies what to return  Attributes:     jobs (int): The number of jobs to return     peek (bool): Whether to start the jobs or not     states (bool): To return the jobs by state object     encoded (bool): To return the request urls for the jobs encoded. The uri is         always stored in the persistence layer encoded, however if encoded is false,         the uri's will be decoded in the handler layer for the response
%
% JobAskReturnCriteria Properties:
%    jobs    
%    peek    
%    states  
%    encoded 
%
% JobAskReturnCriteria Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobAskReturnCriteria < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'jobs', 'peek', 'states', 'encoded' }, ...
            { 'jobs', 'peek', 'states', 'encoded' });
    end
    properties(Dependent)
        jobs
        peek
        states
        encoded
    end
    methods
        function obj = JobAskReturnCriteria(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobAskReturnCriteria.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'jobs', 0);
                addParameter(p, 'peek', false);
                addParameter(p, 'states', false);
                addParameter(p, 'encoded', false);

                parse(p, varargin{:});

                if ~isempty(p.Results.jobs)
                    obj.props_('jobs') = p.Results.jobs;
                end
                if ~isempty(p.Results.peek)
                    obj.props_('peek') = p.Results.peek;
                end
                if ~isempty(p.Results.states)
                    obj.props_('states') = p.Results.states;
                end
                if ~isempty(p.Results.encoded)
                    obj.props_('encoded') = p.Results.encoded;
                end
            end
        end
        function result = get.jobs(obj)
            if ismethod(obj, 'get_jobs')
                result = obj.get_jobs();
            else
                if isKey(obj.props_, 'jobs')
                    result = obj.props_('jobs');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobs(obj, value)
            obj.props_('jobs') = value;
        end
        function result = get.peek(obj)
            if ismethod(obj, 'get_peek')
                result = obj.get_peek();
            else
                if isKey(obj.props_, 'peek')
                    result = obj.props_('peek');
                else
                    result = [];
                end
            end
        end
        function obj = set.peek(obj, value)
            obj.props_('peek') = value;
        end
        function result = get.states(obj)
            if ismethod(obj, 'get_states')
                result = obj.get_states();
            else
                if isKey(obj.props_, 'states')
                    result = obj.props_('states');
                else
                    result = [];
                end
            end
        end
        function obj = set.states(obj, value)
            obj.props_('states') = value;
        end
        function result = get.encoded(obj)
            if ismethod(obj, 'get_encoded')
                result = obj.get_encoded();
            else
                if isKey(obj.props_, 'encoded')
                    result = obj.props_('encoded');
                else
                    result = [];
                end
            end
        end
        function obj = set.encoded(obj, value)
            obj.props_('encoded') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'jobs')
                result('jobs') = flywheel.ModelBase.serializeValue(obj.props_('jobs'), 'integer');
            end
            if isKey(obj.props_, 'peek')
                result('peek') = flywheel.ModelBase.serializeValue(obj.props_('peek'), 'logical');
            end
            if isKey(obj.props_, 'states')
                result('states') = flywheel.ModelBase.serializeValue(obj.props_('states'), 'logical');
            end
            if isKey(obj.props_, 'encoded')
                result('encoded') = flywheel.ModelBase.serializeValue(obj.props_('encoded'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'jobs')
                result.jobs = obj.props_('jobs');
            else
                result.jobs = [];
            end
            if isKey(obj.props_, 'peek')
                result.peek = obj.props_('peek');
            else
                result.peek = [];
            end
            if isKey(obj.props_, 'states')
                result.states = obj.props_('states');
            else
                result.states = [];
            end
            if isKey(obj.props_, 'encoded')
                result.encoded = obj.props_('encoded');
            else
                result.encoded = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'jobs')
                    propList.jobs = obj.props_('jobs');
                else
                    propList.jobs = [];
                end
                if isKey(obj.props_, 'peek')
                    propList.peek = obj.props_('peek');
                else
                    propList.peek = [];
                end
                if isKey(obj.props_, 'states')
                    propList.states = obj.props_('states');
                else
                    propList.states = [];
                end
                if isKey(obj.props_, 'encoded')
                    propList.encoded = obj.props_('encoded');
                else
                    propList.encoded = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobAskReturnCriteria;
            if isfield(json, 'jobs')
                obj.props_('jobs') = flywheel.ModelBase.deserializeValue(json.jobs, 'integer');
            end
            if isfield(json, 'peek')
                obj.props_('peek') = flywheel.ModelBase.deserializeValue(json.peek, 'logical');
            end
            if isfield(json, 'states')
                obj.props_('states') = flywheel.ModelBase.deserializeValue(json.states, 'logical');
            end
            if isfield(json, 'encoded')
                obj.props_('encoded') = flywheel.ModelBase.deserializeValue(json.encoded, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobAskReturnCriteria')
                    obj = flywheel.model.JobAskReturnCriteria(obj);
                end
                if isKey(obj.props_, 'jobs')
                end
                if isKey(obj.props_, 'peek')
                end
                if isKey(obj.props_, 'states')
                end
                if isKey(obj.props_, 'encoded')
                end
            end
        end
    end
end
