% JobComplete - Payload required to complete a job using a ticket  Attributes:     success (bool): Did the job complete successfully     failure_reason (Optional[str]): If the job failed, a short description          as to why     profile (Optional[JobProfile]): An update to the job profile
%
% JobComplete Properties:
%    success       
%    failureReason 
%    profile       
%
% JobComplete Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobComplete < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'success', 'failureReason', 'profile' }, ...
            { 'success', 'failure_reason', 'profile' });
    end
    properties(Dependent)
        success
        failureReason
        profile
    end
    methods
        function obj = JobComplete(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobComplete.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'success', []);
                addParameter(p, 'failureReason', []);
                addParameter(p, 'profile', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.success)
                    obj.props_('success') = p.Results.success;
                end
                if ~isempty(p.Results.failureReason)
                    obj.props_('failure_reason') = p.Results.failureReason;
                end
                if ~isempty(p.Results.profile)
                    obj.props_('profile') = p.Results.profile;
                end
            end
        end
        function result = get.success(obj)
            if ismethod(obj, 'get_success')
                result = obj.get_success();
            else
                if isKey(obj.props_, 'success')
                    result = obj.props_('success');
                else
                    result = [];
                end
            end
        end
        function obj = set.success(obj, value)
            obj.props_('success') = value;
        end
        function result = get.failureReason(obj)
            if ismethod(obj, 'get_failureReason')
                result = obj.get_failureReason();
            else
                if isKey(obj.props_, 'failure_reason')
                    result = obj.props_('failure_reason');
                else
                    result = [];
                end
            end
        end
        function obj = set.failureReason(obj, value)
            obj.props_('failure_reason') = value;
        end
        function result = get.profile(obj)
            if ismethod(obj, 'get_profile')
                result = obj.get_profile();
            else
                if isKey(obj.props_, 'profile')
                    result = obj.props_('profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.profile(obj, value)
            obj.props_('profile') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'success')
                result('success') = flywheel.ModelBase.serializeValue(obj.props_('success'), 'logical');
            end
            if isKey(obj.props_, 'failure_reason')
                result('failure_reason') = flywheel.ModelBase.serializeValue(obj.props_('failure_reason'), 'char');
            end
            if isKey(obj.props_, 'profile')
                result('profile') = obj.props_('profile').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'success')
                result.success = obj.props_('success');
            else
                result.success = [];
            end
            if isKey(obj.props_, 'failure_reason')
                result.failureReason = obj.props_('failure_reason');
            else
                result.failureReason = [];
            end
            if isKey(obj.props_, 'profile')
                result.profile = struct(obj.props_('profile'));
            else
                result.profile = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'success')
                    propList.success = obj.props_('success');
                else
                    propList.success = [];
                end
                if isKey(obj.props_, 'failure_reason')
                    propList.failureReason = obj.props_('failure_reason');
                else
                    propList.failureReason = [];
                end
                if isKey(obj.props_, 'profile')
                    propList.profile = obj.props_('profile');
                else
                    propList.profile = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobComplete;
            if isfield(json, 'success')
                obj.props_('success') = flywheel.ModelBase.deserializeValue(json.success, 'logical');
            end
            if isfield(json, 'failure_reason')
                obj.props_('failure_reason') = flywheel.ModelBase.deserializeValue(json.failure_reason, 'char');
            end
            if isfield(json, 'profile')
                obj.props_('profile') = flywheel.model.InputJobProfile.fromJson(json.profile, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobComplete')
                    obj = flywheel.model.JobComplete(obj);
                end
                if isKey(obj.props_, 'success')
                end
                if isKey(obj.props_, 'failure_reason')
                end
                if isKey(obj.props_, 'profile')
                    obj.props_('profile') =  flywheel.model.InputJobProfile.ensureIsInstance(obj.props_('profile'));
                end
            end
        end
    end
end
