% JobConfigInput - Represents the properties of a job  Attributes:     group (Optional[str]): The group id of the job to match     gear_name (Optional[str]): The gear name of the job to match     tag (Optional[str]): A tag value of the job to match     compute_provider (Optional[str]): The id of the compute provider of the         job to match     created_by (Optional[str]): The id of the origin of the job to match
%
% JobConfigInput Properties:
%    group           
%    gearName        
%    tag             
%    computeProvider 
%    createdBy       
%
% JobConfigInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobConfigInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'group', 'gearName', 'tag', 'computeProvider', 'createdBy' }, ...
            { 'group', 'gear-name', 'tag', 'compute-provider', 'created-by' });
    end
    properties(Dependent)
        group
        gearName
        tag
        computeProvider
        createdBy
    end
    methods
        function obj = JobConfigInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobConfigInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'group', []);
                addParameter(p, 'gearName', []);
                addParameter(p, 'tag', []);
                addParameter(p, 'computeProvider', []);
                addParameter(p, 'createdBy', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.gearName)
                    obj.props_('gear-name') = p.Results.gearName;
                end
                if ~isempty(p.Results.tag)
                    obj.props_('tag') = p.Results.tag;
                end
                if ~isempty(p.Results.computeProvider)
                    obj.props_('compute-provider') = p.Results.computeProvider;
                end
                if ~isempty(p.Results.createdBy)
                    obj.props_('created-by') = p.Results.createdBy;
                end
            end
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.gearName(obj)
            if ismethod(obj, 'get_gearName')
                result = obj.get_gearName();
            else
                if isKey(obj.props_, 'gear-name')
                    result = obj.props_('gear-name');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearName(obj, value)
            obj.props_('gear-name') = value;
        end
        function result = get.tag(obj)
            if ismethod(obj, 'get_tag')
                result = obj.get_tag();
            else
                if isKey(obj.props_, 'tag')
                    result = obj.props_('tag');
                else
                    result = [];
                end
            end
        end
        function obj = set.tag(obj, value)
            obj.props_('tag') = value;
        end
        function result = get.computeProvider(obj)
            if ismethod(obj, 'get_computeProvider')
                result = obj.get_computeProvider();
            else
                if isKey(obj.props_, 'compute-provider')
                    result = obj.props_('compute-provider');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeProvider(obj, value)
            obj.props_('compute-provider') = value;
        end
        function result = get.createdBy(obj)
            if ismethod(obj, 'get_createdBy')
                result = obj.get_createdBy();
            else
                if isKey(obj.props_, 'created-by')
                    result = obj.props_('created-by');
                else
                    result = [];
                end
            end
        end
        function obj = set.createdBy(obj, value)
            obj.props_('created-by') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'vector[char]');
            end
            if isKey(obj.props_, 'gear-name')
                result('gear-name') = flywheel.ModelBase.serializeValue(obj.props_('gear-name'), 'vector[char]');
            end
            if isKey(obj.props_, 'tag')
                result('tag') = flywheel.ModelBase.serializeValue(obj.props_('tag'), 'vector[char]');
            end
            if isKey(obj.props_, 'compute-provider')
                result('compute-provider') = flywheel.ModelBase.serializeValue(obj.props_('compute-provider'), 'vector[char]');
            end
            if isKey(obj.props_, 'created-by')
                result('created-by') = flywheel.ModelBase.serializeValue(obj.props_('created-by'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'gear-name')
                result.gearName = obj.props_('gear-name');
            else
                result.gearName = [];
            end
            if isKey(obj.props_, 'tag')
                result.tag = obj.props_('tag');
            else
                result.tag = [];
            end
            if isKey(obj.props_, 'compute-provider')
                result.computeProvider = obj.props_('compute-provider');
            else
                result.computeProvider = [];
            end
            if isKey(obj.props_, 'created-by')
                result.createdBy = obj.props_('created-by');
            else
                result.createdBy = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'gear-name')
                    propList.gearName = obj.props_('gear-name');
                else
                    propList.gearName = [];
                end
                if isKey(obj.props_, 'tag')
                    propList.tag = obj.props_('tag');
                else
                    propList.tag = [];
                end
                if isKey(obj.props_, 'compute-provider')
                    propList.computeProvider = obj.props_('compute-provider');
                else
                    propList.computeProvider = [];
                end
                if isKey(obj.props_, 'created-by')
                    propList.createdBy = obj.props_('created-by');
                else
                    propList.createdBy = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobConfigInput;
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'vector[char]');
            end
            if isfield(json, 'gear0x2Dname')
                obj.props_('gear-name') = flywheel.ModelBase.deserializeValue(json.gear0x2Dname, 'vector[char]');
            end
            if isfield(json, 'tag')
                obj.props_('tag') = flywheel.ModelBase.deserializeValue(json.tag, 'vector[char]');
            end
            if isfield(json, 'compute0x2Dprovider')
                obj.props_('compute-provider') = flywheel.ModelBase.deserializeValue(json.compute0x2Dprovider, 'vector[char]');
            end
            if isfield(json, 'created0x2Dby')
                obj.props_('created-by') = flywheel.ModelBase.deserializeValue(json.created0x2Dby, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobConfigInput')
                    obj = flywheel.model.JobConfigInput(obj);
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'gear-name')
                end
                if isKey(obj.props_, 'tag')
                end
                if isKey(obj.props_, 'compute-provider')
                end
                if isKey(obj.props_, 'created-by')
                end
            end
        end
    end
end
