% JobExecutorInfo
%
% JobExecutorInfo Properties:
%    name          - A machine or instance name, possibly a FQDN
%    host          - The hostname or (more likely) IP address of the engine instance
%    instanceType  - A free form string describing the instance type
%    cpuCores      - The number of CPU cores
%    gpu           - Whether or not a GPU is available
%    memoryBytes   - The amount of memory on the system, in bytes
%    diskBytes     - The size of the hard disk on the system, in bytes
%    swapBytes     - The available swap space, in bytes
%
% JobExecutorInfo Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobExecutorInfo < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'name', 'host', 'instanceType', 'cpuCores', 'gpu', 'memoryBytes', 'diskBytes', 'swapBytes' }, ...
            { 'name', 'host', 'instance_type', 'cpu_cores', 'gpu', 'memory_bytes', 'disk_bytes', 'swap_bytes' });
    end
    properties(Dependent)
        name
        host
        instanceType
        cpuCores
        gpu
        memoryBytes
        diskBytes
        swapBytes
    end
    methods
        function obj = JobExecutorInfo(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobExecutorInfo.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'name', []);
                addParameter(p, 'host', []);
                addParameter(p, 'instanceType', []);
                addParameter(p, 'cpuCores', []);
                addParameter(p, 'gpu', []);
                addParameter(p, 'memoryBytes', []);
                addParameter(p, 'diskBytes', []);
                addParameter(p, 'swapBytes', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.host)
                    obj.props_('host') = p.Results.host;
                end
                if ~isempty(p.Results.instanceType)
                    obj.props_('instance_type') = p.Results.instanceType;
                end
                if ~isempty(p.Results.cpuCores)
                    obj.props_('cpu_cores') = p.Results.cpuCores;
                end
                if ~isempty(p.Results.gpu)
                    obj.props_('gpu') = p.Results.gpu;
                end
                if ~isempty(p.Results.memoryBytes)
                    obj.props_('memory_bytes') = p.Results.memoryBytes;
                end
                if ~isempty(p.Results.diskBytes)
                    obj.props_('disk_bytes') = p.Results.diskBytes;
                end
                if ~isempty(p.Results.swapBytes)
                    obj.props_('swap_bytes') = p.Results.swapBytes;
                end
            end
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.host(obj)
            if ismethod(obj, 'get_host')
                result = obj.get_host();
            else
                if isKey(obj.props_, 'host')
                    result = obj.props_('host');
                else
                    result = [];
                end
            end
        end
        function obj = set.host(obj, value)
            obj.props_('host') = value;
        end
        function result = get.instanceType(obj)
            if ismethod(obj, 'get_instanceType')
                result = obj.get_instanceType();
            else
                if isKey(obj.props_, 'instance_type')
                    result = obj.props_('instance_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.instanceType(obj, value)
            obj.props_('instance_type') = value;
        end
        function result = get.cpuCores(obj)
            if ismethod(obj, 'get_cpuCores')
                result = obj.get_cpuCores();
            else
                if isKey(obj.props_, 'cpu_cores')
                    result = obj.props_('cpu_cores');
                else
                    result = [];
                end
            end
        end
        function obj = set.cpuCores(obj, value)
            obj.props_('cpu_cores') = value;
        end
        function result = get.gpu(obj)
            if ismethod(obj, 'get_gpu')
                result = obj.get_gpu();
            else
                if isKey(obj.props_, 'gpu')
                    result = obj.props_('gpu');
                else
                    result = [];
                end
            end
        end
        function obj = set.gpu(obj, value)
            obj.props_('gpu') = value;
        end
        function result = get.memoryBytes(obj)
            if ismethod(obj, 'get_memoryBytes')
                result = obj.get_memoryBytes();
            else
                if isKey(obj.props_, 'memory_bytes')
                    result = obj.props_('memory_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.memoryBytes(obj, value)
            obj.props_('memory_bytes') = value;
        end
        function result = get.diskBytes(obj)
            if ismethod(obj, 'get_diskBytes')
                result = obj.get_diskBytes();
            else
                if isKey(obj.props_, 'disk_bytes')
                    result = obj.props_('disk_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.diskBytes(obj, value)
            obj.props_('disk_bytes') = value;
        end
        function result = get.swapBytes(obj)
            if ismethod(obj, 'get_swapBytes')
                result = obj.get_swapBytes();
            else
                if isKey(obj.props_, 'swap_bytes')
                    result = obj.props_('swap_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.swapBytes(obj, value)
            obj.props_('swap_bytes') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'host')
                result('host') = flywheel.ModelBase.serializeValue(obj.props_('host'), 'char');
            end
            if isKey(obj.props_, 'instance_type')
                result('instance_type') = flywheel.ModelBase.serializeValue(obj.props_('instance_type'), 'char');
            end
            if isKey(obj.props_, 'cpu_cores')
                result('cpu_cores') = flywheel.ModelBase.serializeValue(obj.props_('cpu_cores'), 'integer');
            end
            if isKey(obj.props_, 'gpu')
                result('gpu') = flywheel.ModelBase.serializeValue(obj.props_('gpu'), 'logical');
            end
            if isKey(obj.props_, 'memory_bytes')
                result('memory_bytes') = flywheel.ModelBase.serializeValue(obj.props_('memory_bytes'), 'integer');
            end
            if isKey(obj.props_, 'disk_bytes')
                result('disk_bytes') = flywheel.ModelBase.serializeValue(obj.props_('disk_bytes'), 'integer');
            end
            if isKey(obj.props_, 'swap_bytes')
                result('swap_bytes') = flywheel.ModelBase.serializeValue(obj.props_('swap_bytes'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'host')
                result.host = obj.props_('host');
            else
                result.host = [];
            end
            if isKey(obj.props_, 'instance_type')
                result.instanceType = obj.props_('instance_type');
            else
                result.instanceType = [];
            end
            if isKey(obj.props_, 'cpu_cores')
                result.cpuCores = obj.props_('cpu_cores');
            else
                result.cpuCores = [];
            end
            if isKey(obj.props_, 'gpu')
                result.gpu = obj.props_('gpu');
            else
                result.gpu = [];
            end
            if isKey(obj.props_, 'memory_bytes')
                result.memoryBytes = obj.props_('memory_bytes');
            else
                result.memoryBytes = [];
            end
            if isKey(obj.props_, 'disk_bytes')
                result.diskBytes = obj.props_('disk_bytes');
            else
                result.diskBytes = [];
            end
            if isKey(obj.props_, 'swap_bytes')
                result.swapBytes = obj.props_('swap_bytes');
            else
                result.swapBytes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'host')
                    propList.host = obj.props_('host');
                else
                    propList.host = [];
                end
                if isKey(obj.props_, 'instance_type')
                    propList.instanceType = obj.props_('instance_type');
                else
                    propList.instanceType = [];
                end
                if isKey(obj.props_, 'cpu_cores')
                    propList.cpuCores = obj.props_('cpu_cores');
                else
                    propList.cpuCores = [];
                end
                if isKey(obj.props_, 'gpu')
                    propList.gpu = obj.props_('gpu');
                else
                    propList.gpu = [];
                end
                if isKey(obj.props_, 'memory_bytes')
                    propList.memoryBytes = obj.props_('memory_bytes');
                else
                    propList.memoryBytes = [];
                end
                if isKey(obj.props_, 'disk_bytes')
                    propList.diskBytes = obj.props_('disk_bytes');
                else
                    propList.diskBytes = [];
                end
                if isKey(obj.props_, 'swap_bytes')
                    propList.swapBytes = obj.props_('swap_bytes');
                else
                    propList.swapBytes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobExecutorInfo;
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'host')
                obj.props_('host') = flywheel.ModelBase.deserializeValue(json.host, 'char');
            end
            if isfield(json, 'instance_type')
                obj.props_('instance_type') = flywheel.ModelBase.deserializeValue(json.instance_type, 'char');
            end
            if isfield(json, 'cpu_cores')
                obj.props_('cpu_cores') = flywheel.ModelBase.deserializeValue(json.cpu_cores, 'integer');
            end
            if isfield(json, 'gpu')
                obj.props_('gpu') = flywheel.ModelBase.deserializeValue(json.gpu, 'logical');
            end
            if isfield(json, 'memory_bytes')
                obj.props_('memory_bytes') = flywheel.ModelBase.deserializeValue(json.memory_bytes, 'integer');
            end
            if isfield(json, 'disk_bytes')
                obj.props_('disk_bytes') = flywheel.ModelBase.deserializeValue(json.disk_bytes, 'integer');
            end
            if isfield(json, 'swap_bytes')
                obj.props_('swap_bytes') = flywheel.ModelBase.deserializeValue(json.swap_bytes, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobExecutorInfo')
                    obj = flywheel.model.JobExecutorInfo(obj);
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'host')
                end
                if isKey(obj.props_, 'instance_type')
                end
                if isKey(obj.props_, 'cpu_cores')
                end
                if isKey(obj.props_, 'gpu')
                end
                if isKey(obj.props_, 'memory_bytes')
                end
                if isKey(obj.props_, 'disk_bytes')
                end
                if isKey(obj.props_, 'swap_bytes')
                end
            end
        end
    end
end
