% JobFileInputListOutput
%
% JobFileInputListOutput Properties:
%    hierarchy 
%    object    
%    location  
%    base      
%
% JobFileInputListOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobFileInputListOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'hierarchy', 'object', 'location', 'base' }, ...
            { 'hierarchy', 'object', 'location', 'base' });
    end
    properties(Dependent)
        hierarchy
        object
        location
        base
    end
    methods
        function obj = JobFileInputListOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobFileInputListOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'hierarchy', []);
                addParameter(p, 'object', []);
                addParameter(p, 'location', []);
                addParameter(p, 'base', &#x27;file&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.hierarchy)
                    obj.props_('hierarchy') = p.Results.hierarchy;
                end
                if ~isempty(p.Results.object)
                    obj.props_('object') = p.Results.object;
                end
                if ~isempty(p.Results.location)
                    obj.props_('location') = p.Results.location;
                end
                if ~isempty(p.Results.base)
                    obj.props_('base') = p.Results.base;
                end
            end
        end
        function result = get.hierarchy(obj)
            if ismethod(obj, 'get_hierarchy')
                result = obj.get_hierarchy();
            else
                if isKey(obj.props_, 'hierarchy')
                    result = obj.props_('hierarchy');
                else
                    result = [];
                end
            end
        end
        function obj = set.hierarchy(obj, value)
            obj.props_('hierarchy') = value;
        end
        function result = get.object(obj)
            if ismethod(obj, 'get_object')
                result = obj.get_object();
            else
                if isKey(obj.props_, 'object')
                    result = obj.props_('object');
                else
                    result = [];
                end
            end
        end
        function obj = set.object(obj, value)
            obj.props_('object') = value;
        end
        function result = get.location(obj)
            if ismethod(obj, 'get_location')
                result = obj.get_location();
            else
                if isKey(obj.props_, 'location')
                    result = obj.props_('location');
                else
                    result = [];
                end
            end
        end
        function obj = set.location(obj, value)
            obj.props_('location') = value;
        end
        function result = get.base(obj)
            if ismethod(obj, 'get_base')
                result = obj.get_base();
            else
                if isKey(obj.props_, 'base')
                    result = obj.props_('base');
                else
                    result = [];
                end
            end
        end
        function obj = set.base(obj, value)
            obj.props_('base') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'hierarchy')
                result('hierarchy') = obj.props_('hierarchy').toJson();
            end
            if isKey(obj.props_, 'object')
                result('object') = obj.props_('object').toJson();
            end
            if isKey(obj.props_, 'location')
                result('location') = obj.props_('location').toJson();
            end
            if isKey(obj.props_, 'base')
                result('base') = flywheel.ModelBase.serializeValue(obj.props_('base'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'hierarchy')
                result.hierarchy = struct(obj.props_('hierarchy'));
            else
                result.hierarchy = [];
            end
            if isKey(obj.props_, 'object')
                result.object = struct(obj.props_('object'));
            else
                result.object = [];
            end
            if isKey(obj.props_, 'location')
                result.location = struct(obj.props_('location'));
            else
                result.location = [];
            end
            if isKey(obj.props_, 'base')
                result.base = obj.props_('base');
            else
                result.base = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'hierarchy')
                    propList.hierarchy = obj.props_('hierarchy');
                else
                    propList.hierarchy = [];
                end
                if isKey(obj.props_, 'object')
                    propList.object = obj.props_('object');
                else
                    propList.object = [];
                end
                if isKey(obj.props_, 'location')
                    propList.location = obj.props_('location');
                else
                    propList.location = [];
                end
                if isKey(obj.props_, 'base')
                    propList.base = obj.props_('base');
                else
                    propList.base = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobFileInputListOutput;
            if isfield(json, 'hierarchy')
                obj.props_('hierarchy') = flywheel.model.ContainerReference.fromJson(json.hierarchy, context);
            end
            if isfield(json, 'object')
                obj.props_('object') = flywheel.model.JobFileObjectListOutput.fromJson(json.object, context);
            end
            if isfield(json, 'location')
                obj.props_('location') = flywheel.model.Location.fromJson(json.location, context);
            end
            if isfield(json, 'base')
                obj.props_('base') = flywheel.ModelBase.deserializeValue(json.base, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobFileInputListOutput')
                    obj = flywheel.model.JobFileInputListOutput(obj);
                end
                if isKey(obj.props_, 'hierarchy')
                    obj.props_('hierarchy') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('hierarchy'));
                end
                if isKey(obj.props_, 'object')
                    obj.props_('object') =  flywheel.model.JobFileObjectListOutput.ensureIsInstance(obj.props_('object'));
                end
                if isKey(obj.props_, 'location')
                    obj.props_('location') =  flywheel.model.Location.ensureIsInstance(obj.props_('location'));
                end
                if isKey(obj.props_, 'base')
                end
            end
        end
    end
end
