% JobFileObject
%
% JobFileObject Properties:
%    type           
%    mimetype       
%    modality       
%    classification 
%    tags           
%    info           
%    size           
%    zipMemberCount 
%    version        
%    fileId         
%    origin         
%
% JobFileObject Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobFileObject < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'type', 'mimetype', 'modality', 'classification', 'tags', 'info', 'size', 'zipMemberCount', 'version', 'fileId', 'origin' }, ...
            { 'type', 'mimetype', 'modality', 'classification', 'tags', 'info', 'size', 'zip_member_count', 'version', 'file_id', 'origin' });
    end
    properties(Dependent)
        type
        mimetype
        modality
        classification
        tags
        info
        size
        zipMemberCount
        version
        fileId
        origin
    end
    methods
        function obj = JobFileObject(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobFileObject.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'type', []);
                addParameter(p, 'mimetype', []);
                addParameter(p, 'modality', []);
                addParameter(p, 'classification', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'info', []);
                addParameter(p, 'size', []);
                addParameter(p, 'zipMemberCount', []);
                addParameter(p, 'version', []);
                addParameter(p, 'fileId', []);
                addParameter(p, 'origin', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.mimetype)
                    obj.props_('mimetype') = p.Results.mimetype;
                end
                if ~isempty(p.Results.modality)
                    obj.props_('modality') = p.Results.modality;
                end
                if ~isempty(p.Results.classification)
                    obj.props_('classification') = p.Results.classification;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
                if ~isempty(p.Results.zipMemberCount)
                    obj.props_('zip_member_count') = p.Results.zipMemberCount;
                end
                if ~isempty(p.Results.version)
                    obj.props_('version') = p.Results.version;
                end
                if ~isempty(p.Results.fileId)
                    obj.props_('file_id') = p.Results.fileId;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
            end
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.mimetype(obj)
            if ismethod(obj, 'get_mimetype')
                result = obj.get_mimetype();
            else
                if isKey(obj.props_, 'mimetype')
                    result = obj.props_('mimetype');
                else
                    result = [];
                end
            end
        end
        function obj = set.mimetype(obj, value)
            obj.props_('mimetype') = value;
        end
        function result = get.modality(obj)
            if ismethod(obj, 'get_modality')
                result = obj.get_modality();
            else
                if isKey(obj.props_, 'modality')
                    result = obj.props_('modality');
                else
                    result = [];
                end
            end
        end
        function obj = set.modality(obj, value)
            obj.props_('modality') = value;
        end
        function result = get.classification(obj)
            if ismethod(obj, 'get_classification')
                result = obj.get_classification();
            else
                if isKey(obj.props_, 'classification')
                    result = obj.props_('classification');
                else
                    result = [];
                end
            end
        end
        function obj = set.classification(obj, value)
            obj.props_('classification') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = get.zipMemberCount(obj)
            if ismethod(obj, 'get_zipMemberCount')
                result = obj.get_zipMemberCount();
            else
                if isKey(obj.props_, 'zip_member_count')
                    result = obj.props_('zip_member_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.zipMemberCount(obj, value)
            obj.props_('zip_member_count') = value;
        end
        function result = get.version(obj)
            if ismethod(obj, 'get_version')
                result = obj.get_version();
            else
                if isKey(obj.props_, 'version')
                    result = obj.props_('version');
                else
                    result = [];
                end
            end
        end
        function obj = set.version(obj, value)
            obj.props_('version') = value;
        end
        function result = get.fileId(obj)
            if ismethod(obj, 'get_fileId')
                result = obj.get_fileId();
            else
                if isKey(obj.props_, 'file_id')
                    result = obj.props_('file_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileId(obj, value)
            obj.props_('file_id') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'mimetype')
                result('mimetype') = flywheel.ModelBase.serializeValue(obj.props_('mimetype'), 'char');
            end
            if isKey(obj.props_, 'modality')
                result('modality') = flywheel.ModelBase.serializeValue(obj.props_('modality'), 'char');
            end
            if isKey(obj.props_, 'classification')
                result('classification') = flywheel.ModelBase.serializeValue(obj.props_('classification'), 'containers.Map');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
            if isKey(obj.props_, 'zip_member_count')
                result('zip_member_count') = flywheel.ModelBase.serializeValue(obj.props_('zip_member_count'), 'integer');
            end
            if isKey(obj.props_, 'version')
                result('version') = flywheel.ModelBase.serializeValue(obj.props_('version'), 'integer');
            end
            if isKey(obj.props_, 'file_id')
                result('file_id') = flywheel.ModelBase.serializeValue(obj.props_('file_id'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'mimetype')
                result.mimetype = obj.props_('mimetype');
            else
                result.mimetype = [];
            end
            if isKey(obj.props_, 'modality')
                result.modality = obj.props_('modality');
            else
                result.modality = [];
            end
            if isKey(obj.props_, 'classification')
                result.classification = obj.props_('classification');
            else
                result.classification = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
            if isKey(obj.props_, 'zip_member_count')
                result.zipMemberCount = obj.props_('zip_member_count');
            else
                result.zipMemberCount = [];
            end
            if isKey(obj.props_, 'version')
                result.version = obj.props_('version');
            else
                result.version = [];
            end
            if isKey(obj.props_, 'file_id')
                result.fileId = obj.props_('file_id');
            else
                result.fileId = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'mimetype')
                    propList.mimetype = obj.props_('mimetype');
                else
                    propList.mimetype = [];
                end
                if isKey(obj.props_, 'modality')
                    propList.modality = obj.props_('modality');
                else
                    propList.modality = [];
                end
                if isKey(obj.props_, 'classification')
                    propList.classification = obj.props_('classification');
                else
                    propList.classification = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                if isKey(obj.props_, 'zip_member_count')
                    propList.zipMemberCount = obj.props_('zip_member_count');
                else
                    propList.zipMemberCount = [];
                end
                if isKey(obj.props_, 'version')
                    propList.version = obj.props_('version');
                else
                    propList.version = [];
                end
                if isKey(obj.props_, 'file_id')
                    propList.fileId = obj.props_('file_id');
                else
                    propList.fileId = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobFileObject;
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'mimetype')
                obj.props_('mimetype') = flywheel.ModelBase.deserializeValue(json.mimetype, 'char');
            end
            if isfield(json, 'modality')
                obj.props_('modality') = flywheel.ModelBase.deserializeValue(json.modality, 'char');
            end
            if isfield(json, 'classification')
                obj.props_('classification') = flywheel.ModelBase.deserializeValue(json.classification, 'containers.Map');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isfield(json, 'zip_member_count')
                obj.props_('zip_member_count') = flywheel.ModelBase.deserializeValue(json.zip_member_count, 'integer');
            end
            if isfield(json, 'version')
                obj.props_('version') = flywheel.ModelBase.deserializeValue(json.version, 'integer');
            end
            if isfield(json, 'file_id')
                obj.props_('file_id') = flywheel.ModelBase.deserializeValue(json.file_id, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobFileObject')
                    obj = flywheel.model.JobFileObject(obj);
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'mimetype')
                end
                if isKey(obj.props_, 'modality')
                end
                if isKey(obj.props_, 'classification')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'info')
                end
                if isKey(obj.props_, 'size')
                end
                if isKey(obj.props_, 'zip_member_count')
                end
                if isKey(obj.props_, 'version')
                end
                if isKey(obj.props_, 'file_id')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
            end
        end
    end
end
