% JobInputsItem
%
% JobInputsItem Properties:
%    type     
%    uri      
%    location 
%    vu       
%
% JobInputsItem Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobInputsItem < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'type', 'uri', 'location', 'vu' }, ...
            { 'type', 'uri', 'location', 'vu' });
    end
    properties(Dependent)
        type
        uri
        location
        vu
    end
    methods
        function obj = JobInputsItem(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobInputsItem.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'type', []);
                addParameter(p, 'uri', []);
                addParameter(p, 'location', []);
                addParameter(p, 'vu', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.uri)
                    obj.props_('uri') = p.Results.uri;
                end
                if ~isempty(p.Results.location)
                    obj.props_('location') = p.Results.location;
                end
                if ~isempty(p.Results.vu)
                    obj.props_('vu') = p.Results.vu;
                end
            end
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.uri(obj)
            if ismethod(obj, 'get_uri')
                result = obj.get_uri();
            else
                if isKey(obj.props_, 'uri')
                    result = obj.props_('uri');
                else
                    result = [];
                end
            end
        end
        function obj = set.uri(obj, value)
            obj.props_('uri') = value;
        end
        function result = get.location(obj)
            if ismethod(obj, 'get_location')
                result = obj.get_location();
            else
                if isKey(obj.props_, 'location')
                    result = obj.props_('location');
                else
                    result = [];
                end
            end
        end
        function obj = set.location(obj, value)
            obj.props_('location') = value;
        end
        function result = get.vu(obj)
            if ismethod(obj, 'get_vu')
                result = obj.get_vu();
            else
                if isKey(obj.props_, 'vu')
                    result = obj.props_('vu');
                else
                    result = [];
                end
            end
        end
        function obj = set.vu(obj, value)
            obj.props_('vu') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'type')
                result('type') = flywheel.ModelBase.serializeValue(obj.props_('type'), 'char');
            end
            if isKey(obj.props_, 'uri')
                result('uri') = flywheel.ModelBase.serializeValue(obj.props_('uri'), 'char');
            end
            if isKey(obj.props_, 'location')
                result('location') = flywheel.ModelBase.serializeValue(obj.props_('location'), 'char');
            end
            if isKey(obj.props_, 'vu')
                result('vu') = flywheel.ModelBase.serializeValue(obj.props_('vu'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'type')
                result.type = obj.props_('type');
            else
                result.type = [];
            end
            if isKey(obj.props_, 'uri')
                result.uri = obj.props_('uri');
            else
                result.uri = [];
            end
            if isKey(obj.props_, 'location')
                result.location = obj.props_('location');
            else
                result.location = [];
            end
            if isKey(obj.props_, 'vu')
                result.vu = obj.props_('vu');
            else
                result.vu = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'uri')
                    propList.uri = obj.props_('uri');
                else
                    propList.uri = [];
                end
                if isKey(obj.props_, 'location')
                    propList.location = obj.props_('location');
                else
                    propList.location = [];
                end
                if isKey(obj.props_, 'vu')
                    propList.vu = obj.props_('vu');
                else
                    propList.vu = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobInputsItem;
            if isfield(json, 'type')
                obj.props_('type') = flywheel.ModelBase.deserializeValue(json.type, 'char');
            end
            if isfield(json, 'uri')
                obj.props_('uri') = flywheel.ModelBase.deserializeValue(json.uri, 'char');
            end
            if isfield(json, 'location')
                obj.props_('location') = flywheel.ModelBase.deserializeValue(json.location, 'char');
            end
            if isfield(json, 'vu')
                obj.props_('vu') = flywheel.ModelBase.deserializeValue(json.vu, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobInputsItem')
                    obj = flywheel.model.JobInputsItem(obj);
                end
                if isKey(obj.props_, 'type')
                end
                if isKey(obj.props_, 'uri')
                end
                if isKey(obj.props_, 'location')
                end
                if isKey(obj.props_, 'vu')
                end
            end
        end
    end
end
