% JobLogRecord
%
% JobLogRecord Properties:
%    id   
%    logs 
%
% JobLogRecord Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobLogRecord < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'logs' }, ...
            { '_id', 'logs' });
    end
    properties(Dependent)
        id
        logs
    end
    methods
        function obj = JobLogRecord(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobLogRecord.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'logs', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.logs)
                    obj.props_('logs') = p.Results.logs;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.logs(obj)
            if ismethod(obj, 'get_logs')
                result = obj.get_logs();
            else
                if isKey(obj.props_, 'logs')
                    result = obj.props_('logs');
                else
                    result = [];
                end
            end
        end
        function obj = set.logs(obj, value)
            obj.props_('logs') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'logs')
                result('logs') = flywheel.ModelBase.cellmap(@toJson, obj.props_('logs'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'logs')
                result.logs = flywheel.ModelBase.cellmap(@struct, obj.props_('logs'));
            else
                result.logs = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'logs')
                    propList.logs = obj.props_('logs');
                else
                    propList.logs = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobLogRecord;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'logs')
                obj.props_('logs') = flywheel.ModelBase.cellmap(@(x) flywheel.model.JobLog.fromJson(x, context), json.logs);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobLogRecord')
                    obj = flywheel.model.JobLogRecord(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'logs')
                    obj.props_('logs') = flywheel.ModelBase.cellmap(@flywheel.model.JobLog.ensureIsInstance, obj.props_('logs'));
                end
            end
        end
    end
end
