% JobModify
%
% JobModify Properties:
%    state         
%    failureReason 
%
% JobModify Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobModify < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'state', 'failureReason' }, ...
            { 'state', 'failure_reason' });
    end
    properties(Dependent)
        state
        failureReason
    end
    methods
        function obj = JobModify(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobModify.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'state', []);
                addParameter(p, 'failureReason', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.failureReason)
                    obj.props_('failure_reason') = p.Results.failureReason;
                end
            end
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.failureReason(obj)
            if ismethod(obj, 'get_failureReason')
                result = obj.get_failureReason();
            else
                if isKey(obj.props_, 'failure_reason')
                    result = obj.props_('failure_reason');
                else
                    result = [];
                end
            end
        end
        function obj = set.failureReason(obj, value)
            obj.props_('failure_reason') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
            if isKey(obj.props_, 'failure_reason')
                result('failure_reason') = flywheel.ModelBase.serializeValue(obj.props_('failure_reason'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
            if isKey(obj.props_, 'failure_reason')
                result.failureReason = obj.props_('failure_reason');
            else
                result.failureReason = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'failure_reason')
                    propList.failureReason = obj.props_('failure_reason');
                else
                    propList.failureReason = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobModify;
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.JobState.fromJson(json.state, context);
            end
            if isfield(json, 'failure_reason')
                obj.props_('failure_reason') = flywheel.ModelBase.deserializeValue(json.failure_reason, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobModify')
                    obj = flywheel.model.JobModify(obj);
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.JobState.ensureIsInstance(obj.props_('state'));
                end
                if isKey(obj.props_, 'failure_reason')
                end
            end
        end
    end
end
