% JobOutputConfig
%
% JobOutputConfig Properties:
%    destination 
%    inputs      
%    config      
%    job         
%
% JobOutputConfig Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobOutputConfig < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'destination', 'inputs', 'config', 'job' }, ...
            { 'destination', 'inputs', 'config', 'job' });
    end
    properties(Dependent)
        destination
        inputs
        config
        job
    end
    methods
        function obj = JobOutputConfig(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobOutputConfig.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'destination', []);
                addParameter(p, 'inputs', []);
                addParameter(p, 'config', []);
                addParameter(p, 'job', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.destination)
                    obj.props_('destination') = p.Results.destination;
                end
                if ~isempty(p.Results.inputs)
                    obj.props_('inputs') = p.Results.inputs;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.job)
                    obj.props_('job') = p.Results.job;
                end
            end
        end
        function result = get.destination(obj)
            if ismethod(obj, 'get_destination')
                result = obj.get_destination();
            else
                if isKey(obj.props_, 'destination')
                    result = obj.props_('destination');
                else
                    result = [];
                end
            end
        end
        function obj = set.destination(obj, value)
            obj.props_('destination') = value;
        end
        function result = get.inputs(obj)
            if ismethod(obj, 'get_inputs')
                result = obj.get_inputs();
            else
                if isKey(obj.props_, 'inputs')
                    result = obj.props_('inputs');
                else
                    result = [];
                end
            end
        end
        function obj = set.inputs(obj, value)
            obj.props_('inputs') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.job(obj)
            if ismethod(obj, 'get_job')
                result = obj.get_job();
            else
                if isKey(obj.props_, 'job')
                    result = obj.props_('job');
                else
                    result = [];
                end
            end
        end
        function obj = set.job(obj, value)
            obj.props_('job') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'destination')
                result('destination') = obj.props_('destination').toJson();
            end
            if isKey(obj.props_, 'inputs')
                result('inputs') = obj.props_('inputs').toJson();
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'job')
                result('job') = flywheel.ModelBase.serializeValue(obj.props_('job'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'destination')
                result.destination = struct(obj.props_('destination'));
            else
                result.destination = [];
            end
            if isKey(obj.props_, 'inputs')
                result.inputs = struct(obj.props_('inputs'));
            else
                result.inputs = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'job')
                result.job = obj.props_('job');
            else
                result.job = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'destination')
                    propList.destination = obj.props_('destination');
                else
                    propList.destination = [];
                end
                if isKey(obj.props_, 'inputs')
                    propList.inputs = obj.props_('inputs');
                else
                    propList.inputs = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'job')
                    propList.job = obj.props_('job');
                else
                    propList.job = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobOutputConfig;
            if isfield(json, 'destination')
                obj.props_('destination') = flywheel.model.ContainerReference.fromJson(json.destination, context);
            end
            if isfield(json, 'inputs')
                obj.props_('inputs') = flywheel.model.Object.fromJson(json.inputs, context);
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'job')
                obj.props_('job') = flywheel.ModelBase.deserializeValue(json.job, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobOutputConfig')
                    obj = flywheel.model.JobOutputConfig(obj);
                end
                if isKey(obj.props_, 'destination')
                    obj.props_('destination') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('destination'));
                end
                if isKey(obj.props_, 'inputs')
                    obj.props_('inputs') =  flywheel.model.Object.ensureIsInstance(obj.props_('inputs'));
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'job')
                end
            end
        end
    end
end
