% JobPriorityUpdate
%
% JobPriorityUpdate Properties:
%    jobIds   
%    priority 
%
% JobPriorityUpdate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobPriorityUpdate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'jobIds', 'priority' }, ...
            { 'job_ids', 'priority' });
    end
    properties(Dependent)
        jobIds
        priority
    end
    methods
        function obj = JobPriorityUpdate(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobPriorityUpdate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'jobIds', []);
                addParameter(p, 'priority', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.jobIds)
                    obj.props_('job_ids') = p.Results.jobIds;
                end
                if ~isempty(p.Results.priority)
                    obj.props_('priority') = p.Results.priority;
                end
            end
        end
        function result = get.jobIds(obj)
            if ismethod(obj, 'get_jobIds')
                result = obj.get_jobIds();
            else
                if isKey(obj.props_, 'job_ids')
                    result = obj.props_('job_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobIds(obj, value)
            obj.props_('job_ids') = value;
        end
        function result = get.priority(obj)
            if ismethod(obj, 'get_priority')
                result = obj.get_priority();
            else
                if isKey(obj.props_, 'priority')
                    result = obj.props_('priority');
                else
                    result = [];
                end
            end
        end
        function obj = set.priority(obj, value)
            obj.props_('priority') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'job_ids')
                result('job_ids') = flywheel.ModelBase.serializeValue(obj.props_('job_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 'priority')
                result('priority') = obj.props_('priority').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'job_ids')
                result.jobIds = obj.props_('job_ids');
            else
                result.jobIds = [];
            end
            if isKey(obj.props_, 'priority')
                result.priority = struct(obj.props_('priority'));
            else
                result.priority = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'job_ids')
                    propList.jobIds = obj.props_('job_ids');
                else
                    propList.jobIds = [];
                end
                if isKey(obj.props_, 'priority')
                    propList.priority = obj.props_('priority');
                else
                    propList.priority = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobPriorityUpdate;
            if isfield(json, 'job_ids')
                obj.props_('job_ids') = flywheel.ModelBase.deserializeValue(json.job_ids, 'vector[char]');
            end
            if isfield(json, 'priority')
                obj.props_('priority') = flywheel.model.JobPriority.fromJson(json.priority, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobPriorityUpdate')
                    obj = flywheel.model.JobPriorityUpdate(obj);
                end
                if isKey(obj.props_, 'job_ids')
                end
                if isKey(obj.props_, 'priority')
                    obj.props_('priority') =  flywheel.model.JobPriority.ensureIsInstance(obj.props_('priority'));
                end
            end
        end
    end
end
