% JobProfile - Represents the optional jobs profile  Attributes:     elapsed_time_ms (Optional[int]): The runtime of the job,         in milliseconds     executor (Optional[ExecutorInfo]): The information about the job         executor, also known as engine     preparation_time_ms (Optional[int]): The length of time taken to         download gear container and inputs, in milliseconds     total_input_files (Optional[int]): The number of input files     total_input_size_bytes (Optional[int]): The combined size of all input         files, in bytes     total_output_files (Optional[int]): The number of output files     total_output_size_bytes (Optional[int]): The combined size of all         output files, in bytes     total_time_ms (Optional[int]): The total length of time from start to         finish, in milliseconds     upload_time_ms (Optional[int]): The length of time taken to upload the         job's outputs, in milliseconds     versions (Optional[Dict[str, str]]): Version info of components         involved in job
%
% JobProfile Properties:
%    totalInputFiles       - The number of input files
%    totalInputSizeBytes   - The combined size of all input files, in bytes
%    totalOutputFiles      - The number of output files
%    totalOutputSizeBytes  - The combined size of all output files, in bytes
%    preparationTimeMs     - The length of time taken to download gear container and inputs, in milliseconds
%    elapsedTimeMs         - The runtime of the job, in milliseconds
%    uploadTimeMs          - The length of time taken to upload the job's outputs, in milliseconds
%    totalTimeMs           - The total length of time from start to finish, in milliseconds
%    versions             
%    executor             
%
% JobProfile Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobProfile < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'totalInputFiles', 'totalInputSizeBytes', 'totalOutputFiles', 'totalOutputSizeBytes', 'preparationTimeMs', 'elapsedTimeMs', 'uploadTimeMs', 'totalTimeMs', 'versions', 'executor' }, ...
            { 'total_input_files', 'total_input_size_bytes', 'total_output_files', 'total_output_size_bytes', 'preparation_time_ms', 'elapsed_time_ms', 'upload_time_ms', 'total_time_ms', 'versions', 'executor' });
    end
    properties(Dependent)
        totalInputFiles
        totalInputSizeBytes
        totalOutputFiles
        totalOutputSizeBytes
        preparationTimeMs
        elapsedTimeMs
        uploadTimeMs
        totalTimeMs
        versions
        executor
    end
    methods
        function obj = JobProfile(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobProfile.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'totalInputFiles', []);
                addParameter(p, 'totalInputSizeBytes', []);
                addParameter(p, 'totalOutputFiles', []);
                addParameter(p, 'totalOutputSizeBytes', []);
                addParameter(p, 'preparationTimeMs', []);
                addParameter(p, 'elapsedTimeMs', []);
                addParameter(p, 'uploadTimeMs', []);
                addParameter(p, 'totalTimeMs', []);
                addParameter(p, 'versions', []);
                addParameter(p, 'executor', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.totalInputFiles)
                    obj.props_('total_input_files') = p.Results.totalInputFiles;
                end
                if ~isempty(p.Results.totalInputSizeBytes)
                    obj.props_('total_input_size_bytes') = p.Results.totalInputSizeBytes;
                end
                if ~isempty(p.Results.totalOutputFiles)
                    obj.props_('total_output_files') = p.Results.totalOutputFiles;
                end
                if ~isempty(p.Results.totalOutputSizeBytes)
                    obj.props_('total_output_size_bytes') = p.Results.totalOutputSizeBytes;
                end
                if ~isempty(p.Results.preparationTimeMs)
                    obj.props_('preparation_time_ms') = p.Results.preparationTimeMs;
                end
                if ~isempty(p.Results.elapsedTimeMs)
                    obj.props_('elapsed_time_ms') = p.Results.elapsedTimeMs;
                end
                if ~isempty(p.Results.uploadTimeMs)
                    obj.props_('upload_time_ms') = p.Results.uploadTimeMs;
                end
                if ~isempty(p.Results.totalTimeMs)
                    obj.props_('total_time_ms') = p.Results.totalTimeMs;
                end
                if ~isempty(p.Results.versions)
                    obj.props_('versions') = p.Results.versions;
                end
                if ~isempty(p.Results.executor)
                    obj.props_('executor') = p.Results.executor;
                end
            end
        end
        function result = get.totalInputFiles(obj)
            if ismethod(obj, 'get_totalInputFiles')
                result = obj.get_totalInputFiles();
            else
                if isKey(obj.props_, 'total_input_files')
                    result = obj.props_('total_input_files');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalInputFiles(obj, value)
            obj.props_('total_input_files') = value;
        end
        function result = get.totalInputSizeBytes(obj)
            if ismethod(obj, 'get_totalInputSizeBytes')
                result = obj.get_totalInputSizeBytes();
            else
                if isKey(obj.props_, 'total_input_size_bytes')
                    result = obj.props_('total_input_size_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalInputSizeBytes(obj, value)
            obj.props_('total_input_size_bytes') = value;
        end
        function result = get.totalOutputFiles(obj)
            if ismethod(obj, 'get_totalOutputFiles')
                result = obj.get_totalOutputFiles();
            else
                if isKey(obj.props_, 'total_output_files')
                    result = obj.props_('total_output_files');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalOutputFiles(obj, value)
            obj.props_('total_output_files') = value;
        end
        function result = get.totalOutputSizeBytes(obj)
            if ismethod(obj, 'get_totalOutputSizeBytes')
                result = obj.get_totalOutputSizeBytes();
            else
                if isKey(obj.props_, 'total_output_size_bytes')
                    result = obj.props_('total_output_size_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalOutputSizeBytes(obj, value)
            obj.props_('total_output_size_bytes') = value;
        end
        function result = get.preparationTimeMs(obj)
            if ismethod(obj, 'get_preparationTimeMs')
                result = obj.get_preparationTimeMs();
            else
                if isKey(obj.props_, 'preparation_time_ms')
                    result = obj.props_('preparation_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.preparationTimeMs(obj, value)
            obj.props_('preparation_time_ms') = value;
        end
        function result = get.elapsedTimeMs(obj)
            if ismethod(obj, 'get_elapsedTimeMs')
                result = obj.get_elapsedTimeMs();
            else
                if isKey(obj.props_, 'elapsed_time_ms')
                    result = obj.props_('elapsed_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.elapsedTimeMs(obj, value)
            obj.props_('elapsed_time_ms') = value;
        end
        function result = get.uploadTimeMs(obj)
            if ismethod(obj, 'get_uploadTimeMs')
                result = obj.get_uploadTimeMs();
            else
                if isKey(obj.props_, 'upload_time_ms')
                    result = obj.props_('upload_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.uploadTimeMs(obj, value)
            obj.props_('upload_time_ms') = value;
        end
        function result = get.totalTimeMs(obj)
            if ismethod(obj, 'get_totalTimeMs')
                result = obj.get_totalTimeMs();
            else
                if isKey(obj.props_, 'total_time_ms')
                    result = obj.props_('total_time_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.totalTimeMs(obj, value)
            obj.props_('total_time_ms') = value;
        end
        function result = get.versions(obj)
            if ismethod(obj, 'get_versions')
                result = obj.get_versions();
            else
                if isKey(obj.props_, 'versions')
                    result = obj.props_('versions');
                else
                    result = [];
                end
            end
        end
        function obj = set.versions(obj, value)
            obj.props_('versions') = value;
        end
        function result = get.executor(obj)
            if ismethod(obj, 'get_executor')
                result = obj.get_executor();
            else
                if isKey(obj.props_, 'executor')
                    result = obj.props_('executor');
                else
                    result = [];
                end
            end
        end
        function obj = set.executor(obj, value)
            obj.props_('executor') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'total_input_files')
                result('total_input_files') = flywheel.ModelBase.serializeValue(obj.props_('total_input_files'), 'integer');
            end
            if isKey(obj.props_, 'total_input_size_bytes')
                result('total_input_size_bytes') = flywheel.ModelBase.serializeValue(obj.props_('total_input_size_bytes'), 'integer');
            end
            if isKey(obj.props_, 'total_output_files')
                result('total_output_files') = flywheel.ModelBase.serializeValue(obj.props_('total_output_files'), 'integer');
            end
            if isKey(obj.props_, 'total_output_size_bytes')
                result('total_output_size_bytes') = flywheel.ModelBase.serializeValue(obj.props_('total_output_size_bytes'), 'integer');
            end
            if isKey(obj.props_, 'preparation_time_ms')
                result('preparation_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('preparation_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'elapsed_time_ms')
                result('elapsed_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('elapsed_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'upload_time_ms')
                result('upload_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('upload_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'total_time_ms')
                result('total_time_ms') = flywheel.ModelBase.serializeValue(obj.props_('total_time_ms'), 'integer');
            end
            if isKey(obj.props_, 'versions')
                result('versions') = obj.props_('versions').toJson();
            end
            if isKey(obj.props_, 'executor')
                result('executor') = obj.props_('executor').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'total_input_files')
                result.totalInputFiles = obj.props_('total_input_files');
            else
                result.totalInputFiles = [];
            end
            if isKey(obj.props_, 'total_input_size_bytes')
                result.totalInputSizeBytes = obj.props_('total_input_size_bytes');
            else
                result.totalInputSizeBytes = [];
            end
            if isKey(obj.props_, 'total_output_files')
                result.totalOutputFiles = obj.props_('total_output_files');
            else
                result.totalOutputFiles = [];
            end
            if isKey(obj.props_, 'total_output_size_bytes')
                result.totalOutputSizeBytes = obj.props_('total_output_size_bytes');
            else
                result.totalOutputSizeBytes = [];
            end
            if isKey(obj.props_, 'preparation_time_ms')
                result.preparationTimeMs = obj.props_('preparation_time_ms');
            else
                result.preparationTimeMs = [];
            end
            if isKey(obj.props_, 'elapsed_time_ms')
                result.elapsedTimeMs = obj.props_('elapsed_time_ms');
            else
                result.elapsedTimeMs = [];
            end
            if isKey(obj.props_, 'upload_time_ms')
                result.uploadTimeMs = obj.props_('upload_time_ms');
            else
                result.uploadTimeMs = [];
            end
            if isKey(obj.props_, 'total_time_ms')
                result.totalTimeMs = obj.props_('total_time_ms');
            else
                result.totalTimeMs = [];
            end
            if isKey(obj.props_, 'versions')
                result.versions = struct(obj.props_('versions'));
            else
                result.versions = [];
            end
            if isKey(obj.props_, 'executor')
                result.executor = struct(obj.props_('executor'));
            else
                result.executor = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'total_input_files')
                    propList.totalInputFiles = obj.props_('total_input_files');
                else
                    propList.totalInputFiles = [];
                end
                if isKey(obj.props_, 'total_input_size_bytes')
                    propList.totalInputSizeBytes = obj.props_('total_input_size_bytes');
                else
                    propList.totalInputSizeBytes = [];
                end
                if isKey(obj.props_, 'total_output_files')
                    propList.totalOutputFiles = obj.props_('total_output_files');
                else
                    propList.totalOutputFiles = [];
                end
                if isKey(obj.props_, 'total_output_size_bytes')
                    propList.totalOutputSizeBytes = obj.props_('total_output_size_bytes');
                else
                    propList.totalOutputSizeBytes = [];
                end
                if isKey(obj.props_, 'preparation_time_ms')
                    propList.preparationTimeMs = obj.props_('preparation_time_ms');
                else
                    propList.preparationTimeMs = [];
                end
                if isKey(obj.props_, 'elapsed_time_ms')
                    propList.elapsedTimeMs = obj.props_('elapsed_time_ms');
                else
                    propList.elapsedTimeMs = [];
                end
                if isKey(obj.props_, 'upload_time_ms')
                    propList.uploadTimeMs = obj.props_('upload_time_ms');
                else
                    propList.uploadTimeMs = [];
                end
                if isKey(obj.props_, 'total_time_ms')
                    propList.totalTimeMs = obj.props_('total_time_ms');
                else
                    propList.totalTimeMs = [];
                end
                if isKey(obj.props_, 'versions')
                    propList.versions = obj.props_('versions');
                else
                    propList.versions = [];
                end
                if isKey(obj.props_, 'executor')
                    propList.executor = obj.props_('executor');
                else
                    propList.executor = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobProfile;
            if isfield(json, 'total_input_files')
                obj.props_('total_input_files') = flywheel.ModelBase.deserializeValue(json.total_input_files, 'integer');
            end
            if isfield(json, 'total_input_size_bytes')
                obj.props_('total_input_size_bytes') = flywheel.ModelBase.deserializeValue(json.total_input_size_bytes, 'integer');
            end
            if isfield(json, 'total_output_files')
                obj.props_('total_output_files') = flywheel.ModelBase.deserializeValue(json.total_output_files, 'integer');
            end
            if isfield(json, 'total_output_size_bytes')
                obj.props_('total_output_size_bytes') = flywheel.ModelBase.deserializeValue(json.total_output_size_bytes, 'integer');
            end
            if isfield(json, 'preparation_time_ms')
                obj.props_('preparation_time_ms') = flywheel.ModelBase.deserializeValue(json.preparation_time_ms, 'integer');
            end
            if isfield(json, 'elapsed_time_ms')
                obj.props_('elapsed_time_ms') = flywheel.ModelBase.deserializeValue(json.elapsed_time_ms, 'integer');
            end
            if isfield(json, 'upload_time_ms')
                obj.props_('upload_time_ms') = flywheel.ModelBase.deserializeValue(json.upload_time_ms, 'integer');
            end
            if isfield(json, 'total_time_ms')
                obj.props_('total_time_ms') = flywheel.ModelBase.deserializeValue(json.total_time_ms, 'integer');
            end
            if isfield(json, 'versions')
                obj.props_('versions') = flywheel.model.JobVersionInfo.fromJson(json.versions, context);
            end
            if isfield(json, 'executor')
                obj.props_('executor') = flywheel.model.JobExecutorInfo.fromJson(json.executor, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobProfile')
                    obj = flywheel.model.JobProfile(obj);
                end
                if isKey(obj.props_, 'total_input_files')
                end
                if isKey(obj.props_, 'total_input_size_bytes')
                end
                if isKey(obj.props_, 'total_output_files')
                end
                if isKey(obj.props_, 'total_output_size_bytes')
                end
                if isKey(obj.props_, 'preparation_time_ms')
                end
                if isKey(obj.props_, 'elapsed_time_ms')
                end
                if isKey(obj.props_, 'upload_time_ms')
                end
                if isKey(obj.props_, 'total_time_ms')
                end
                if isKey(obj.props_, 'versions')
                    obj.props_('versions') =  flywheel.model.JobVersionInfo.ensureIsInstance(obj.props_('versions'));
                end
                if isKey(obj.props_, 'executor')
                    obj.props_('executor') =  flywheel.model.JobExecutorInfo.ensureIsInstance(obj.props_('executor'));
                end
            end
        end
    end
end
