% JobRequestTarget - Represents the information needed to run the gear  Attributes:     command (List[str]): The command run inside the docker container to run         the gear     environment (Dict[str, str]): The environment variables to set inside         the container     uid (Optional[int]): The uid     gid (Optional[int]): The gid     dir (str): The directory to place assets under
%
% JobRequestTarget Properties:
%    command 
%    env     
%    uid     
%    gid     
%    dir     
%
% JobRequestTarget Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JobRequestTarget < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'command', 'env', 'uid', 'gid', 'dir' }, ...
            { 'command', 'env', 'uid', 'gid', 'dir' });
    end
    properties(Dependent)
        command
        env
        uid
        gid
        dir
    end
    methods
        function obj = JobRequestTarget(varargin)
            obj@flywheel.ModelBase(flywheel.model.JobRequestTarget.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'command', []);
                addParameter(p, 'env', []);
                addParameter(p, 'uid', []);
                addParameter(p, 'gid', []);
                addParameter(p, 'dir', &#x27;/flywheel/v0&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.command)
                    obj.props_('command') = p.Results.command;
                end
                if ~isempty(p.Results.env)
                    obj.props_('env') = p.Results.env;
                end
                if ~isempty(p.Results.uid)
                    obj.props_('uid') = p.Results.uid;
                end
                if ~isempty(p.Results.gid)
                    obj.props_('gid') = p.Results.gid;
                end
                if ~isempty(p.Results.dir)
                    obj.props_('dir') = p.Results.dir;
                end
            end
        end
        function result = get.command(obj)
            if ismethod(obj, 'get_command')
                result = obj.get_command();
            else
                if isKey(obj.props_, 'command')
                    result = obj.props_('command');
                else
                    result = [];
                end
            end
        end
        function obj = set.command(obj, value)
            obj.props_('command') = value;
        end
        function result = get.env(obj)
            if ismethod(obj, 'get_env')
                result = obj.get_env();
            else
                if isKey(obj.props_, 'env')
                    result = obj.props_('env');
                else
                    result = [];
                end
            end
        end
        function obj = set.env(obj, value)
            obj.props_('env') = value;
        end
        function result = get.uid(obj)
            if ismethod(obj, 'get_uid')
                result = obj.get_uid();
            else
                if isKey(obj.props_, 'uid')
                    result = obj.props_('uid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uid(obj, value)
            obj.props_('uid') = value;
        end
        function result = get.gid(obj)
            if ismethod(obj, 'get_gid')
                result = obj.get_gid();
            else
                if isKey(obj.props_, 'gid')
                    result = obj.props_('gid');
                else
                    result = [];
                end
            end
        end
        function obj = set.gid(obj, value)
            obj.props_('gid') = value;
        end
        function result = get.dir(obj)
            if ismethod(obj, 'get_dir')
                result = obj.get_dir();
            else
                if isKey(obj.props_, 'dir')
                    result = obj.props_('dir');
                else
                    result = [];
                end
            end
        end
        function obj = set.dir(obj, value)
            obj.props_('dir') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'command')
                result('command') = flywheel.ModelBase.serializeValue(obj.props_('command'), 'vector[char]');
            end
            if isKey(obj.props_, 'env')
                result('env') = flywheel.ModelBase.serializeValue(obj.props_('env'), 'containers.Map[String, char]');
            end
            if isKey(obj.props_, 'uid')
                result('uid') = flywheel.ModelBase.serializeValue(obj.props_('uid'), 'integer');
            end
            if isKey(obj.props_, 'gid')
                result('gid') = flywheel.ModelBase.serializeValue(obj.props_('gid'), 'integer');
            end
            if isKey(obj.props_, 'dir')
                result('dir') = flywheel.ModelBase.serializeValue(obj.props_('dir'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'command')
                result.command = obj.props_('command');
            else
                result.command = [];
            end
            if isKey(obj.props_, 'env')
                result.env = obj.props_('env');
            else
                result.env = [];
            end
            if isKey(obj.props_, 'uid')
                result.uid = obj.props_('uid');
            else
                result.uid = [];
            end
            if isKey(obj.props_, 'gid')
                result.gid = obj.props_('gid');
            else
                result.gid = [];
            end
            if isKey(obj.props_, 'dir')
                result.dir = obj.props_('dir');
            else
                result.dir = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'command')
                    propList.command = obj.props_('command');
                else
                    propList.command = [];
                end
                if isKey(obj.props_, 'env')
                    propList.env = obj.props_('env');
                else
                    propList.env = [];
                end
                if isKey(obj.props_, 'uid')
                    propList.uid = obj.props_('uid');
                else
                    propList.uid = [];
                end
                if isKey(obj.props_, 'gid')
                    propList.gid = obj.props_('gid');
                else
                    propList.gid = [];
                end
                if isKey(obj.props_, 'dir')
                    propList.dir = obj.props_('dir');
                else
                    propList.dir = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JobRequestTarget;
            if isfield(json, 'command')
                obj.props_('command') = flywheel.ModelBase.deserializeValue(json.command, 'vector[char]');
            end
            if isfield(json, 'env')
                obj.props_('env') = flywheel.ModelBase.deserializeValue(json.env, 'containers.Map[String, char]');
            end
            if isfield(json, 'uid')
                obj.props_('uid') = flywheel.ModelBase.deserializeValue(json.uid, 'integer');
            end
            if isfield(json, 'gid')
                obj.props_('gid') = flywheel.ModelBase.deserializeValue(json.gid, 'integer');
            end
            if isfield(json, 'dir')
                obj.props_('dir') = flywheel.ModelBase.deserializeValue(json.dir, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JobRequestTarget')
                    obj = flywheel.model.JobRequestTarget(obj);
                end
                if isKey(obj.props_, 'command')
                end
                if isKey(obj.props_, 'env')
                end
                if isKey(obj.props_, 'uid')
                end
                if isKey(obj.props_, 'gid')
                end
                if isKey(obj.props_, 'dir')
                end
            end
        end
    end
end
