% JoinOriginJob
%
% JoinOriginJob Properties:
%    created  
%    modified 
%    gearInfo 
%
% JoinOriginJob Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JoinOriginJob < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'created', 'modified', 'gearInfo' }, ...
            { 'created', 'modified', 'gear_info' });
    end
    properties(Dependent)
        created
        modified
        gearInfo
    end
    methods
        function obj = JoinOriginJob(varargin)
            obj@flywheel.ModelBase(flywheel.model.JoinOriginJob.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'gearInfo', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.gearInfo)
                    obj.props_('gear_info') = p.Results.gearInfo;
                end
            end
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.gearInfo(obj)
            if ismethod(obj, 'get_gearInfo')
                result = obj.get_gearInfo();
            else
                if isKey(obj.props_, 'gear_info')
                    result = obj.props_('gear_info');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearInfo(obj, value)
            obj.props_('gear_info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'gear_info')
                result('gear_info') = obj.props_('gear_info').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'gear_info')
                result.gearInfo = struct(obj.props_('gear_info'));
            else
                result.gearInfo = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'gear_info')
                    propList.gearInfo = obj.props_('gear_info');
                else
                    propList.gearInfo = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JoinOriginJob;
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'gear_info')
                obj.props_('gear_info') = flywheel.model.GearInfo.fromJson(json.gear_info, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JoinOriginJob')
                    obj = flywheel.model.JoinOriginJob(obj);
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'gear_info')
                    obj.props_('gear_info') =  flywheel.model.GearInfo.ensureIsInstance(obj.props_('gear_info'));
                end
            end
        end
    end
end
