% JoinOrigins
%
% JoinOrigins Properties:
%    device 
%    job    
%    user   
%
% JoinOrigins Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JoinOrigins < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'device', 'job', 'user' }, ...
            { 'device', 'job', 'user' });
    end
    properties(Dependent)
        device
        job
        user
    end
    methods
        function obj = JoinOrigins(varargin)
            obj@flywheel.ModelBase(flywheel.model.JoinOrigins.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'device', []);
                addParameter(p, 'job', []);
                addParameter(p, 'user', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.device)
                    obj.props_('device') = p.Results.device;
                end
                if ~isempty(p.Results.job)
                    obj.props_('job') = p.Results.job;
                end
                if ~isempty(p.Results.user)
                    obj.props_('user') = p.Results.user;
                end
            end
        end
        function result = get.device(obj)
            if ismethod(obj, 'get_device')
                result = obj.get_device();
            else
                if isKey(obj.props_, 'device')
                    result = obj.props_('device');
                else
                    result = [];
                end
            end
        end
        function obj = set.device(obj, value)
            obj.props_('device') = value;
        end
        function result = get.job(obj)
            if ismethod(obj, 'get_job')
                result = obj.get_job();
            else
                if isKey(obj.props_, 'job')
                    result = obj.props_('job');
                else
                    result = [];
                end
            end
        end
        function obj = set.job(obj, value)
            obj.props_('job') = value;
        end
        function result = get.user(obj)
            if ismethod(obj, 'get_user')
                result = obj.get_user();
            else
                if isKey(obj.props_, 'user')
                    result = obj.props_('user');
                else
                    result = [];
                end
            end
        end
        function obj = set.user(obj, value)
            obj.props_('user') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'device')
                result('device') = obj.props_('device').toJson();
            end
            if isKey(obj.props_, 'job')
                result('job') = obj.props_('job').toJson();
            end
            if isKey(obj.props_, 'user')
                result('user') = obj.props_('user').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'device')
                result.device = struct(obj.props_('device'));
            else
                result.device = [];
            end
            if isKey(obj.props_, 'job')
                result.job = struct(obj.props_('job'));
            else
                result.job = [];
            end
            if isKey(obj.props_, 'user')
                result.user = struct(obj.props_('user'));
            else
                result.user = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'device')
                    propList.device = obj.props_('device');
                else
                    propList.device = [];
                end
                if isKey(obj.props_, 'job')
                    propList.job = obj.props_('job');
                else
                    propList.job = [];
                end
                if isKey(obj.props_, 'user')
                    propList.user = obj.props_('user');
                else
                    propList.user = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JoinOrigins;
            if isfield(json, 'device')
                obj.props_('device') = flywheel.model.JoinOriginDevice.fromJson(json.device, context);
            end
            if isfield(json, 'job')
                obj.props_('job') = flywheel.model.JoinOriginJob.fromJson(json.job, context);
            end
            if isfield(json, 'user')
                obj.props_('user') = flywheel.model.JoinOriginUser.fromJson(json.user, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JoinOrigins')
                    obj = flywheel.model.JoinOrigins(obj);
                end
                if isKey(obj.props_, 'device')
                    obj.props_('device') =  flywheel.model.JoinOriginDevice.ensureIsInstance(obj.props_('device'));
                end
                if isKey(obj.props_, 'job')
                    obj.props_('job') =  flywheel.model.JoinOriginJob.ensureIsInstance(obj.props_('job'));
                end
                if isKey(obj.props_, 'user')
                    obj.props_('user') =  flywheel.model.JoinOriginUser.ensureIsInstance(obj.props_('user'));
                end
            end
        end
    end
end
