% JupyterlabServerModify
%
% JupyterlabServerModify Properties:
%    label             
%    lastModifiedBy    
%    deleted           
%    externalStorageId 
%    latestVersion     
%
% JupyterlabServerModify Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JupyterlabServerModify < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'lastModifiedBy', 'deleted', 'externalStorageId', 'latestVersion' }, ...
            { 'label', 'last_modified_by', 'deleted', 'external_storage_id', 'latest_version' });
    end
    properties(Dependent)
        label
        lastModifiedBy
        deleted
        externalStorageId
        latestVersion
    end
    methods
        function obj = JupyterlabServerModify(varargin)
            obj@flywheel.ModelBase(flywheel.model.JupyterlabServerModify.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'lastModifiedBy', []);
                addParameter(p, 'deleted', []);
                addParameter(p, 'externalStorageId', []);
                addParameter(p, 'latestVersion', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.lastModifiedBy)
                    obj.props_('last_modified_by') = p.Results.lastModifiedBy;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.externalStorageId)
                    obj.props_('external_storage_id') = p.Results.externalStorageId;
                end
                if ~isempty(p.Results.latestVersion)
                    obj.props_('latest_version') = p.Results.latestVersion;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.lastModifiedBy(obj)
            if ismethod(obj, 'get_lastModifiedBy')
                result = obj.get_lastModifiedBy();
            else
                if isKey(obj.props_, 'last_modified_by')
                    result = obj.props_('last_modified_by');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastModifiedBy(obj, value)
            obj.props_('last_modified_by') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.externalStorageId(obj)
            if ismethod(obj, 'get_externalStorageId')
                result = obj.get_externalStorageId();
            else
                if isKey(obj.props_, 'external_storage_id')
                    result = obj.props_('external_storage_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.externalStorageId(obj, value)
            obj.props_('external_storage_id') = value;
        end
        function result = get.latestVersion(obj)
            if ismethod(obj, 'get_latestVersion')
                result = obj.get_latestVersion();
            else
                if isKey(obj.props_, 'latest_version')
                    result = obj.props_('latest_version');
                else
                    result = [];
                end
            end
        end
        function obj = set.latestVersion(obj, value)
            obj.props_('latest_version') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'last_modified_by')
                result('last_modified_by') = obj.props_('last_modified_by').toJson();
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'external_storage_id')
                result('external_storage_id') = flywheel.ModelBase.serializeValue(obj.props_('external_storage_id'), 'char');
            end
            if isKey(obj.props_, 'latest_version')
                result('latest_version') = flywheel.ModelBase.serializeValue(obj.props_('latest_version'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'last_modified_by')
                result.lastModifiedBy = struct(obj.props_('last_modified_by'));
            else
                result.lastModifiedBy = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'external_storage_id')
                result.externalStorageId = obj.props_('external_storage_id');
            else
                result.externalStorageId = [];
            end
            if isKey(obj.props_, 'latest_version')
                result.latestVersion = obj.props_('latest_version');
            else
                result.latestVersion = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'last_modified_by')
                    propList.lastModifiedBy = obj.props_('last_modified_by');
                else
                    propList.lastModifiedBy = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'external_storage_id')
                    propList.externalStorageId = obj.props_('external_storage_id');
                else
                    propList.externalStorageId = [];
                end
                if isKey(obj.props_, 'latest_version')
                    propList.latestVersion = obj.props_('latest_version');
                else
                    propList.latestVersion = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JupyterlabServerModify;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'last_modified_by')
                obj.props_('last_modified_by') = flywheel.model.Origin.fromJson(json.last_modified_by, context);
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'external_storage_id')
                obj.props_('external_storage_id') = flywheel.ModelBase.deserializeValue(json.external_storage_id, 'char');
            end
            if isfield(json, 'latest_version')
                obj.props_('latest_version') = flywheel.ModelBase.deserializeValue(json.latest_version, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JupyterlabServerModify')
                    obj = flywheel.model.JupyterlabServerModify(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'last_modified_by')
                    obj.props_('last_modified_by') =  flywheel.model.Origin.ensureIsInstance(obj.props_('last_modified_by'));
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'external_storage_id')
                end
                if isKey(obj.props_, 'latest_version')
                end
            end
        end
    end
end
