% JupyterlabServerResponse
%
% JupyterlabServerResponse Properties:
%    id                 - Unique database ID
%    projectId          - Unique database ID
%    label             
%    created            - Creation time (automatically set)
%    modified           - Last modification time (automatically updated)
%    lastModifiedBy    
%    origin            
%    serverState       
%    externalStorageId 
%    latestVersion     
%
% JupyterlabServerResponse Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef JupyterlabServerResponse < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'projectId', 'label', 'created', 'modified', 'lastModifiedBy', 'origin', 'serverState', 'externalStorageId', 'latestVersion' }, ...
            { '_id', 'project_id', 'label', 'created', 'modified', 'last_modified_by', 'origin', 'server_state', 'external_storage_id', 'latest_version' });
    end
    properties(Dependent)
        id
        projectId
        label
        created
        modified
        lastModifiedBy
        origin
        serverState
        externalStorageId
        latestVersion
    end
    methods
        function obj = JupyterlabServerResponse(varargin)
            obj@flywheel.ModelBase(flywheel.model.JupyterlabServerResponse.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'projectId', []);
                addParameter(p, 'label', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'lastModifiedBy', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'serverState', []);
                addParameter(p, 'externalStorageId', []);
                addParameter(p, 'latestVersion', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.lastModifiedBy)
                    obj.props_('last_modified_by') = p.Results.lastModifiedBy;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.serverState)
                    obj.props_('server_state') = p.Results.serverState;
                end
                if ~isempty(p.Results.externalStorageId)
                    obj.props_('external_storage_id') = p.Results.externalStorageId;
                end
                if ~isempty(p.Results.latestVersion)
                    obj.props_('latest_version') = p.Results.latestVersion;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.lastModifiedBy(obj)
            if ismethod(obj, 'get_lastModifiedBy')
                result = obj.get_lastModifiedBy();
            else
                if isKey(obj.props_, 'last_modified_by')
                    result = obj.props_('last_modified_by');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastModifiedBy(obj, value)
            obj.props_('last_modified_by') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.serverState(obj)
            if ismethod(obj, 'get_serverState')
                result = obj.get_serverState();
            else
                if isKey(obj.props_, 'server_state')
                    result = obj.props_('server_state');
                else
                    result = [];
                end
            end
        end
        function obj = set.serverState(obj, value)
            obj.props_('server_state') = value;
        end
        function result = get.externalStorageId(obj)
            if ismethod(obj, 'get_externalStorageId')
                result = obj.get_externalStorageId();
            else
                if isKey(obj.props_, 'external_storage_id')
                    result = obj.props_('external_storage_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.externalStorageId(obj, value)
            obj.props_('external_storage_id') = value;
        end
        function result = get.latestVersion(obj)
            if ismethod(obj, 'get_latestVersion')
                result = obj.get_latestVersion();
            else
                if isKey(obj.props_, 'latest_version')
                    result = obj.props_('latest_version');
                else
                    result = [];
                end
            end
        end
        function obj = set.latestVersion(obj, value)
            obj.props_('latest_version') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'last_modified_by')
                result('last_modified_by') = obj.props_('last_modified_by').toJson();
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'server_state')
                result('server_state') = obj.props_('server_state').toJson();
            end
            if isKey(obj.props_, 'external_storage_id')
                result('external_storage_id') = flywheel.ModelBase.serializeValue(obj.props_('external_storage_id'), 'char');
            end
            if isKey(obj.props_, 'latest_version')
                result('latest_version') = flywheel.ModelBase.serializeValue(obj.props_('latest_version'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'last_modified_by')
                result.lastModifiedBy = struct(obj.props_('last_modified_by'));
            else
                result.lastModifiedBy = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'server_state')
                result.serverState = struct(obj.props_('server_state'));
            else
                result.serverState = [];
            end
            if isKey(obj.props_, 'external_storage_id')
                result.externalStorageId = obj.props_('external_storage_id');
            else
                result.externalStorageId = [];
            end
            if isKey(obj.props_, 'latest_version')
                result.latestVersion = obj.props_('latest_version');
            else
                result.latestVersion = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'last_modified_by')
                    propList.lastModifiedBy = obj.props_('last_modified_by');
                else
                    propList.lastModifiedBy = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'server_state')
                    propList.serverState = obj.props_('server_state');
                else
                    propList.serverState = [];
                end
                if isKey(obj.props_, 'external_storage_id')
                    propList.externalStorageId = obj.props_('external_storage_id');
                else
                    propList.externalStorageId = [];
                end
                if isKey(obj.props_, 'latest_version')
                    propList.latestVersion = obj.props_('latest_version');
                else
                    propList.latestVersion = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.JupyterlabServerResponse;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'last_modified_by')
                obj.props_('last_modified_by') = flywheel.model.Origin.fromJson(json.last_modified_by, context);
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'server_state')
                obj.props_('server_state') = flywheel.model.ServerState.fromJson(json.server_state, context);
            end
            if isfield(json, 'external_storage_id')
                obj.props_('external_storage_id') = flywheel.ModelBase.deserializeValue(json.external_storage_id, 'char');
            end
            if isfield(json, 'latest_version')
                obj.props_('latest_version') = flywheel.ModelBase.deserializeValue(json.latest_version, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.JupyterlabServerResponse')
                    obj = flywheel.model.JupyterlabServerResponse(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'project_id')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'last_modified_by')
                    obj.props_('last_modified_by') =  flywheel.model.Origin.ensureIsInstance(obj.props_('last_modified_by'));
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'server_state')
                    obj.props_('server_state') =  flywheel.model.ServerState.ensureIsInstance(obj.props_('server_state'));
                end
                if isKey(obj.props_, 'external_storage_id')
                end
                if isKey(obj.props_, 'latest_version')
                end
            end
        end
    end
end
