% LdapSyncConfig - LDAP sync configuration / user input
%
% LdapSyncConfig Properties:
%    groupDn 
%
% LdapSyncConfig Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef LdapSyncConfig < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'groupDn' }, ...
            { 'group_dn' });
    end
    properties(Dependent)
        groupDn
    end
    methods
        function obj = LdapSyncConfig(varargin)
            obj@flywheel.ModelBase(flywheel.model.LdapSyncConfig.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'groupDn', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.groupDn)
                    obj.props_('group_dn') = p.Results.groupDn;
                end
            end
        end
        function result = get.groupDn(obj)
            if ismethod(obj, 'get_groupDn')
                result = obj.get_groupDn();
            else
                if isKey(obj.props_, 'group_dn')
                    result = obj.props_('group_dn');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupDn(obj, value)
            obj.props_('group_dn') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'group_dn')
                result('group_dn') = flywheel.ModelBase.serializeValue(obj.props_('group_dn'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'group_dn')
                result.groupDn = obj.props_('group_dn');
            else
                result.groupDn = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'group_dn')
                    propList.groupDn = obj.props_('group_dn');
                else
                    propList.groupDn = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.LdapSyncConfig;
            if isfield(json, 'group_dn')
                obj.props_('group_dn') = flywheel.ModelBase.deserializeValue(json.group_dn, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.LdapSyncConfig')
                    obj = flywheel.model.LdapSyncConfig(obj);
                end
                if isKey(obj.props_, 'group_dn')
                end
            end
        end
    end
end
