% LdapSyncStatus - LDAP sync status embedded in site settings / projects
%
% LdapSyncStatus Properties:
%    groupDn     
%    lastAttempt 
%    lastSuccess 
%    syncError   
%
% LdapSyncStatus Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef LdapSyncStatus < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'groupDn', 'lastAttempt', 'lastSuccess', 'syncError' }, ...
            { 'group_dn', 'last_attempt', 'last_success', 'sync_error' });
    end
    properties(Dependent)
        groupDn
        lastAttempt
        lastSuccess
        syncError
    end
    methods
        function obj = LdapSyncStatus(varargin)
            obj@flywheel.ModelBase(flywheel.model.LdapSyncStatus.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'groupDn', []);
                addParameter(p, 'lastAttempt', []);
                addParameter(p, 'lastSuccess', []);
                addParameter(p, 'syncError', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.groupDn)
                    obj.props_('group_dn') = p.Results.groupDn;
                end
                if ~isempty(p.Results.lastAttempt)
                    obj.props_('last_attempt') = p.Results.lastAttempt;
                end
                if ~isempty(p.Results.lastSuccess)
                    obj.props_('last_success') = p.Results.lastSuccess;
                end
                if ~isempty(p.Results.syncError)
                    obj.props_('sync_error') = p.Results.syncError;
                end
            end
        end
        function result = get.groupDn(obj)
            if ismethod(obj, 'get_groupDn')
                result = obj.get_groupDn();
            else
                if isKey(obj.props_, 'group_dn')
                    result = obj.props_('group_dn');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupDn(obj, value)
            obj.props_('group_dn') = value;
        end
        function result = get.lastAttempt(obj)
            if ismethod(obj, 'get_lastAttempt')
                result = obj.get_lastAttempt();
            else
                if isKey(obj.props_, 'last_attempt')
                    result = obj.props_('last_attempt');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastAttempt(obj, value)
            obj.props_('last_attempt') = value;
        end
        function result = get.lastSuccess(obj)
            if ismethod(obj, 'get_lastSuccess')
                result = obj.get_lastSuccess();
            else
                if isKey(obj.props_, 'last_success')
                    result = obj.props_('last_success');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastSuccess(obj, value)
            obj.props_('last_success') = value;
        end
        function result = get.syncError(obj)
            if ismethod(obj, 'get_syncError')
                result = obj.get_syncError();
            else
                if isKey(obj.props_, 'sync_error')
                    result = obj.props_('sync_error');
                else
                    result = [];
                end
            end
        end
        function obj = set.syncError(obj, value)
            obj.props_('sync_error') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'group_dn')
                result('group_dn') = flywheel.ModelBase.serializeValue(obj.props_('group_dn'), 'char');
            end
            if isKey(obj.props_, 'last_attempt')
                result('last_attempt') = flywheel.ModelBase.serializeValue(obj.props_('last_attempt'), 'datetime');
            end
            if isKey(obj.props_, 'last_success')
                result('last_success') = flywheel.ModelBase.serializeValue(obj.props_('last_success'), 'datetime');
            end
            if isKey(obj.props_, 'sync_error')
                result('sync_error') = flywheel.ModelBase.serializeValue(obj.props_('sync_error'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'group_dn')
                result.groupDn = obj.props_('group_dn');
            else
                result.groupDn = [];
            end
            if isKey(obj.props_, 'last_attempt')
                result.lastAttempt = obj.props_('last_attempt');
            else
                result.lastAttempt = [];
            end
            if isKey(obj.props_, 'last_success')
                result.lastSuccess = obj.props_('last_success');
            else
                result.lastSuccess = [];
            end
            if isKey(obj.props_, 'sync_error')
                result.syncError = obj.props_('sync_error');
            else
                result.syncError = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'group_dn')
                    propList.groupDn = obj.props_('group_dn');
                else
                    propList.groupDn = [];
                end
                if isKey(obj.props_, 'last_attempt')
                    propList.lastAttempt = obj.props_('last_attempt');
                else
                    propList.lastAttempt = [];
                end
                if isKey(obj.props_, 'last_success')
                    propList.lastSuccess = obj.props_('last_success');
                else
                    propList.lastSuccess = [];
                end
                if isKey(obj.props_, 'sync_error')
                    propList.syncError = obj.props_('sync_error');
                else
                    propList.syncError = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.LdapSyncStatus;
            if isfield(json, 'group_dn')
                obj.props_('group_dn') = flywheel.ModelBase.deserializeValue(json.group_dn, 'char');
            end
            if isfield(json, 'last_attempt')
                obj.props_('last_attempt') = flywheel.ModelBase.deserializeValue(json.last_attempt, 'datetime');
            end
            if isfield(json, 'last_success')
                obj.props_('last_success') = flywheel.ModelBase.deserializeValue(json.last_success, 'datetime');
            end
            if isfield(json, 'sync_error')
                obj.props_('sync_error') = flywheel.ModelBase.deserializeValue(json.sync_error, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.LdapSyncStatus')
                    obj = flywheel.model.LdapSyncStatus(obj);
                end
                if isKey(obj.props_, 'group_dn')
                end
                if isKey(obj.props_, 'last_attempt')
                end
                if isKey(obj.props_, 'last_success')
                end
                if isKey(obj.props_, 'sync_error')
                end
            end
        end
    end
end
