% LegacyUsageReport - An entry in the usage report, describing storage and gear usage
%
% LegacyUsageReport Properties:
%    gearExecutionCount  - The number of gears executed
%    fileMbs             - File storage usage, in megabytes
%    sessionCount        - The number of sessions created
%    year                - The year portion of the entry date
%    month               - The month portion of the entry date
%    project            
%
% LegacyUsageReport Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef LegacyUsageReport < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'gearExecutionCount', 'fileMbs', 'sessionCount', 'year', 'month', 'project' }, ...
            { 'gear_execution_count', 'file_mbs', 'session_count', 'year', 'month', 'project' });
    end
    properties(Dependent)
        gearExecutionCount
        fileMbs
        sessionCount
        year
        month
        project
    end
    methods
        function obj = LegacyUsageReport(varargin)
            obj@flywheel.ModelBase(flywheel.model.LegacyUsageReport.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'gearExecutionCount', 0);
                addParameter(p, 'fileMbs', 0);
                addParameter(p, 'sessionCount', 0);
                addParameter(p, 'year', []);
                addParameter(p, 'month', []);
                addParameter(p, 'project', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.gearExecutionCount)
                    obj.props_('gear_execution_count') = p.Results.gearExecutionCount;
                end
                if ~isempty(p.Results.fileMbs)
                    obj.props_('file_mbs') = p.Results.fileMbs;
                end
                if ~isempty(p.Results.sessionCount)
                    obj.props_('session_count') = p.Results.sessionCount;
                end
                if ~isempty(p.Results.year)
                    obj.props_('year') = p.Results.year;
                end
                if ~isempty(p.Results.month)
                    obj.props_('month') = p.Results.month;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
            end
        end
        function result = get.gearExecutionCount(obj)
            if ismethod(obj, 'get_gearExecutionCount')
                result = obj.get_gearExecutionCount();
            else
                if isKey(obj.props_, 'gear_execution_count')
                    result = obj.props_('gear_execution_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearExecutionCount(obj, value)
            obj.props_('gear_execution_count') = value;
        end
        function result = get.fileMbs(obj)
            if ismethod(obj, 'get_fileMbs')
                result = obj.get_fileMbs();
            else
                if isKey(obj.props_, 'file_mbs')
                    result = obj.props_('file_mbs');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileMbs(obj, value)
            obj.props_('file_mbs') = value;
        end
        function result = get.sessionCount(obj)
            if ismethod(obj, 'get_sessionCount')
                result = obj.get_sessionCount();
            else
                if isKey(obj.props_, 'session_count')
                    result = obj.props_('session_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.sessionCount(obj, value)
            obj.props_('session_count') = value;
        end
        function result = get.year(obj)
            if ismethod(obj, 'get_year')
                result = obj.get_year();
            else
                if isKey(obj.props_, 'year')
                    result = obj.props_('year');
                else
                    result = [];
                end
            end
        end
        function obj = set.year(obj, value)
            obj.props_('year') = value;
        end
        function result = get.month(obj)
            if ismethod(obj, 'get_month')
                result = obj.get_month();
            else
                if isKey(obj.props_, 'month')
                    result = obj.props_('month');
                else
                    result = [];
                end
            end
        end
        function obj = set.month(obj, value)
            obj.props_('month') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'gear_execution_count')
                result('gear_execution_count') = flywheel.ModelBase.serializeValue(obj.props_('gear_execution_count'), 'integer');
            end
            if isKey(obj.props_, 'file_mbs')
                result('file_mbs') = flywheel.ModelBase.serializeValue(obj.props_('file_mbs'), 'float');
            end
            if isKey(obj.props_, 'session_count')
                result('session_count') = flywheel.ModelBase.serializeValue(obj.props_('session_count'), 'integer');
            end
            if isKey(obj.props_, 'year')
                result('year') = flywheel.ModelBase.serializeValue(obj.props_('year'), 'char');
            end
            if isKey(obj.props_, 'month')
                result('month') = flywheel.ModelBase.serializeValue(obj.props_('month'), 'char');
            end
            if isKey(obj.props_, 'project')
                result('project') = obj.props_('project').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'gear_execution_count')
                result.gearExecutionCount = obj.props_('gear_execution_count');
            else
                result.gearExecutionCount = [];
            end
            if isKey(obj.props_, 'file_mbs')
                result.fileMbs = obj.props_('file_mbs');
            else
                result.fileMbs = [];
            end
            if isKey(obj.props_, 'session_count')
                result.sessionCount = obj.props_('session_count');
            else
                result.sessionCount = [];
            end
            if isKey(obj.props_, 'year')
                result.year = obj.props_('year');
            else
                result.year = [];
            end
            if isKey(obj.props_, 'month')
                result.month = obj.props_('month');
            else
                result.month = [];
            end
            if isKey(obj.props_, 'project')
                result.project = struct(obj.props_('project'));
            else
                result.project = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'gear_execution_count')
                    propList.gearExecutionCount = obj.props_('gear_execution_count');
                else
                    propList.gearExecutionCount = [];
                end
                if isKey(obj.props_, 'file_mbs')
                    propList.fileMbs = obj.props_('file_mbs');
                else
                    propList.fileMbs = [];
                end
                if isKey(obj.props_, 'session_count')
                    propList.sessionCount = obj.props_('session_count');
                else
                    propList.sessionCount = [];
                end
                if isKey(obj.props_, 'year')
                    propList.year = obj.props_('year');
                else
                    propList.year = [];
                end
                if isKey(obj.props_, 'month')
                    propList.month = obj.props_('month');
                else
                    propList.month = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.LegacyUsageReport;
            if isfield(json, 'gear_execution_count')
                obj.props_('gear_execution_count') = flywheel.ModelBase.deserializeValue(json.gear_execution_count, 'integer');
            end
            if isfield(json, 'file_mbs')
                obj.props_('file_mbs') = flywheel.ModelBase.deserializeValue(json.file_mbs, 'float');
            end
            if isfield(json, 'session_count')
                obj.props_('session_count') = flywheel.ModelBase.deserializeValue(json.session_count, 'integer');
            end
            if isfield(json, 'year')
                obj.props_('year') = flywheel.ModelBase.deserializeValue(json.year, 'char');
            end
            if isfield(json, 'month')
                obj.props_('month') = flywheel.ModelBase.deserializeValue(json.month, 'char');
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.model.LegacysUsageProjectEntry.fromJson(json.project, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.LegacyUsageReport')
                    obj = flywheel.model.LegacyUsageReport(obj);
                end
                if isKey(obj.props_, 'gear_execution_count')
                end
                if isKey(obj.props_, 'file_mbs')
                end
                if isKey(obj.props_, 'session_count')
                end
                if isKey(obj.props_, 'year')
                end
                if isKey(obj.props_, 'month')
                end
                if isKey(obj.props_, 'project')
                    obj.props_('project') =  flywheel.model.LegacysUsageProjectEntry.ensureIsInstance(obj.props_('project'));
                end
            end
        end
    end
end
