% LocalStorage
%
% LocalStorage Properties:
%    path        
%    configType  
%    configClass 
%
% LocalStorage Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef LocalStorage < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'path', 'configType', 'configClass' }, ...
            { 'path', 'config_type', 'config_class' });
    end
    properties(Dependent)
        path
        configType
        configClass
    end
    methods
        function obj = LocalStorage(varargin)
            obj@flywheel.ModelBase(flywheel.model.LocalStorage.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'path', []);
                addParameter(p, 'configType', &#x27;local&#x27;);
                addParameter(p, 'configClass', &#x27;storage&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.path)
                    obj.props_('path') = p.Results.path;
                end
                if ~isempty(p.Results.configType)
                    obj.props_('config_type') = p.Results.configType;
                end
                if ~isempty(p.Results.configClass)
                    obj.props_('config_class') = p.Results.configClass;
                end
            end
        end
        function result = get.path(obj)
            if ismethod(obj, 'get_path')
                result = obj.get_path();
            else
                if isKey(obj.props_, 'path')
                    result = obj.props_('path');
                else
                    result = [];
                end
            end
        end
        function obj = set.path(obj, value)
            obj.props_('path') = value;
        end
        function result = get.configType(obj)
            if ismethod(obj, 'get_configType')
                result = obj.get_configType();
            else
                if isKey(obj.props_, 'config_type')
                    result = obj.props_('config_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.configType(obj, value)
            obj.props_('config_type') = value;
        end
        function result = get.configClass(obj)
            if ismethod(obj, 'get_configClass')
                result = obj.get_configClass();
            else
                if isKey(obj.props_, 'config_class')
                    result = obj.props_('config_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.configClass(obj, value)
            obj.props_('config_class') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'path')
                result('path') = flywheel.ModelBase.serializeValue(obj.props_('path'), 'char');
            end
            if isKey(obj.props_, 'config_type')
                result('config_type') = flywheel.ModelBase.serializeValue(obj.props_('config_type'), 'char');
            end
            if isKey(obj.props_, 'config_class')
                result('config_class') = flywheel.ModelBase.serializeValue(obj.props_('config_class'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'path')
                result.path = obj.props_('path');
            else
                result.path = [];
            end
            if isKey(obj.props_, 'config_type')
                result.configType = obj.props_('config_type');
            else
                result.configType = [];
            end
            if isKey(obj.props_, 'config_class')
                result.configClass = obj.props_('config_class');
            else
                result.configClass = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'path')
                    propList.path = obj.props_('path');
                else
                    propList.path = [];
                end
                if isKey(obj.props_, 'config_type')
                    propList.configType = obj.props_('config_type');
                else
                    propList.configType = [];
                end
                if isKey(obj.props_, 'config_class')
                    propList.configClass = obj.props_('config_class');
                else
                    propList.configClass = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.LocalStorage;
            if isfield(json, 'path')
                obj.props_('path') = flywheel.ModelBase.deserializeValue(json.path, 'char');
            end
            if isfield(json, 'config_type')
                obj.props_('config_type') = flywheel.ModelBase.deserializeValue(json.config_type, 'char');
            end
            if isfield(json, 'config_class')
                obj.props_('config_class') = flywheel.ModelBase.deserializeValue(json.config_class, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.LocalStorage')
                    obj = flywheel.model.LocalStorage(obj);
                end
                if isKey(obj.props_, 'path')
                end
                if isKey(obj.props_, 'config_type')
                end
                if isKey(obj.props_, 'config_class')
                end
            end
        end
    end
end
