% Location - Representation of a file's location inside the gear container  Attributes:     path (str): The path to the file inside the gear container     name (str): The name of the file
%
% Location Properties:
%    path 
%    name 
%
% Location Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Location < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'path', 'name' }, ...
            { 'path', 'name' });
    end
    properties(Dependent)
        path
        name
    end
    methods
        function obj = Location(varargin)
            obj@flywheel.ModelBase(flywheel.model.Location.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'path', []);
                addParameter(p, 'name', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.path)
                    obj.props_('path') = p.Results.path;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
            end
        end
        function result = get.path(obj)
            if ismethod(obj, 'get_path')
                result = obj.get_path();
            else
                if isKey(obj.props_, 'path')
                    result = obj.props_('path');
                else
                    result = [];
                end
            end
        end
        function obj = set.path(obj, value)
            obj.props_('path') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'path')
                result('path') = flywheel.ModelBase.serializeValue(obj.props_('path'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'path')
                result.path = obj.props_('path');
            else
                result.path = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'path')
                    propList.path = obj.props_('path');
                else
                    propList.path = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Location;
            if isfield(json, 'path')
                obj.props_('path') = flywheel.ModelBase.deserializeValue(json.path, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Location')
                    obj = flywheel.model.Location(obj);
                end
                if isKey(obj.props_, 'path')
                end
                if isKey(obj.props_, 'name')
                end
            end
        end
    end
end
