% MLSetFilter
%
% MLSetFilter Properties:
%    plus  
%    minus 
%
% MLSetFilter Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef MLSetFilter < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'plus', 'minus' }, ...
            { 'plus', 'minus' });
    end
    properties(Dependent)
        plus
        minus
    end
    methods
        function obj = MLSetFilter(varargin)
            obj@flywheel.ModelBase(flywheel.model.MLSetFilter.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'plus', []);
                addParameter(p, 'minus', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.plus)
                    obj.props_('plus') = p.Results.plus;
                end
                if ~isempty(p.Results.minus)
                    obj.props_('minus') = p.Results.minus;
                end
            end
        end
        function result = get.plus(obj)
            if ismethod(obj, 'get_plus')
                result = obj.get_plus();
            else
                if isKey(obj.props_, 'plus')
                    result = obj.props_('plus');
                else
                    result = [];
                end
            end
        end
        function obj = set.plus(obj, value)
            obj.props_('plus') = value;
        end
        function result = get.minus(obj)
            if ismethod(obj, 'get_minus')
                result = obj.get_minus();
            else
                if isKey(obj.props_, 'minus')
                    result = obj.props_('minus');
                else
                    result = [];
                end
            end
        end
        function obj = set.minus(obj, value)
            obj.props_('minus') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'plus')
                result('plus') = flywheel.ModelBase.cellmap(@toJson, obj.props_('plus'));
            end
            if isKey(obj.props_, 'minus')
                result('minus') = flywheel.ModelBase.cellmap(@toJson, obj.props_('minus'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'plus')
                result.plus = flywheel.ModelBase.cellmap(@struct, obj.props_('plus'));
            else
                result.plus = [];
            end
            if isKey(obj.props_, 'minus')
                result.minus = flywheel.ModelBase.cellmap(@struct, obj.props_('minus'));
            else
                result.minus = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'plus')
                    propList.plus = obj.props_('plus');
                else
                    propList.plus = [];
                end
                if isKey(obj.props_, 'minus')
                    propList.minus = obj.props_('minus');
                else
                    propList.minus = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.MLSetFilter;
            if isfield(json, 'plus')
                obj.props_('plus') = flywheel.ModelBase.cellmap(@(x) flywheel.model.MLType.fromJson(x, context), json.plus);
            end
            if isfield(json, 'minus')
                obj.props_('minus') = flywheel.ModelBase.cellmap(@(x) flywheel.model.MLType.fromJson(x, context), json.minus);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.MLSetFilter')
                    obj = flywheel.model.MLSetFilter(obj);
                end
                if isKey(obj.props_, 'plus')
                    obj.props_('plus') = flywheel.ModelBase.cellmap(@flywheel.model.MLType.ensureIsInstance, obj.props_('plus'));
                end
                if isKey(obj.props_, 'minus')
                    obj.props_('minus') = flywheel.ModelBase.cellmap(@flywheel.model.MLType.ensureIsInstance, obj.props_('minus'));
                end
            end
        end
    end
end
