% MasterSubjectCodeInput
%
% MasterSubjectCodeInput Properties:
%    patientId     - Patient id
%    usePatientId  - Use patient ID for identification or first name, last name, DOB
%    firstName     - First name
%    lastName      - Last name
%    dateOfBirth   - Date of birth in YYYY-MM-DD format
%
% MasterSubjectCodeInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef MasterSubjectCodeInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'patientId', 'usePatientId', 'firstName', 'lastName', 'dateOfBirth' }, ...
            { 'patient_id', 'use_patient_id', 'first_name', 'last_name', 'date_of_birth' });
    end
    properties(Dependent)
        patientId
        usePatientId
        firstName
        lastName
        dateOfBirth
    end
    methods
        function obj = MasterSubjectCodeInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.MasterSubjectCodeInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'patientId', []);
                addParameter(p, 'usePatientId', []);
                addParameter(p, 'firstName', []);
                addParameter(p, 'lastName', []);
                addParameter(p, 'dateOfBirth', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.patientId)
                    obj.props_('patient_id') = p.Results.patientId;
                end
                if ~isempty(p.Results.usePatientId)
                    obj.props_('use_patient_id') = p.Results.usePatientId;
                end
                if ~isempty(p.Results.firstName)
                    obj.props_('first_name') = p.Results.firstName;
                end
                if ~isempty(p.Results.lastName)
                    obj.props_('last_name') = p.Results.lastName;
                end
                if ~isempty(p.Results.dateOfBirth)
                    obj.props_('date_of_birth') = p.Results.dateOfBirth;
                end
            end
        end
        function result = get.patientId(obj)
            if ismethod(obj, 'get_patientId')
                result = obj.get_patientId();
            else
                if isKey(obj.props_, 'patient_id')
                    result = obj.props_('patient_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.patientId(obj, value)
            obj.props_('patient_id') = value;
        end
        function result = get.usePatientId(obj)
            if ismethod(obj, 'get_usePatientId')
                result = obj.get_usePatientId();
            else
                if isKey(obj.props_, 'use_patient_id')
                    result = obj.props_('use_patient_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.usePatientId(obj, value)
            obj.props_('use_patient_id') = value;
        end
        function result = get.firstName(obj)
            if ismethod(obj, 'get_firstName')
                result = obj.get_firstName();
            else
                if isKey(obj.props_, 'first_name')
                    result = obj.props_('first_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstName(obj, value)
            obj.props_('first_name') = value;
        end
        function result = get.lastName(obj)
            if ismethod(obj, 'get_lastName')
                result = obj.get_lastName();
            else
                if isKey(obj.props_, 'last_name')
                    result = obj.props_('last_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastName(obj, value)
            obj.props_('last_name') = value;
        end
        function result = get.dateOfBirth(obj)
            if ismethod(obj, 'get_dateOfBirth')
                result = obj.get_dateOfBirth();
            else
                if isKey(obj.props_, 'date_of_birth')
                    result = obj.props_('date_of_birth');
                else
                    result = [];
                end
            end
        end
        function obj = set.dateOfBirth(obj, value)
            obj.props_('date_of_birth') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'patient_id')
                result('patient_id') = flywheel.ModelBase.serializeValue(obj.props_('patient_id'), 'char');
            end
            if isKey(obj.props_, 'use_patient_id')
                result('use_patient_id') = flywheel.ModelBase.serializeValue(obj.props_('use_patient_id'), 'logical');
            end
            if isKey(obj.props_, 'first_name')
                result('first_name') = flywheel.ModelBase.serializeValue(obj.props_('first_name'), 'char');
            end
            if isKey(obj.props_, 'last_name')
                result('last_name') = flywheel.ModelBase.serializeValue(obj.props_('last_name'), 'char');
            end
            if isKey(obj.props_, 'date_of_birth')
                result('date_of_birth') = flywheel.ModelBase.serializeValue(obj.props_('date_of_birth'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'patient_id')
                result.patientId = obj.props_('patient_id');
            else
                result.patientId = [];
            end
            if isKey(obj.props_, 'use_patient_id')
                result.usePatientId = obj.props_('use_patient_id');
            else
                result.usePatientId = [];
            end
            if isKey(obj.props_, 'first_name')
                result.firstName = obj.props_('first_name');
            else
                result.firstName = [];
            end
            if isKey(obj.props_, 'last_name')
                result.lastName = obj.props_('last_name');
            else
                result.lastName = [];
            end
            if isKey(obj.props_, 'date_of_birth')
                result.dateOfBirth = obj.props_('date_of_birth');
            else
                result.dateOfBirth = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'patient_id')
                    propList.patientId = obj.props_('patient_id');
                else
                    propList.patientId = [];
                end
                if isKey(obj.props_, 'use_patient_id')
                    propList.usePatientId = obj.props_('use_patient_id');
                else
                    propList.usePatientId = [];
                end
                if isKey(obj.props_, 'first_name')
                    propList.firstName = obj.props_('first_name');
                else
                    propList.firstName = [];
                end
                if isKey(obj.props_, 'last_name')
                    propList.lastName = obj.props_('last_name');
                else
                    propList.lastName = [];
                end
                if isKey(obj.props_, 'date_of_birth')
                    propList.dateOfBirth = obj.props_('date_of_birth');
                else
                    propList.dateOfBirth = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.MasterSubjectCodeInput;
            if isfield(json, 'patient_id')
                obj.props_('patient_id') = flywheel.ModelBase.deserializeValue(json.patient_id, 'char');
            end
            if isfield(json, 'use_patient_id')
                obj.props_('use_patient_id') = flywheel.ModelBase.deserializeValue(json.use_patient_id, 'logical');
            end
            if isfield(json, 'first_name')
                obj.props_('first_name') = flywheel.ModelBase.deserializeValue(json.first_name, 'char');
            end
            if isfield(json, 'last_name')
                obj.props_('last_name') = flywheel.ModelBase.deserializeValue(json.last_name, 'char');
            end
            if isfield(json, 'date_of_birth')
                obj.props_('date_of_birth') = flywheel.ModelBase.deserializeValue(json.date_of_birth, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.MasterSubjectCodeInput')
                    obj = flywheel.model.MasterSubjectCodeInput(obj);
                end
                if isKey(obj.props_, 'patient_id')
                end
                if isKey(obj.props_, 'use_patient_id')
                end
                if isKey(obj.props_, 'first_name')
                end
                if isKey(obj.props_, 'last_name')
                end
                if isKey(obj.props_, 'date_of_birth')
                end
            end
        end
    end
end
