% ModalityModify
%
% ModalityModify Properties:
%    classification 
%    active         
%    description    
%
% ModalityModify Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ModalityModify < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'classification', 'active', 'description' }, ...
            { 'classification', 'active', 'description' });
    end
    properties(Dependent)
        classification
        active
        description
    end
    methods
        function obj = ModalityModify(varargin)
            obj@flywheel.ModelBase(flywheel.model.ModalityModify.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'classification', []);
                addParameter(p, 'active', []);
                addParameter(p, 'description', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.classification)
                    obj.props_('classification') = p.Results.classification;
                end
                if ~isempty(p.Results.active)
                    obj.props_('active') = p.Results.active;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
            end
        end
        function result = get.classification(obj)
            if ismethod(obj, 'get_classification')
                result = obj.get_classification();
            else
                if isKey(obj.props_, 'classification')
                    result = obj.props_('classification');
                else
                    result = [];
                end
            end
        end
        function obj = set.classification(obj, value)
            obj.props_('classification') = value;
        end
        function result = get.active(obj)
            if ismethod(obj, 'get_active')
                result = obj.get_active();
            else
                if isKey(obj.props_, 'active')
                    result = obj.props_('active');
                else
                    result = [];
                end
            end
        end
        function obj = set.active(obj, value)
            obj.props_('active') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'classification')
                result('classification') = flywheel.ModelBase.serializeValue(obj.props_('classification'), 'containers.Map[String, vector[char]]');
            end
            if isKey(obj.props_, 'active')
                result('active') = flywheel.ModelBase.serializeValue(obj.props_('active'), 'logical');
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'classification')
                result.classification = obj.props_('classification');
            else
                result.classification = [];
            end
            if isKey(obj.props_, 'active')
                result.active = obj.props_('active');
            else
                result.active = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'classification')
                    propList.classification = obj.props_('classification');
                else
                    propList.classification = [];
                end
                if isKey(obj.props_, 'active')
                    propList.active = obj.props_('active');
                else
                    propList.active = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ModalityModify;
            if isfield(json, 'classification')
                obj.props_('classification') = flywheel.ModelBase.deserializeValue(json.classification, 'containers.Map[String, vector[char]]');
            end
            if isfield(json, 'active')
                obj.props_('active') = flywheel.ModelBase.deserializeValue(json.active, 'logical');
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ModalityModify')
                    obj = flywheel.model.ModalityModify(obj);
                end
                if isKey(obj.props_, 'classification')
                end
                if isKey(obj.props_, 'active')
                end
                if isKey(obj.props_, 'description')
                end
            end
        end
    end
end
