% ModifiedResult
%
% ModifiedResult Properties:
%    modified    
%    jobsSpawned 
%
% ModifiedResult Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ModifiedResult < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'modified', 'jobsSpawned' }, ...
            { 'modified', 'jobs_spawned' });
    end
    properties(Dependent)
        modified
        jobsSpawned
    end
    methods
        function obj = ModifiedResult(varargin)
            obj@flywheel.ModelBase(flywheel.model.ModifiedResult.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'modified', []);
                addParameter(p, 'jobsSpawned', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.jobsSpawned)
                    obj.props_('jobs_spawned') = p.Results.jobsSpawned;
                end
            end
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.jobsSpawned(obj)
            if ismethod(obj, 'get_jobsSpawned')
                result = obj.get_jobsSpawned();
            else
                if isKey(obj.props_, 'jobs_spawned')
                    result = obj.props_('jobs_spawned');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobsSpawned(obj, value)
            obj.props_('jobs_spawned') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'integer');
            end
            if isKey(obj.props_, 'jobs_spawned')
                result('jobs_spawned') = flywheel.ModelBase.serializeValue(obj.props_('jobs_spawned'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'jobs_spawned')
                result.jobsSpawned = obj.props_('jobs_spawned');
            else
                result.jobsSpawned = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'jobs_spawned')
                    propList.jobsSpawned = obj.props_('jobs_spawned');
                else
                    propList.jobsSpawned = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ModifiedResult;
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'integer');
            end
            if isfield(json, 'jobs_spawned')
                obj.props_('jobs_spawned') = flywheel.ModelBase.deserializeValue(json.jobs_spawned, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ModifiedResult')
                    obj = flywheel.model.ModifiedResult(obj);
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'jobs_spawned')
                end
            end
        end
    end
end
