% ModifyUserInput
%
% ModifyUserInput Properties:
%    firstname       
%    lastname        
%    email           
%    avatars         
%    avatar          
%    roles           
%    disabled        
%    preferences     
%    root            
%    password        
%    centralRevision 
%    azuremlAccount  
%
% ModifyUserInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ModifyUserInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'firstname', 'lastname', 'email', 'avatars', 'avatar', 'roles', 'disabled', 'preferences', 'root', 'password', 'centralRevision', 'azuremlAccount' }, ...
            { 'firstname', 'lastname', 'email', 'avatars', 'avatar', 'roles', 'disabled', 'preferences', 'root', 'password', 'central_revision', 'azureml_account' });
    end
    properties(Dependent)
        firstname
        lastname
        email
        avatars
        avatar
        roles
        disabled
        preferences
        root
        password
        centralRevision
        azuremlAccount
    end
    methods
        function obj = ModifyUserInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ModifyUserInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'firstname', []);
                addParameter(p, 'lastname', []);
                addParameter(p, 'email', []);
                addParameter(p, 'avatars', []);
                addParameter(p, 'avatar', []);
                addParameter(p, 'roles', []);
                addParameter(p, 'disabled', []);
                addParameter(p, 'preferences', []);
                addParameter(p, 'root', []);
                addParameter(p, 'password', []);
                addParameter(p, 'centralRevision', []);
                addParameter(p, 'azuremlAccount', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.firstname)
                    obj.props_('firstname') = p.Results.firstname;
                end
                if ~isempty(p.Results.lastname)
                    obj.props_('lastname') = p.Results.lastname;
                end
                if ~isempty(p.Results.email)
                    obj.props_('email') = p.Results.email;
                end
                if ~isempty(p.Results.avatars)
                    obj.props_('avatars') = p.Results.avatars;
                end
                if ~isempty(p.Results.avatar)
                    obj.props_('avatar') = p.Results.avatar;
                end
                if ~isempty(p.Results.roles)
                    obj.props_('roles') = p.Results.roles;
                end
                if ~isempty(p.Results.disabled)
                    obj.props_('disabled') = p.Results.disabled;
                end
                if ~isempty(p.Results.preferences)
                    obj.props_('preferences') = p.Results.preferences;
                end
                if ~isempty(p.Results.root)
                    obj.props_('root') = p.Results.root;
                end
                if ~isempty(p.Results.password)
                    obj.props_('password') = p.Results.password;
                end
                if ~isempty(p.Results.centralRevision)
                    obj.props_('central_revision') = p.Results.centralRevision;
                end
                if ~isempty(p.Results.azuremlAccount)
                    obj.props_('azureml_account') = p.Results.azuremlAccount;
                end
            end
        end
        function result = get.firstname(obj)
            if ismethod(obj, 'get_firstname')
                result = obj.get_firstname();
            else
                if isKey(obj.props_, 'firstname')
                    result = obj.props_('firstname');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstname(obj, value)
            obj.props_('firstname') = value;
        end
        function result = get.lastname(obj)
            if ismethod(obj, 'get_lastname')
                result = obj.get_lastname();
            else
                if isKey(obj.props_, 'lastname')
                    result = obj.props_('lastname');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastname(obj, value)
            obj.props_('lastname') = value;
        end
        function result = get.email(obj)
            if ismethod(obj, 'get_email')
                result = obj.get_email();
            else
                if isKey(obj.props_, 'email')
                    result = obj.props_('email');
                else
                    result = [];
                end
            end
        end
        function obj = set.email(obj, value)
            obj.props_('email') = value;
        end
        function result = get.avatars(obj)
            if ismethod(obj, 'get_avatars')
                result = obj.get_avatars();
            else
                if isKey(obj.props_, 'avatars')
                    result = obj.props_('avatars');
                else
                    result = [];
                end
            end
        end
        function obj = set.avatars(obj, value)
            obj.props_('avatars') = value;
        end
        function result = get.avatar(obj)
            if ismethod(obj, 'get_avatar')
                result = obj.get_avatar();
            else
                if isKey(obj.props_, 'avatar')
                    result = obj.props_('avatar');
                else
                    result = [];
                end
            end
        end
        function obj = set.avatar(obj, value)
            obj.props_('avatar') = value;
        end
        function result = get.roles(obj)
            if ismethod(obj, 'get_roles')
                result = obj.get_roles();
            else
                if isKey(obj.props_, 'roles')
                    result = obj.props_('roles');
                else
                    result = [];
                end
            end
        end
        function obj = set.roles(obj, value)
            obj.props_('roles') = value;
        end
        function result = get.disabled(obj)
            if ismethod(obj, 'get_disabled')
                result = obj.get_disabled();
            else
                if isKey(obj.props_, 'disabled')
                    result = obj.props_('disabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.disabled(obj, value)
            obj.props_('disabled') = value;
        end
        function result = get.preferences(obj)
            if ismethod(obj, 'get_preferences')
                result = obj.get_preferences();
            else
                if isKey(obj.props_, 'preferences')
                    result = obj.props_('preferences');
                else
                    result = [];
                end
            end
        end
        function obj = set.preferences(obj, value)
            obj.props_('preferences') = value;
        end
        function result = get.root(obj)
            if ismethod(obj, 'get_root')
                result = obj.get_root();
            else
                if isKey(obj.props_, 'root')
                    result = obj.props_('root');
                else
                    result = [];
                end
            end
        end
        function obj = set.root(obj, value)
            obj.props_('root') = value;
        end
        function result = get.password(obj)
            if ismethod(obj, 'get_password')
                result = obj.get_password();
            else
                if isKey(obj.props_, 'password')
                    result = obj.props_('password');
                else
                    result = [];
                end
            end
        end
        function obj = set.password(obj, value)
            obj.props_('password') = value;
        end
        function result = get.centralRevision(obj)
            if ismethod(obj, 'get_centralRevision')
                result = obj.get_centralRevision();
            else
                if isKey(obj.props_, 'central_revision')
                    result = obj.props_('central_revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.centralRevision(obj, value)
            obj.props_('central_revision') = value;
        end
        function result = get.azuremlAccount(obj)
            if ismethod(obj, 'get_azuremlAccount')
                result = obj.get_azuremlAccount();
            else
                if isKey(obj.props_, 'azureml_account')
                    result = obj.props_('azureml_account');
                else
                    result = [];
                end
            end
        end
        function obj = set.azuremlAccount(obj, value)
            obj.props_('azureml_account') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'firstname')
                result('firstname') = flywheel.ModelBase.serializeValue(obj.props_('firstname'), 'char');
            end
            if isKey(obj.props_, 'lastname')
                result('lastname') = flywheel.ModelBase.serializeValue(obj.props_('lastname'), 'char');
            end
            if isKey(obj.props_, 'email')
                result('email') = flywheel.ModelBase.serializeValue(obj.props_('email'), 'char');
            end
            if isKey(obj.props_, 'avatars')
                result('avatars') = obj.props_('avatars').toJson();
            end
            if isKey(obj.props_, 'avatar')
                result('avatar') = flywheel.ModelBase.serializeValue(obj.props_('avatar'), 'char');
            end
            if isKey(obj.props_, 'roles')
                result('roles') = flywheel.ModelBase.cellmap(@toJson, obj.props_('roles'));
            end
            if isKey(obj.props_, 'disabled')
                result('disabled') = flywheel.ModelBase.serializeValue(obj.props_('disabled'), 'logical');
            end
            if isKey(obj.props_, 'preferences')
                result('preferences') = obj.props_('preferences').toJson();
            end
            if isKey(obj.props_, 'root')
                result('root') = flywheel.ModelBase.serializeValue(obj.props_('root'), 'logical');
            end
            if isKey(obj.props_, 'password')
                result('password') = flywheel.ModelBase.serializeValue(obj.props_('password'), 'char');
            end
            if isKey(obj.props_, 'central_revision')
                result('central_revision') = flywheel.ModelBase.serializeValue(obj.props_('central_revision'), 'integer');
            end
            if isKey(obj.props_, 'azureml_account')
                result('azureml_account') = obj.props_('azureml_account').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'firstname')
                result.firstname = obj.props_('firstname');
            else
                result.firstname = [];
            end
            if isKey(obj.props_, 'lastname')
                result.lastname = obj.props_('lastname');
            else
                result.lastname = [];
            end
            if isKey(obj.props_, 'email')
                result.email = obj.props_('email');
            else
                result.email = [];
            end
            if isKey(obj.props_, 'avatars')
                result.avatars = struct(obj.props_('avatars'));
            else
                result.avatars = [];
            end
            if isKey(obj.props_, 'avatar')
                result.avatar = obj.props_('avatar');
            else
                result.avatar = [];
            end
            if isKey(obj.props_, 'roles')
                result.roles = flywheel.ModelBase.cellmap(@struct, obj.props_('roles'));
            else
                result.roles = [];
            end
            if isKey(obj.props_, 'disabled')
                result.disabled = obj.props_('disabled');
            else
                result.disabled = [];
            end
            if isKey(obj.props_, 'preferences')
                result.preferences = struct(obj.props_('preferences'));
            else
                result.preferences = [];
            end
            if isKey(obj.props_, 'root')
                result.root = obj.props_('root');
            else
                result.root = [];
            end
            if isKey(obj.props_, 'password')
                result.password = obj.props_('password');
            else
                result.password = [];
            end
            if isKey(obj.props_, 'central_revision')
                result.centralRevision = obj.props_('central_revision');
            else
                result.centralRevision = [];
            end
            if isKey(obj.props_, 'azureml_account')
                result.azuremlAccount = struct(obj.props_('azureml_account'));
            else
                result.azuremlAccount = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'firstname')
                    propList.firstname = obj.props_('firstname');
                else
                    propList.firstname = [];
                end
                if isKey(obj.props_, 'lastname')
                    propList.lastname = obj.props_('lastname');
                else
                    propList.lastname = [];
                end
                if isKey(obj.props_, 'email')
                    propList.email = obj.props_('email');
                else
                    propList.email = [];
                end
                if isKey(obj.props_, 'avatars')
                    propList.avatars = obj.props_('avatars');
                else
                    propList.avatars = [];
                end
                if isKey(obj.props_, 'avatar')
                    propList.avatar = obj.props_('avatar');
                else
                    propList.avatar = [];
                end
                if isKey(obj.props_, 'roles')
                    propList.roles = obj.props_('roles');
                else
                    propList.roles = [];
                end
                if isKey(obj.props_, 'disabled')
                    propList.disabled = obj.props_('disabled');
                else
                    propList.disabled = [];
                end
                if isKey(obj.props_, 'preferences')
                    propList.preferences = obj.props_('preferences');
                else
                    propList.preferences = [];
                end
                if isKey(obj.props_, 'root')
                    propList.root = obj.props_('root');
                else
                    propList.root = [];
                end
                if isKey(obj.props_, 'password')
                    propList.password = obj.props_('password');
                else
                    propList.password = [];
                end
                if isKey(obj.props_, 'central_revision')
                    propList.centralRevision = obj.props_('central_revision');
                else
                    propList.centralRevision = [];
                end
                if isKey(obj.props_, 'azureml_account')
                    propList.azuremlAccount = obj.props_('azureml_account');
                else
                    propList.azuremlAccount = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ModifyUserInput;
            if isfield(json, 'firstname')
                obj.props_('firstname') = flywheel.ModelBase.deserializeValue(json.firstname, 'char');
            end
            if isfield(json, 'lastname')
                obj.props_('lastname') = flywheel.ModelBase.deserializeValue(json.lastname, 'char');
            end
            if isfield(json, 'email')
                obj.props_('email') = flywheel.ModelBase.deserializeValue(json.email, 'char');
            end
            if isfield(json, 'avatars')
                obj.props_('avatars') = flywheel.model.Avatars.fromJson(json.avatars, context);
            end
            if isfield(json, 'avatar')
                obj.props_('avatar') = flywheel.ModelBase.deserializeValue(json.avatar, 'char');
            end
            if isfield(json, 'roles')
                obj.props_('roles') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RoleType.fromJson(x, context), json.roles);
            end
            if isfield(json, 'disabled')
                obj.props_('disabled') = flywheel.ModelBase.deserializeValue(json.disabled, 'logical');
            end
            if isfield(json, 'preferences')
                obj.props_('preferences') = flywheel.model.UserPreferences.fromJson(json.preferences, context);
            end
            if isfield(json, 'root')
                obj.props_('root') = flywheel.ModelBase.deserializeValue(json.root, 'logical');
            end
            if isfield(json, 'password')
                obj.props_('password') = flywheel.ModelBase.deserializeValue(json.password, 'char');
            end
            if isfield(json, 'central_revision')
                obj.props_('central_revision') = flywheel.ModelBase.deserializeValue(json.central_revision, 'integer');
            end
            if isfield(json, 'azureml_account')
                obj.props_('azureml_account') = flywheel.model.AzureMLAccount.fromJson(json.azureml_account, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ModifyUserInput')
                    obj = flywheel.model.ModifyUserInput(obj);
                end
                if isKey(obj.props_, 'firstname')
                end
                if isKey(obj.props_, 'lastname')
                end
                if isKey(obj.props_, 'email')
                end
                if isKey(obj.props_, 'avatars')
                    obj.props_('avatars') =  flywheel.model.Avatars.ensureIsInstance(obj.props_('avatars'));
                end
                if isKey(obj.props_, 'avatar')
                end
                if isKey(obj.props_, 'roles')
                    obj.props_('roles') = flywheel.ModelBase.cellmap(@flywheel.model.RoleType.ensureIsInstance, obj.props_('roles'));
                end
                if isKey(obj.props_, 'disabled')
                end
                if isKey(obj.props_, 'preferences')
                    obj.props_('preferences') =  flywheel.model.UserPreferences.ensureIsInstance(obj.props_('preferences'));
                end
                if isKey(obj.props_, 'root')
                end
                if isKey(obj.props_, 'password')
                end
                if isKey(obj.props_, 'central_revision')
                end
                if isKey(obj.props_, 'azureml_account')
                    obj.props_('azureml_account') =  flywheel.model.AzureMLAccount.ensureIsInstance(obj.props_('azureml_account'));
                end
            end
        end
    end
end
