% MoveConflict - Model for representing a label/code conflict on a bulk move.  Attributes:     MoveType (ContainerType, ContainerType): 2-tuple of the type of object being         moved and the destination type     id (str): ID of the object being moved     conflict_with_id (str): ID of the object its label conflicts with     conflict_label (str): The conflicting label if there is a label conflict     label (str): Label the object being moved will be changed to if moving with         conflict_mode = move     subject_code (optional str): If moving sessions to projects, the code shared         by the source and destintion subjects on a conflict.
%
% MoveConflict Properties:
%    moveType      
%    id            
%    conflictWith  
%    conflictLabel 
%    label         
%    subjectCode   
%
% MoveConflict Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef MoveConflict < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'moveType', 'id', 'conflictWith', 'conflictLabel', 'label', 'subjectCode' }, ...
            { 'move_type', 'id', 'conflict_with', 'conflict_label', 'label', 'subject_code' });
    end
    properties(Dependent)
        moveType
        id
        conflictWith
        conflictLabel
        label
        subjectCode
    end
    methods
        function obj = MoveConflict(varargin)
            obj@flywheel.ModelBase(flywheel.model.MoveConflict.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'moveType', []);
                addParameter(p, 'id', []);
                addParameter(p, 'conflictWith', []);
                addParameter(p, 'conflictLabel', []);
                addParameter(p, 'label', []);
                addParameter(p, 'subjectCode', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.moveType)
                    obj.props_('move_type') = p.Results.moveType;
                end
                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.conflictWith)
                    obj.props_('conflict_with') = p.Results.conflictWith;
                end
                if ~isempty(p.Results.conflictLabel)
                    obj.props_('conflict_label') = p.Results.conflictLabel;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.subjectCode)
                    obj.props_('subject_code') = p.Results.subjectCode;
                end
            end
        end
        function result = get.moveType(obj)
            if ismethod(obj, 'get_moveType')
                result = obj.get_moveType();
            else
                if isKey(obj.props_, 'move_type')
                    result = obj.props_('move_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.moveType(obj, value)
            obj.props_('move_type') = value;
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.conflictWith(obj)
            if ismethod(obj, 'get_conflictWith')
                result = obj.get_conflictWith();
            else
                if isKey(obj.props_, 'conflict_with')
                    result = obj.props_('conflict_with');
                else
                    result = [];
                end
            end
        end
        function obj = set.conflictWith(obj, value)
            obj.props_('conflict_with') = value;
        end
        function result = get.conflictLabel(obj)
            if ismethod(obj, 'get_conflictLabel')
                result = obj.get_conflictLabel();
            else
                if isKey(obj.props_, 'conflict_label')
                    result = obj.props_('conflict_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.conflictLabel(obj, value)
            obj.props_('conflict_label') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.subjectCode(obj)
            if ismethod(obj, 'get_subjectCode')
                result = obj.get_subjectCode();
            else
                if isKey(obj.props_, 'subject_code')
                    result = obj.props_('subject_code');
                else
                    result = [];
                end
            end
        end
        function obj = set.subjectCode(obj, value)
            obj.props_('subject_code') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'move_type')
                result('move_type') = flywheel.ModelBase.cellmap(@toJson, obj.props_('move_type'));
            end
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'conflict_with')
                result('conflict_with') = obj.props_('conflict_with').toJson();
            end
            if isKey(obj.props_, 'conflict_label')
                result('conflict_label') = flywheel.ModelBase.serializeValue(obj.props_('conflict_label'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'subject_code')
                result('subject_code') = flywheel.ModelBase.serializeValue(obj.props_('subject_code'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'move_type')
                result.moveType = flywheel.ModelBase.cellmap(@struct, obj.props_('move_type'));
            else
                result.moveType = [];
            end
            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'conflict_with')
                result.conflictWith = struct(obj.props_('conflict_with'));
            else
                result.conflictWith = [];
            end
            if isKey(obj.props_, 'conflict_label')
                result.conflictLabel = obj.props_('conflict_label');
            else
                result.conflictLabel = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'subject_code')
                result.subjectCode = obj.props_('subject_code');
            else
                result.subjectCode = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'move_type')
                    propList.moveType = obj.props_('move_type');
                else
                    propList.moveType = [];
                end
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'conflict_with')
                    propList.conflictWith = obj.props_('conflict_with');
                else
                    propList.conflictWith = [];
                end
                if isKey(obj.props_, 'conflict_label')
                    propList.conflictLabel = obj.props_('conflict_label');
                else
                    propList.conflictLabel = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'subject_code')
                    propList.subjectCode = obj.props_('subject_code');
                else
                    propList.subjectCode = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.MoveConflict;
            if isfield(json, 'move_type')
                obj.props_('move_type') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ContainerType.fromJson(x, context), json.move_type);
            end
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'conflict_with')
                obj.props_('conflict_with') = flywheel.model.ContainerReference.fromJson(json.conflict_with, context);
            end
            if isfield(json, 'conflict_label')
                obj.props_('conflict_label') = flywheel.ModelBase.deserializeValue(json.conflict_label, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'subject_code')
                obj.props_('subject_code') = flywheel.ModelBase.deserializeValue(json.subject_code, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.MoveConflict')
                    obj = flywheel.model.MoveConflict(obj);
                end
                if isKey(obj.props_, 'move_type')
                    obj.props_('move_type') = flywheel.ModelBase.cellmap(@flywheel.model.ContainerType.ensureIsInstance, obj.props_('move_type'));
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'conflict_with')
                    obj.props_('conflict_with') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('conflict_with'));
                end
                if isKey(obj.props_, 'conflict_label')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'subject_code')
                end
            end
        end
    end
end
