% Note
%
% Note Properties:
%    id         - Unique database ID
%    created    - Creation time (automatically set)
%    modified   - Last modification time (automatically updated)
%    timestamp 
%    firstname 
%    lastname  
%    text       - The actual contents of the note
%    user       - Database ID of a user
%    avatar     - Last modification time (automatically updated)
%
% Note Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Note < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'created', 'modified', 'timestamp', 'firstname', 'lastname', 'text', 'user', 'avatar' }, ...
            { '_id', 'created', 'modified', 'timestamp', 'firstname', 'lastname', 'text', 'user', 'avatar' });
    end
    properties(Dependent)
        id
        created
        modified
        timestamp
        firstname
        lastname
        text
        user
        avatar
    end
    methods
        function obj = Note(varargin)
            obj@flywheel.ModelBase(flywheel.model.Note.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'timestamp', []);
                addParameter(p, 'firstname', []);
                addParameter(p, 'lastname', []);
                addParameter(p, 'text', []);
                addParameter(p, 'user', []);
                addParameter(p, 'avatar', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.timestamp)
                    obj.props_('timestamp') = p.Results.timestamp;
                end
                if ~isempty(p.Results.firstname)
                    obj.props_('firstname') = p.Results.firstname;
                end
                if ~isempty(p.Results.lastname)
                    obj.props_('lastname') = p.Results.lastname;
                end
                if ~isempty(p.Results.text)
                    obj.props_('text') = p.Results.text;
                end
                if ~isempty(p.Results.user)
                    obj.props_('user') = p.Results.user;
                end
                if ~isempty(p.Results.avatar)
                    obj.props_('avatar') = p.Results.avatar;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.timestamp(obj)
            if ismethod(obj, 'get_timestamp')
                result = obj.get_timestamp();
            else
                if isKey(obj.props_, 'timestamp')
                    result = obj.props_('timestamp');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestamp(obj, value)
            obj.props_('timestamp') = value;
        end
        function result = get.firstname(obj)
            if ismethod(obj, 'get_firstname')
                result = obj.get_firstname();
            else
                if isKey(obj.props_, 'firstname')
                    result = obj.props_('firstname');
                else
                    result = [];
                end
            end
        end
        function obj = set.firstname(obj, value)
            obj.props_('firstname') = value;
        end
        function result = get.lastname(obj)
            if ismethod(obj, 'get_lastname')
                result = obj.get_lastname();
            else
                if isKey(obj.props_, 'lastname')
                    result = obj.props_('lastname');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastname(obj, value)
            obj.props_('lastname') = value;
        end
        function result = get.text(obj)
            if ismethod(obj, 'get_text')
                result = obj.get_text();
            else
                if isKey(obj.props_, 'text')
                    result = obj.props_('text');
                else
                    result = [];
                end
            end
        end
        function obj = set.text(obj, value)
            obj.props_('text') = value;
        end
        function result = get.user(obj)
            if ismethod(obj, 'get_user')
                result = obj.get_user();
            else
                if isKey(obj.props_, 'user')
                    result = obj.props_('user');
                else
                    result = [];
                end
            end
        end
        function obj = set.user(obj, value)
            obj.props_('user') = value;
        end
        function result = get.avatar(obj)
            if ismethod(obj, 'get_avatar')
                result = obj.get_avatar();
            else
                if isKey(obj.props_, 'avatar')
                    result = obj.props_('avatar');
                else
                    result = [];
                end
            end
        end
        function obj = set.avatar(obj, value)
            obj.props_('avatar') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'timestamp')
                result('timestamp') = flywheel.ModelBase.serializeValue(obj.props_('timestamp'), 'datetime');
            end
            if isKey(obj.props_, 'firstname')
                result('firstname') = flywheel.ModelBase.serializeValue(obj.props_('firstname'), 'char');
            end
            if isKey(obj.props_, 'lastname')
                result('lastname') = flywheel.ModelBase.serializeValue(obj.props_('lastname'), 'char');
            end
            if isKey(obj.props_, 'text')
                result('text') = flywheel.ModelBase.serializeValue(obj.props_('text'), 'char');
            end
            if isKey(obj.props_, 'user')
                result('user') = flywheel.ModelBase.serializeValue(obj.props_('user'), 'char');
            end
            if isKey(obj.props_, 'avatar')
                result('avatar') = flywheel.ModelBase.serializeValue(obj.props_('avatar'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'timestamp')
                result.timestamp = obj.props_('timestamp');
            else
                result.timestamp = [];
            end
            if isKey(obj.props_, 'firstname')
                result.firstname = obj.props_('firstname');
            else
                result.firstname = [];
            end
            if isKey(obj.props_, 'lastname')
                result.lastname = obj.props_('lastname');
            else
                result.lastname = [];
            end
            if isKey(obj.props_, 'text')
                result.text = obj.props_('text');
            else
                result.text = [];
            end
            if isKey(obj.props_, 'user')
                result.user = obj.props_('user');
            else
                result.user = [];
            end
            if isKey(obj.props_, 'avatar')
                result.avatar = obj.props_('avatar');
            else
                result.avatar = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'timestamp')
                    propList.timestamp = obj.props_('timestamp');
                else
                    propList.timestamp = [];
                end
                if isKey(obj.props_, 'firstname')
                    propList.firstname = obj.props_('firstname');
                else
                    propList.firstname = [];
                end
                if isKey(obj.props_, 'lastname')
                    propList.lastname = obj.props_('lastname');
                else
                    propList.lastname = [];
                end
                if isKey(obj.props_, 'text')
                    propList.text = obj.props_('text');
                else
                    propList.text = [];
                end
                if isKey(obj.props_, 'user')
                    propList.user = obj.props_('user');
                else
                    propList.user = [];
                end
                if isKey(obj.props_, 'avatar')
                    propList.avatar = obj.props_('avatar');
                else
                    propList.avatar = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Note;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'timestamp')
                obj.props_('timestamp') = flywheel.ModelBase.deserializeValue(json.timestamp, 'datetime');
            end
            if isfield(json, 'firstname')
                obj.props_('firstname') = flywheel.ModelBase.deserializeValue(json.firstname, 'char');
            end
            if isfield(json, 'lastname')
                obj.props_('lastname') = flywheel.ModelBase.deserializeValue(json.lastname, 'char');
            end
            if isfield(json, 'text')
                obj.props_('text') = flywheel.ModelBase.deserializeValue(json.text, 'char');
            end
            if isfield(json, 'user')
                obj.props_('user') = flywheel.ModelBase.deserializeValue(json.user, 'char');
            end
            if isfield(json, 'avatar')
                obj.props_('avatar') = flywheel.ModelBase.deserializeValue(json.avatar, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Note')
                    obj = flywheel.model.Note(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'timestamp')
                end
                if isKey(obj.props_, 'firstname')
                end
                if isKey(obj.props_, 'lastname')
                end
                if isKey(obj.props_, 'text')
                end
                if isKey(obj.props_, 'user')
                end
                if isKey(obj.props_, 'avatar')
                end
            end
        end
    end
end
