% PackfileRemovedOutput
%
% PackfileRemovedOutput Properties:
%    tokens 
%    files  
%
% PackfileRemovedOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef PackfileRemovedOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'tokens', 'files' }, ...
            { 'tokens', 'files' });
    end
    properties(Dependent)
        tokens
        files
    end
    methods
        function obj = PackfileRemovedOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.PackfileRemovedOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'tokens', []);
                addParameter(p, 'files', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.tokens)
                    obj.props_('tokens') = p.Results.tokens;
                end
                if ~isempty(p.Results.files)
                    obj.props_('files') = p.Results.files;
                end
            end
        end
        function result = get.tokens(obj)
            if ismethod(obj, 'get_tokens')
                result = obj.get_tokens();
            else
                if isKey(obj.props_, 'tokens')
                    result = obj.props_('tokens');
                else
                    result = [];
                end
            end
        end
        function obj = set.tokens(obj, value)
            obj.props_('tokens') = value;
        end
        function result = get.files(obj)
            if ismethod(obj, 'get_files')
                result = obj.get_files();
            else
                if isKey(obj.props_, 'files')
                    result = obj.props_('files');
                else
                    result = [];
                end
            end
        end
        function obj = set.files(obj, value)
            obj.props_('files') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'tokens')
                result('tokens') = flywheel.ModelBase.serializeValue(obj.props_('tokens'), 'integer');
            end
            if isKey(obj.props_, 'files')
                result('files') = flywheel.ModelBase.serializeValue(obj.props_('files'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'tokens')
                result.tokens = obj.props_('tokens');
            else
                result.tokens = [];
            end
            if isKey(obj.props_, 'files')
                result.files = obj.props_('files');
            else
                result.files = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'tokens')
                    propList.tokens = obj.props_('tokens');
                else
                    propList.tokens = [];
                end
                if isKey(obj.props_, 'files')
                    propList.files = obj.props_('files');
                else
                    propList.files = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.PackfileRemovedOutput;
            if isfield(json, 'tokens')
                obj.props_('tokens') = flywheel.ModelBase.deserializeValue(json.tokens, 'integer');
            end
            if isfield(json, 'files')
                obj.props_('files') = flywheel.ModelBase.deserializeValue(json.files, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.PackfileRemovedOutput')
                    obj = flywheel.model.PackfileRemovedOutput(obj);
                end
                if isKey(obj.props_, 'tokens')
                end
                if isKey(obj.props_, 'files')
                end
            end
        end
    end
end
