% Page - Generic model of a page.
%
% Page Properties:
%    count   
%    total   
%    results 
%
% Page Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Page < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'count', 'total', 'results' }, ...
            { 'count', 'total', 'results' });
    end
    properties(Dependent)
        count
        total
        results
    end
    methods
        function obj = Page(varargin)
            obj@flywheel.ModelBase(flywheel.model.Page.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'count', []);
                addParameter(p, 'total', []);
                addParameter(p, 'results', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.count)
                    obj.props_('count') = p.Results.count;
                end
                if ~isempty(p.Results.total)
                    obj.props_('total') = p.Results.total;
                end
                if ~isempty(p.Results.results)
                    obj.props_('results') = p.Results.results;
                end
            end
        end
        function result = get.count(obj)
            if ismethod(obj, 'get_count')
                result = obj.get_count();
            else
                if isKey(obj.props_, 'count')
                    result = obj.props_('count');
                else
                    result = [];
                end
            end
        end
        function obj = set.count(obj, value)
            obj.props_('count') = value;
        end
        function result = get.total(obj)
            if ismethod(obj, 'get_total')
                result = obj.get_total();
            else
                if isKey(obj.props_, 'total')
                    result = obj.props_('total');
                else
                    result = [];
                end
            end
        end
        function obj = set.total(obj, value)
            obj.props_('total') = value;
        end
        function result = get.results(obj)
            if ismethod(obj, 'get_results')
                result = obj.get_results();
            else
                if isKey(obj.props_, 'results')
                    result = obj.props_('results');
                else
                    result = [];
                end
            end
        end
        function obj = set.results(obj, value)
            obj.props_('results') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'count')
                result('count') = flywheel.ModelBase.serializeValue(obj.props_('count'), 'integer');
            end
            if isKey(obj.props_, 'total')
                result('total') = flywheel.ModelBase.serializeValue(obj.props_('total'), 'integer');
            end
            if isKey(obj.props_, 'results')
                result('results') = flywheel.ModelBase.cellmap(@toJson, obj.props_('results'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'count')
                result.count = obj.props_('count');
            else
                result.count = [];
            end
            if isKey(obj.props_, 'total')
                result.total = obj.props_('total');
            else
                result.total = [];
            end
            if isKey(obj.props_, 'results')
                result.results = flywheel.ModelBase.cellmap(@struct, obj.props_('results'));
            else
                result.results = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'count')
                    propList.count = obj.props_('count');
                else
                    propList.count = [];
                end
                if isKey(obj.props_, 'total')
                    propList.total = obj.props_('total');
                else
                    propList.total = [];
                end
                if isKey(obj.props_, 'results')
                    propList.results = obj.props_('results');
                else
                    propList.results = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Page;
            if isfield(json, 'count')
                obj.props_('count') = flywheel.ModelBase.deserializeValue(json.count, 'integer');
            end
            if isfield(json, 'total')
                obj.props_('total') = flywheel.ModelBase.deserializeValue(json.total, 'integer');
            end
            if isfield(json, 'results')
                obj.props_('results') = flywheel.ModelBase.cellmap(@(x) flywheel.model.Object.fromJson(x, context), json.results);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Page')
                    obj = flywheel.model.Page(obj);
                end
                if isKey(obj.props_, 'count')
                end
                if isKey(obj.props_, 'total')
                end
                if isKey(obj.props_, 'results')
                    obj.props_('results') = flywheel.ModelBase.cellmap(@flywheel.model.Object.ensureIsInstance, obj.props_('results'));
                end
            end
        end
    end
end
