% ParsedQueryResponse
%
% ParsedQueryResponse Properties:
%    valid   - Whether the structured query was valid or not
%    errors 
%
% ParsedQueryResponse Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ParsedQueryResponse < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'valid', 'errors' }, ...
            { 'valid', 'errors' });
    end
    properties(Dependent)
        valid
        errors
    end
    methods
        function obj = ParsedQueryResponse(varargin)
            obj@flywheel.ModelBase(flywheel.model.ParsedQueryResponse.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'valid', []);
                addParameter(p, 'errors', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.valid)
                    obj.props_('valid') = p.Results.valid;
                end
                if ~isempty(p.Results.errors)
                    obj.props_('errors') = p.Results.errors;
                end
            end
        end
        function result = get.valid(obj)
            if ismethod(obj, 'get_valid')
                result = obj.get_valid();
            else
                if isKey(obj.props_, 'valid')
                    result = obj.props_('valid');
                else
                    result = [];
                end
            end
        end
        function obj = set.valid(obj, value)
            obj.props_('valid') = value;
        end
        function result = get.errors(obj)
            if ismethod(obj, 'get_errors')
                result = obj.get_errors();
            else
                if isKey(obj.props_, 'errors')
                    result = obj.props_('errors');
                else
                    result = [];
                end
            end
        end
        function obj = set.errors(obj, value)
            obj.props_('errors') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'valid')
                result('valid') = flywheel.ModelBase.serializeValue(obj.props_('valid'), 'logical');
            end
            if isKey(obj.props_, 'errors')
                result('errors') = flywheel.ModelBase.cellmap(@toJson, obj.props_('errors'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'valid')
                result.valid = obj.props_('valid');
            else
                result.valid = [];
            end
            if isKey(obj.props_, 'errors')
                result.errors = flywheel.ModelBase.cellmap(@struct, obj.props_('errors'));
            else
                result.errors = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'valid')
                    propList.valid = obj.props_('valid');
                else
                    propList.valid = [];
                end
                if isKey(obj.props_, 'errors')
                    propList.errors = obj.props_('errors');
                else
                    propList.errors = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ParsedQueryResponse;
            if isfield(json, 'valid')
                obj.props_('valid') = flywheel.ModelBase.deserializeValue(json.valid, 'logical');
            end
            if isfield(json, 'errors')
                obj.props_('errors') = flywheel.ModelBase.cellmap(@(x) flywheel.model.SearchParseError.fromJson(x, context), json.errors);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ParsedQueryResponse')
                    obj = flywheel.model.ParsedQueryResponse(obj);
                end
                if isKey(obj.props_, 'valid')
                end
                if isKey(obj.props_, 'errors')
                    obj.props_('errors') = flywheel.ModelBase.cellmap(@flywheel.model.SearchParseError.ensureIsInstance, obj.props_('errors'));
                end
            end
        end
    end
end
