% PremadeJobsBatchProposalDetail
%
% PremadeJobsBatchProposalDetail Properties:
%    preconstructedJobs 
%
% PremadeJobsBatchProposalDetail Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef PremadeJobsBatchProposalDetail < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'preconstructedJobs' }, ...
            { 'preconstructed_jobs' });
    end
    properties(Dependent)
        preconstructedJobs
    end
    methods
        function obj = PremadeJobsBatchProposalDetail(varargin)
            obj@flywheel.ModelBase(flywheel.model.PremadeJobsBatchProposalDetail.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'preconstructedJobs', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.preconstructedJobs)
                    obj.props_('preconstructed_jobs') = p.Results.preconstructedJobs;
                end
            end
        end
        function result = get.preconstructedJobs(obj)
            if ismethod(obj, 'get_preconstructedJobs')
                result = obj.get_preconstructedJobs();
            else
                if isKey(obj.props_, 'preconstructed_jobs')
                    result = obj.props_('preconstructed_jobs');
                else
                    result = [];
                end
            end
        end
        function obj = set.preconstructedJobs(obj, value)
            obj.props_('preconstructed_jobs') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'preconstructed_jobs')
                result('preconstructed_jobs') = flywheel.ModelBase.cellmap(@toJson, obj.props_('preconstructed_jobs'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'preconstructed_jobs')
                result.preconstructedJobs = flywheel.ModelBase.cellmap(@struct, obj.props_('preconstructed_jobs'));
            else
                result.preconstructedJobs = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'preconstructed_jobs')
                    propList.preconstructedJobs = obj.props_('preconstructed_jobs');
                else
                    propList.preconstructedJobs = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.PremadeJobsBatchProposalDetail;
            if isfield(json, 'preconstructed_jobs')
                obj.props_('preconstructed_jobs') = flywheel.ModelBase.cellmap(@(x) flywheel.model.InputJob.fromJson(x, context), json.preconstructed_jobs);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.PremadeJobsBatchProposalDetail')
                    obj = flywheel.model.PremadeJobsBatchProposalDetail(obj);
                end
                if isKey(obj.props_, 'preconstructed_jobs')
                    obj.props_('preconstructed_jobs') = flywheel.ModelBase.cellmap(@flywheel.model.InputJob.ensureIsInstance, obj.props_('preconstructed_jobs'));
                end
            end
        end
    end
end
