% ProjectCopyFilter
%
% ProjectCopyFilter Properties:
%    excludeAnalysis        
%    excludeNotes           
%    excludeTags            
%    includeRules           
%    excludeRules           
%    excludeEmptyContainers 
%
% ProjectCopyFilter Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectCopyFilter < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'excludeAnalysis', 'excludeNotes', 'excludeTags', 'includeRules', 'excludeRules', 'excludeEmptyContainers' }, ...
            { 'exclude_analysis', 'exclude_notes', 'exclude_tags', 'include_rules', 'exclude_rules', 'exclude_empty_containers' });
    end
    properties(Dependent)
        excludeAnalysis
        excludeNotes
        excludeTags
        includeRules
        excludeRules
        excludeEmptyContainers
    end
    methods
        function obj = ProjectCopyFilter(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectCopyFilter.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'excludeAnalysis', false);
                addParameter(p, 'excludeNotes', false);
                addParameter(p, 'excludeTags', false);
                addParameter(p, 'includeRules', []);
                addParameter(p, 'excludeRules', []);
                addParameter(p, 'excludeEmptyContainers', true);

                parse(p, varargin{:});

                if ~isempty(p.Results.excludeAnalysis)
                    obj.props_('exclude_analysis') = p.Results.excludeAnalysis;
                end
                if ~isempty(p.Results.excludeNotes)
                    obj.props_('exclude_notes') = p.Results.excludeNotes;
                end
                if ~isempty(p.Results.excludeTags)
                    obj.props_('exclude_tags') = p.Results.excludeTags;
                end
                if ~isempty(p.Results.includeRules)
                    obj.props_('include_rules') = p.Results.includeRules;
                end
                if ~isempty(p.Results.excludeRules)
                    obj.props_('exclude_rules') = p.Results.excludeRules;
                end
                if ~isempty(p.Results.excludeEmptyContainers)
                    obj.props_('exclude_empty_containers') = p.Results.excludeEmptyContainers;
                end
            end
        end
        function result = get.excludeAnalysis(obj)
            if ismethod(obj, 'get_excludeAnalysis')
                result = obj.get_excludeAnalysis();
            else
                if isKey(obj.props_, 'exclude_analysis')
                    result = obj.props_('exclude_analysis');
                else
                    result = [];
                end
            end
        end
        function obj = set.excludeAnalysis(obj, value)
            obj.props_('exclude_analysis') = value;
        end
        function result = get.excludeNotes(obj)
            if ismethod(obj, 'get_excludeNotes')
                result = obj.get_excludeNotes();
            else
                if isKey(obj.props_, 'exclude_notes')
                    result = obj.props_('exclude_notes');
                else
                    result = [];
                end
            end
        end
        function obj = set.excludeNotes(obj, value)
            obj.props_('exclude_notes') = value;
        end
        function result = get.excludeTags(obj)
            if ismethod(obj, 'get_excludeTags')
                result = obj.get_excludeTags();
            else
                if isKey(obj.props_, 'exclude_tags')
                    result = obj.props_('exclude_tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.excludeTags(obj, value)
            obj.props_('exclude_tags') = value;
        end
        function result = get.includeRules(obj)
            if ismethod(obj, 'get_includeRules')
                result = obj.get_includeRules();
            else
                if isKey(obj.props_, 'include_rules')
                    result = obj.props_('include_rules');
                else
                    result = [];
                end
            end
        end
        function obj = set.includeRules(obj, value)
            obj.props_('include_rules') = value;
        end
        function result = get.excludeRules(obj)
            if ismethod(obj, 'get_excludeRules')
                result = obj.get_excludeRules();
            else
                if isKey(obj.props_, 'exclude_rules')
                    result = obj.props_('exclude_rules');
                else
                    result = [];
                end
            end
        end
        function obj = set.excludeRules(obj, value)
            obj.props_('exclude_rules') = value;
        end
        function result = get.excludeEmptyContainers(obj)
            if ismethod(obj, 'get_excludeEmptyContainers')
                result = obj.get_excludeEmptyContainers();
            else
                if isKey(obj.props_, 'exclude_empty_containers')
                    result = obj.props_('exclude_empty_containers');
                else
                    result = [];
                end
            end
        end
        function obj = set.excludeEmptyContainers(obj, value)
            obj.props_('exclude_empty_containers') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'exclude_analysis')
                result('exclude_analysis') = flywheel.ModelBase.serializeValue(obj.props_('exclude_analysis'), 'logical');
            end
            if isKey(obj.props_, 'exclude_notes')
                result('exclude_notes') = flywheel.ModelBase.serializeValue(obj.props_('exclude_notes'), 'logical');
            end
            if isKey(obj.props_, 'exclude_tags')
                result('exclude_tags') = flywheel.ModelBase.serializeValue(obj.props_('exclude_tags'), 'logical');
            end
            if isKey(obj.props_, 'include_rules')
                result('include_rules') = flywheel.ModelBase.serializeValue(obj.props_('include_rules'), 'vector[char]');
            end
            if isKey(obj.props_, 'exclude_rules')
                result('exclude_rules') = flywheel.ModelBase.serializeValue(obj.props_('exclude_rules'), 'vector[char]');
            end
            if isKey(obj.props_, 'exclude_empty_containers')
                result('exclude_empty_containers') = flywheel.ModelBase.serializeValue(obj.props_('exclude_empty_containers'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'exclude_analysis')
                result.excludeAnalysis = obj.props_('exclude_analysis');
            else
                result.excludeAnalysis = [];
            end
            if isKey(obj.props_, 'exclude_notes')
                result.excludeNotes = obj.props_('exclude_notes');
            else
                result.excludeNotes = [];
            end
            if isKey(obj.props_, 'exclude_tags')
                result.excludeTags = obj.props_('exclude_tags');
            else
                result.excludeTags = [];
            end
            if isKey(obj.props_, 'include_rules')
                result.includeRules = obj.props_('include_rules');
            else
                result.includeRules = [];
            end
            if isKey(obj.props_, 'exclude_rules')
                result.excludeRules = obj.props_('exclude_rules');
            else
                result.excludeRules = [];
            end
            if isKey(obj.props_, 'exclude_empty_containers')
                result.excludeEmptyContainers = obj.props_('exclude_empty_containers');
            else
                result.excludeEmptyContainers = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'exclude_analysis')
                    propList.excludeAnalysis = obj.props_('exclude_analysis');
                else
                    propList.excludeAnalysis = [];
                end
                if isKey(obj.props_, 'exclude_notes')
                    propList.excludeNotes = obj.props_('exclude_notes');
                else
                    propList.excludeNotes = [];
                end
                if isKey(obj.props_, 'exclude_tags')
                    propList.excludeTags = obj.props_('exclude_tags');
                else
                    propList.excludeTags = [];
                end
                if isKey(obj.props_, 'include_rules')
                    propList.includeRules = obj.props_('include_rules');
                else
                    propList.includeRules = [];
                end
                if isKey(obj.props_, 'exclude_rules')
                    propList.excludeRules = obj.props_('exclude_rules');
                else
                    propList.excludeRules = [];
                end
                if isKey(obj.props_, 'exclude_empty_containers')
                    propList.excludeEmptyContainers = obj.props_('exclude_empty_containers');
                else
                    propList.excludeEmptyContainers = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectCopyFilter;
            if isfield(json, 'exclude_analysis')
                obj.props_('exclude_analysis') = flywheel.ModelBase.deserializeValue(json.exclude_analysis, 'logical');
            end
            if isfield(json, 'exclude_notes')
                obj.props_('exclude_notes') = flywheel.ModelBase.deserializeValue(json.exclude_notes, 'logical');
            end
            if isfield(json, 'exclude_tags')
                obj.props_('exclude_tags') = flywheel.ModelBase.deserializeValue(json.exclude_tags, 'logical');
            end
            if isfield(json, 'include_rules')
                obj.props_('include_rules') = flywheel.ModelBase.deserializeValue(json.include_rules, 'vector[char]');
            end
            if isfield(json, 'exclude_rules')
                obj.props_('exclude_rules') = flywheel.ModelBase.deserializeValue(json.exclude_rules, 'vector[char]');
            end
            if isfield(json, 'exclude_empty_containers')
                obj.props_('exclude_empty_containers') = flywheel.ModelBase.deserializeValue(json.exclude_empty_containers, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectCopyFilter')
                    obj = flywheel.model.ProjectCopyFilter(obj);
                end
                if isKey(obj.props_, 'exclude_analysis')
                end
                if isKey(obj.props_, 'exclude_notes')
                end
                if isKey(obj.props_, 'exclude_tags')
                end
                if isKey(obj.props_, 'include_rules')
                end
                if isKey(obj.props_, 'exclude_rules')
                end
                if isKey(obj.props_, 'exclude_empty_containers')
                end
            end
        end
    end
end
