% ProjectCopyInput
%
% ProjectCopyInput Properties:
%    groupId      
%    projectLabel 
%    filter       
%
% ProjectCopyInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectCopyInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'groupId', 'projectLabel', 'filter' }, ...
            { 'group_id', 'project_label', 'filter' });
    end
    properties(Dependent)
        groupId
        projectLabel
        filter
    end
    methods
        function obj = ProjectCopyInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectCopyInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'groupId', []);
                addParameter(p, 'projectLabel', []);
                addParameter(p, 'filter', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.groupId)
                    obj.props_('group_id') = p.Results.groupId;
                end
                if ~isempty(p.Results.projectLabel)
                    obj.props_('project_label') = p.Results.projectLabel;
                end
                if ~isempty(p.Results.filter)
                    obj.props_('filter') = p.Results.filter;
                end
            end
        end
        function result = get.groupId(obj)
            if ismethod(obj, 'get_groupId')
                result = obj.get_groupId();
            else
                if isKey(obj.props_, 'group_id')
                    result = obj.props_('group_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupId(obj, value)
            obj.props_('group_id') = value;
        end
        function result = get.projectLabel(obj)
            if ismethod(obj, 'get_projectLabel')
                result = obj.get_projectLabel();
            else
                if isKey(obj.props_, 'project_label')
                    result = obj.props_('project_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectLabel(obj, value)
            obj.props_('project_label') = value;
        end
        function result = get.filter(obj)
            if ismethod(obj, 'get_filter')
                result = obj.get_filter();
            else
                if isKey(obj.props_, 'filter')
                    result = obj.props_('filter');
                else
                    result = [];
                end
            end
        end
        function obj = set.filter(obj, value)
            obj.props_('filter') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'group_id')
                result('group_id') = flywheel.ModelBase.serializeValue(obj.props_('group_id'), 'char');
            end
            if isKey(obj.props_, 'project_label')
                result('project_label') = flywheel.ModelBase.serializeValue(obj.props_('project_label'), 'char');
            end
            if isKey(obj.props_, 'filter')
                result('filter') = obj.props_('filter').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'group_id')
                result.groupId = obj.props_('group_id');
            else
                result.groupId = [];
            end
            if isKey(obj.props_, 'project_label')
                result.projectLabel = obj.props_('project_label');
            else
                result.projectLabel = [];
            end
            if isKey(obj.props_, 'filter')
                result.filter = struct(obj.props_('filter'));
            else
                result.filter = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'group_id')
                    propList.groupId = obj.props_('group_id');
                else
                    propList.groupId = [];
                end
                if isKey(obj.props_, 'project_label')
                    propList.projectLabel = obj.props_('project_label');
                else
                    propList.projectLabel = [];
                end
                if isKey(obj.props_, 'filter')
                    propList.filter = obj.props_('filter');
                else
                    propList.filter = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectCopyInput;
            if isfield(json, 'group_id')
                obj.props_('group_id') = flywheel.ModelBase.deserializeValue(json.group_id, 'char');
            end
            if isfield(json, 'project_label')
                obj.props_('project_label') = flywheel.ModelBase.deserializeValue(json.project_label, 'char');
            end
            if isfield(json, 'filter')
                obj.props_('filter') = flywheel.model.ProjectCopyFilter.fromJson(json.filter, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectCopyInput')
                    obj = flywheel.model.ProjectCopyInput(obj);
                end
                if isKey(obj.props_, 'group_id')
                end
                if isKey(obj.props_, 'project_label')
                end
                if isKey(obj.props_, 'filter')
                    obj.props_('filter') =  flywheel.model.ProjectCopyFilter.ensureIsInstance(obj.props_('filter'));
                end
            end
        end
    end
end
