% ProjectCopyOutput
%
% ProjectCopyOutput Properties:
%    taskId     
%    snapshotId 
%    projectId  
%
% ProjectCopyOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectCopyOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'taskId', 'snapshotId', 'projectId' }, ...
            { 'task_id', 'snapshot_id', 'project_id' });
    end
    properties(Dependent)
        taskId
        snapshotId
        projectId
    end
    methods
        function obj = ProjectCopyOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectCopyOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'taskId', []);
                addParameter(p, 'snapshotId', []);
                addParameter(p, 'projectId', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.taskId)
                    obj.props_('task_id') = p.Results.taskId;
                end
                if ~isempty(p.Results.snapshotId)
                    obj.props_('snapshot_id') = p.Results.snapshotId;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
            end
        end
        function result = get.taskId(obj)
            if ismethod(obj, 'get_taskId')
                result = obj.get_taskId();
            else
                if isKey(obj.props_, 'task_id')
                    result = obj.props_('task_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.taskId(obj, value)
            obj.props_('task_id') = value;
        end
        function result = get.snapshotId(obj)
            if ismethod(obj, 'get_snapshotId')
                result = obj.get_snapshotId();
            else
                if isKey(obj.props_, 'snapshot_id')
                    result = obj.props_('snapshot_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.snapshotId(obj, value)
            obj.props_('snapshot_id') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'task_id')
                result('task_id') = flywheel.ModelBase.serializeValue(obj.props_('task_id'), 'char');
            end
            if isKey(obj.props_, 'snapshot_id')
                result('snapshot_id') = flywheel.ModelBase.serializeValue(obj.props_('snapshot_id'), 'char');
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'task_id')
                result.taskId = obj.props_('task_id');
            else
                result.taskId = [];
            end
            if isKey(obj.props_, 'snapshot_id')
                result.snapshotId = obj.props_('snapshot_id');
            else
                result.snapshotId = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'task_id')
                    propList.taskId = obj.props_('task_id');
                else
                    propList.taskId = [];
                end
                if isKey(obj.props_, 'snapshot_id')
                    propList.snapshotId = obj.props_('snapshot_id');
                else
                    propList.snapshotId = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectCopyOutput;
            if isfield(json, 'task_id')
                obj.props_('task_id') = flywheel.ModelBase.deserializeValue(json.task_id, 'char');
            end
            if isfield(json, 'snapshot_id')
                obj.props_('snapshot_id') = flywheel.ModelBase.deserializeValue(json.snapshot_id, 'char');
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectCopyOutput')
                    obj = flywheel.model.ProjectCopyOutput(obj);
                end
                if isKey(obj.props_, 'task_id')
                end
                if isKey(obj.props_, 'snapshot_id')
                end
                if isKey(obj.props_, 'project_id')
                end
            end
        end
    end
end
