% ProjectCounters
%
% ProjectCounters Properties:
%    subjects          
%    sessions          
%    acquisitions      
%    files             
%    jobs              
%    analyses          
%    acquisitionFiles  
%    compliantSessions 
%
% ProjectCounters Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectCounters < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'subjects', 'sessions', 'acquisitions', 'files', 'jobs', 'analyses', 'acquisitionFiles', 'compliantSessions' }, ...
            { 'subjects', 'sessions', 'acquisitions', 'files', 'jobs', 'analyses', 'acquisition_files', 'compliant_sessions' });
    end
    properties(Dependent)
        subjects
        sessions
        acquisitions
        files
        jobs
        analyses
        acquisitionFiles
        compliantSessions
    end
    methods
        function obj = ProjectCounters(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectCounters.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'subjects', []);
                addParameter(p, 'sessions', []);
                addParameter(p, 'acquisitions', []);
                addParameter(p, 'files', []);
                addParameter(p, 'jobs', []);
                addParameter(p, 'analyses', []);
                addParameter(p, 'acquisitionFiles', []);
                addParameter(p, 'compliantSessions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.subjects)
                    obj.props_('subjects') = p.Results.subjects;
                end
                if ~isempty(p.Results.sessions)
                    obj.props_('sessions') = p.Results.sessions;
                end
                if ~isempty(p.Results.acquisitions)
                    obj.props_('acquisitions') = p.Results.acquisitions;
                end
                if ~isempty(p.Results.files)
                    obj.props_('files') = p.Results.files;
                end
                if ~isempty(p.Results.jobs)
                    obj.props_('jobs') = p.Results.jobs;
                end
                if ~isempty(p.Results.analyses)
                    obj.props_('analyses') = p.Results.analyses;
                end
                if ~isempty(p.Results.acquisitionFiles)
                    obj.props_('acquisition_files') = p.Results.acquisitionFiles;
                end
                if ~isempty(p.Results.compliantSessions)
                    obj.props_('compliant_sessions') = p.Results.compliantSessions;
                end
            end
        end
        function result = get.subjects(obj)
            if ismethod(obj, 'get_subjects')
                result = obj.get_subjects();
            else
                if isKey(obj.props_, 'subjects')
                    result = obj.props_('subjects');
                else
                    result = [];
                end
            end
        end
        function obj = set.subjects(obj, value)
            obj.props_('subjects') = value;
        end
        function result = get.sessions(obj)
            if ismethod(obj, 'get_sessions')
                result = obj.get_sessions();
            else
                if isKey(obj.props_, 'sessions')
                    result = obj.props_('sessions');
                else
                    result = [];
                end
            end
        end
        function obj = set.sessions(obj, value)
            obj.props_('sessions') = value;
        end
        function result = get.acquisitions(obj)
            if ismethod(obj, 'get_acquisitions')
                result = obj.get_acquisitions();
            else
                if isKey(obj.props_, 'acquisitions')
                    result = obj.props_('acquisitions');
                else
                    result = [];
                end
            end
        end
        function obj = set.acquisitions(obj, value)
            obj.props_('acquisitions') = value;
        end
        function result = get.files(obj)
            if ismethod(obj, 'get_files')
                result = obj.get_files();
            else
                if isKey(obj.props_, 'files')
                    result = obj.props_('files');
                else
                    result = [];
                end
            end
        end
        function obj = set.files(obj, value)
            obj.props_('files') = value;
        end
        function result = get.jobs(obj)
            if ismethod(obj, 'get_jobs')
                result = obj.get_jobs();
            else
                if isKey(obj.props_, 'jobs')
                    result = obj.props_('jobs');
                else
                    result = [];
                end
            end
        end
        function obj = set.jobs(obj, value)
            obj.props_('jobs') = value;
        end
        function result = get.analyses(obj)
            if ismethod(obj, 'get_analyses')
                result = obj.get_analyses();
            else
                if isKey(obj.props_, 'analyses')
                    result = obj.props_('analyses');
                else
                    result = [];
                end
            end
        end
        function obj = set.analyses(obj, value)
            obj.props_('analyses') = value;
        end
        function result = get.acquisitionFiles(obj)
            if ismethod(obj, 'get_acquisitionFiles')
                result = obj.get_acquisitionFiles();
            else
                if isKey(obj.props_, 'acquisition_files')
                    result = obj.props_('acquisition_files');
                else
                    result = [];
                end
            end
        end
        function obj = set.acquisitionFiles(obj, value)
            obj.props_('acquisition_files') = value;
        end
        function result = get.compliantSessions(obj)
            if ismethod(obj, 'get_compliantSessions')
                result = obj.get_compliantSessions();
            else
                if isKey(obj.props_, 'compliant_sessions')
                    result = obj.props_('compliant_sessions');
                else
                    result = [];
                end
            end
        end
        function obj = set.compliantSessions(obj, value)
            obj.props_('compliant_sessions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'subjects')
                result('subjects') = flywheel.ModelBase.serializeValue(obj.props_('subjects'), 'integer');
            end
            if isKey(obj.props_, 'sessions')
                result('sessions') = flywheel.ModelBase.serializeValue(obj.props_('sessions'), 'integer');
            end
            if isKey(obj.props_, 'acquisitions')
                result('acquisitions') = flywheel.ModelBase.serializeValue(obj.props_('acquisitions'), 'integer');
            end
            if isKey(obj.props_, 'files')
                result('files') = flywheel.ModelBase.serializeValue(obj.props_('files'), 'integer');
            end
            if isKey(obj.props_, 'jobs')
                result('jobs') = flywheel.ModelBase.serializeValue(obj.props_('jobs'), 'integer');
            end
            if isKey(obj.props_, 'analyses')
                result('analyses') = flywheel.ModelBase.serializeValue(obj.props_('analyses'), 'integer');
            end
            if isKey(obj.props_, 'acquisition_files')
                result('acquisition_files') = flywheel.ModelBase.serializeValue(obj.props_('acquisition_files'), 'integer');
            end
            if isKey(obj.props_, 'compliant_sessions')
                result('compliant_sessions') = flywheel.ModelBase.serializeValue(obj.props_('compliant_sessions'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'subjects')
                result.subjects = obj.props_('subjects');
            else
                result.subjects = [];
            end
            if isKey(obj.props_, 'sessions')
                result.sessions = obj.props_('sessions');
            else
                result.sessions = [];
            end
            if isKey(obj.props_, 'acquisitions')
                result.acquisitions = obj.props_('acquisitions');
            else
                result.acquisitions = [];
            end
            if isKey(obj.props_, 'files')
                result.files = obj.props_('files');
            else
                result.files = [];
            end
            if isKey(obj.props_, 'jobs')
                result.jobs = obj.props_('jobs');
            else
                result.jobs = [];
            end
            if isKey(obj.props_, 'analyses')
                result.analyses = obj.props_('analyses');
            else
                result.analyses = [];
            end
            if isKey(obj.props_, 'acquisition_files')
                result.acquisitionFiles = obj.props_('acquisition_files');
            else
                result.acquisitionFiles = [];
            end
            if isKey(obj.props_, 'compliant_sessions')
                result.compliantSessions = obj.props_('compliant_sessions');
            else
                result.compliantSessions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'subjects')
                    propList.subjects = obj.props_('subjects');
                else
                    propList.subjects = [];
                end
                if isKey(obj.props_, 'sessions')
                    propList.sessions = obj.props_('sessions');
                else
                    propList.sessions = [];
                end
                if isKey(obj.props_, 'acquisitions')
                    propList.acquisitions = obj.props_('acquisitions');
                else
                    propList.acquisitions = [];
                end
                if isKey(obj.props_, 'files')
                    propList.files = obj.props_('files');
                else
                    propList.files = [];
                end
                if isKey(obj.props_, 'jobs')
                    propList.jobs = obj.props_('jobs');
                else
                    propList.jobs = [];
                end
                if isKey(obj.props_, 'analyses')
                    propList.analyses = obj.props_('analyses');
                else
                    propList.analyses = [];
                end
                if isKey(obj.props_, 'acquisition_files')
                    propList.acquisitionFiles = obj.props_('acquisition_files');
                else
                    propList.acquisitionFiles = [];
                end
                if isKey(obj.props_, 'compliant_sessions')
                    propList.compliantSessions = obj.props_('compliant_sessions');
                else
                    propList.compliantSessions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectCounters;
            if isfield(json, 'subjects')
                obj.props_('subjects') = flywheel.ModelBase.deserializeValue(json.subjects, 'integer');
            end
            if isfield(json, 'sessions')
                obj.props_('sessions') = flywheel.ModelBase.deserializeValue(json.sessions, 'integer');
            end
            if isfield(json, 'acquisitions')
                obj.props_('acquisitions') = flywheel.ModelBase.deserializeValue(json.acquisitions, 'integer');
            end
            if isfield(json, 'files')
                obj.props_('files') = flywheel.ModelBase.deserializeValue(json.files, 'integer');
            end
            if isfield(json, 'jobs')
                obj.props_('jobs') = flywheel.ModelBase.deserializeValue(json.jobs, 'integer');
            end
            if isfield(json, 'analyses')
                obj.props_('analyses') = flywheel.ModelBase.deserializeValue(json.analyses, 'integer');
            end
            if isfield(json, 'acquisition_files')
                obj.props_('acquisition_files') = flywheel.ModelBase.deserializeValue(json.acquisition_files, 'integer');
            end
            if isfield(json, 'compliant_sessions')
                obj.props_('compliant_sessions') = flywheel.ModelBase.deserializeValue(json.compliant_sessions, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectCounters')
                    obj = flywheel.model.ProjectCounters(obj);
                end
                if isKey(obj.props_, 'subjects')
                end
                if isKey(obj.props_, 'sessions')
                end
                if isKey(obj.props_, 'acquisitions')
                end
                if isKey(obj.props_, 'files')
                end
                if isKey(obj.props_, 'jobs')
                end
                if isKey(obj.props_, 'analyses')
                end
                if isKey(obj.props_, 'acquisition_files')
                end
                if isKey(obj.props_, 'compliant_sessions')
                end
            end
        end
    end
end
