% ProjectHierarchyInput
%
% ProjectHierarchyInput Properties:
%    origin      
%    source      
%    subject     
%    session     
%    acquisition 
%
% ProjectHierarchyInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectHierarchyInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'origin', 'source', 'subject', 'session', 'acquisition' }, ...
            { 'origin', 'source', 'subject', 'session', 'acquisition' });
    end
    properties(Dependent)
        origin
        source
        subject
        session
        acquisition
    end
    methods
        function obj = ProjectHierarchyInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectHierarchyInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'origin', []);
                addParameter(p, 'source', []);
                addParameter(p, 'subject', []);
                addParameter(p, 'session', []);
                addParameter(p, 'acquisition', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.source)
                    obj.props_('source') = p.Results.source;
                end
                if ~isempty(p.Results.subject)
                    obj.props_('subject') = p.Results.subject;
                end
                if ~isempty(p.Results.session)
                    obj.props_('session') = p.Results.session;
                end
                if ~isempty(p.Results.acquisition)
                    obj.props_('acquisition') = p.Results.acquisition;
                end
            end
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.source(obj)
            if ismethod(obj, 'get_source')
                result = obj.get_source();
            else
                if isKey(obj.props_, 'source')
                    result = obj.props_('source');
                else
                    result = [];
                end
            end
        end
        function obj = set.source(obj, value)
            obj.props_('source') = value;
        end
        function result = get.subject(obj)
            if ismethod(obj, 'get_subject')
                result = obj.get_subject();
            else
                if isKey(obj.props_, 'subject')
                    result = obj.props_('subject');
                else
                    result = [];
                end
            end
        end
        function obj = set.subject(obj, value)
            obj.props_('subject') = value;
        end
        function result = get.session(obj)
            if ismethod(obj, 'get_session')
                result = obj.get_session();
            else
                if isKey(obj.props_, 'session')
                    result = obj.props_('session');
                else
                    result = [];
                end
            end
        end
        function obj = set.session(obj, value)
            obj.props_('session') = value;
        end
        function result = get.acquisition(obj)
            if ismethod(obj, 'get_acquisition')
                result = obj.get_acquisition();
            else
                if isKey(obj.props_, 'acquisition')
                    result = obj.props_('acquisition');
                else
                    result = [];
                end
            end
        end
        function obj = set.acquisition(obj, value)
            obj.props_('acquisition') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'source')
                result('source') = obj.props_('source').toJson();
            end
            if isKey(obj.props_, 'subject')
                result('subject') = obj.props_('subject').toJson();
            end
            if isKey(obj.props_, 'session')
                result('session') = obj.props_('session').toJson();
            end
            if isKey(obj.props_, 'acquisition')
                result('acquisition') = obj.props_('acquisition').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'source')
                result.source = struct(obj.props_('source'));
            else
                result.source = [];
            end
            if isKey(obj.props_, 'subject')
                result.subject = struct(obj.props_('subject'));
            else
                result.subject = [];
            end
            if isKey(obj.props_, 'session')
                result.session = struct(obj.props_('session'));
            else
                result.session = [];
            end
            if isKey(obj.props_, 'acquisition')
                result.acquisition = struct(obj.props_('acquisition'));
            else
                result.acquisition = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'source')
                    propList.source = obj.props_('source');
                else
                    propList.source = [];
                end
                if isKey(obj.props_, 'subject')
                    propList.subject = obj.props_('subject');
                else
                    propList.subject = [];
                end
                if isKey(obj.props_, 'session')
                    propList.session = obj.props_('session');
                else
                    propList.session = [];
                end
                if isKey(obj.props_, 'acquisition')
                    propList.acquisition = obj.props_('acquisition');
                else
                    propList.acquisition = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectHierarchyInput;
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'source')
                obj.props_('source') = flywheel.model.CoreModelsCommonSource.fromJson(json.source, context);
            end
            if isfield(json, 'subject')
                obj.props_('subject') = flywheel.model.SubjectUpsertInput.fromJson(json.subject, context);
            end
            if isfield(json, 'session')
                obj.props_('session') = flywheel.model.SessionUpsertInput.fromJson(json.session, context);
            end
            if isfield(json, 'acquisition')
                obj.props_('acquisition') = flywheel.model.AcquisitionUpsertInput.fromJson(json.acquisition, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectHierarchyInput')
                    obj = flywheel.model.ProjectHierarchyInput(obj);
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'source')
                    obj.props_('source') =  flywheel.model.CoreModelsCommonSource.ensureIsInstance(obj.props_('source'));
                end
                if isKey(obj.props_, 'subject')
                    obj.props_('subject') =  flywheel.model.SubjectUpsertInput.ensureIsInstance(obj.props_('subject'));
                end
                if isKey(obj.props_, 'session')
                    obj.props_('session') =  flywheel.model.SessionUpsertInput.ensureIsInstance(obj.props_('session'));
                end
                if isKey(obj.props_, 'acquisition')
                    obj.props_('acquisition') =  flywheel.model.AcquisitionUpsertInput.ensureIsInstance(obj.props_('acquisition'));
                end
            end
        end
    end
end
