% ProjectHierarchyOutput
%
% ProjectHierarchyOutput Properties:
%    subject     
%    session     
%    acquisition 
%
% ProjectHierarchyOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectHierarchyOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'subject', 'session', 'acquisition' }, ...
            { 'subject', 'session', 'acquisition' });
    end
    properties(Dependent)
        subject
        session
        acquisition
    end
    methods
        function obj = ProjectHierarchyOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectHierarchyOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'subject', []);
                addParameter(p, 'session', []);
                addParameter(p, 'acquisition', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.subject)
                    obj.props_('subject') = p.Results.subject;
                end
                if ~isempty(p.Results.session)
                    obj.props_('session') = p.Results.session;
                end
                if ~isempty(p.Results.acquisition)
                    obj.props_('acquisition') = p.Results.acquisition;
                end
            end
        end
        function result = get.subject(obj)
            if ismethod(obj, 'get_subject')
                result = obj.get_subject();
            else
                if isKey(obj.props_, 'subject')
                    result = obj.props_('subject');
                else
                    result = [];
                end
            end
        end
        function obj = set.subject(obj, value)
            obj.props_('subject') = value;
        end
        function result = get.session(obj)
            if ismethod(obj, 'get_session')
                result = obj.get_session();
            else
                if isKey(obj.props_, 'session')
                    result = obj.props_('session');
                else
                    result = [];
                end
            end
        end
        function obj = set.session(obj, value)
            obj.props_('session') = value;
        end
        function result = get.acquisition(obj)
            if ismethod(obj, 'get_acquisition')
                result = obj.get_acquisition();
            else
                if isKey(obj.props_, 'acquisition')
                    result = obj.props_('acquisition');
                else
                    result = [];
                end
            end
        end
        function obj = set.acquisition(obj, value)
            obj.props_('acquisition') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'subject')
                result('subject') = obj.props_('subject').toJson();
            end
            if isKey(obj.props_, 'session')
                result('session') = obj.props_('session').toJson();
            end
            if isKey(obj.props_, 'acquisition')
                result('acquisition') = obj.props_('acquisition').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'subject')
                result.subject = struct(obj.props_('subject'));
            else
                result.subject = [];
            end
            if isKey(obj.props_, 'session')
                result.session = struct(obj.props_('session'));
            else
                result.session = [];
            end
            if isKey(obj.props_, 'acquisition')
                result.acquisition = struct(obj.props_('acquisition'));
            else
                result.acquisition = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'subject')
                    propList.subject = obj.props_('subject');
                else
                    propList.subject = [];
                end
                if isKey(obj.props_, 'session')
                    propList.session = obj.props_('session');
                else
                    propList.session = [];
                end
                if isKey(obj.props_, 'acquisition')
                    propList.acquisition = obj.props_('acquisition');
                else
                    propList.acquisition = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectHierarchyOutput;
            if isfield(json, 'subject')
                obj.props_('subject') = flywheel.model.SubjectUpsertOutput.fromJson(json.subject, context);
            end
            if isfield(json, 'session')
                obj.props_('session') = flywheel.model.SessionUpsertOutput.fromJson(json.session, context);
            end
            if isfield(json, 'acquisition')
                obj.props_('acquisition') = flywheel.model.AcquisitionUpsertOutput.fromJson(json.acquisition, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectHierarchyOutput')
                    obj = flywheel.model.ProjectHierarchyOutput(obj);
                end
                if isKey(obj.props_, 'subject')
                    obj.props_('subject') =  flywheel.model.SubjectUpsertOutput.ensureIsInstance(obj.props_('subject'));
                end
                if isKey(obj.props_, 'session')
                    obj.props_('session') =  flywheel.model.SessionUpsertOutput.ensureIsInstance(obj.props_('session'));
                end
                if isKey(obj.props_, 'acquisition')
                    obj.props_('acquisition') =  flywheel.model.AcquisitionUpsertOutput.ensureIsInstance(obj.props_('acquisition'));
                end
            end
        end
    end
end
