% ProjectInput
%
% ProjectInput Properties:
%    label       
%    description 
%    group       
%    editions    
%    providers   
%    ldapSync    
%    permissions 
%    copyable    
%    info        
%
% ProjectInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'description', 'group', 'editions', 'providers', 'ldapSync', 'permissions', 'copyable', 'info' }, ...
            { 'label', 'description', 'group', 'editions', 'providers', 'ldap_sync', 'permissions', 'copyable', 'info' });
    end
    properties(Dependent)
        label
        description
        group
        editions
        providers
        ldapSync
        permissions
        copyable
        info
    end
    methods
        function obj = ProjectInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'description', &#x27;&#x27;);
                addParameter(p, 'group', []);
                addParameter(p, 'editions', []);
                addParameter(p, 'providers', []);
                addParameter(p, 'ldapSync', []);
                addParameter(p, 'permissions', []);
                addParameter(p, 'copyable', []);
                addParameter(p, 'info', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.editions)
                    obj.props_('editions') = p.Results.editions;
                end
                if ~isempty(p.Results.providers)
                    obj.props_('providers') = p.Results.providers;
                end
                if ~isempty(p.Results.ldapSync)
                    obj.props_('ldap_sync') = p.Results.ldapSync;
                end
                if ~isempty(p.Results.permissions)
                    obj.props_('permissions') = p.Results.permissions;
                end
                if ~isempty(p.Results.copyable)
                    obj.props_('copyable') = p.Results.copyable;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.editions(obj)
            if ismethod(obj, 'get_editions')
                result = obj.get_editions();
            else
                if isKey(obj.props_, 'editions')
                    result = obj.props_('editions');
                else
                    result = [];
                end
            end
        end
        function obj = set.editions(obj, value)
            obj.props_('editions') = value;
        end
        function result = get.providers(obj)
            if ismethod(obj, 'get_providers')
                result = obj.get_providers();
            else
                if isKey(obj.props_, 'providers')
                    result = obj.props_('providers');
                else
                    result = [];
                end
            end
        end
        function obj = set.providers(obj, value)
            obj.props_('providers') = value;
        end
        function result = get.ldapSync(obj)
            if ismethod(obj, 'get_ldapSync')
                result = obj.get_ldapSync();
            else
                if isKey(obj.props_, 'ldap_sync')
                    result = obj.props_('ldap_sync');
                else
                    result = [];
                end
            end
        end
        function obj = set.ldapSync(obj, value)
            obj.props_('ldap_sync') = value;
        end
        function result = get.permissions(obj)
            if ismethod(obj, 'get_permissions')
                result = obj.get_permissions();
            else
                if isKey(obj.props_, 'permissions')
                    result = obj.props_('permissions');
                else
                    result = [];
                end
            end
        end
        function obj = set.permissions(obj, value)
            obj.props_('permissions') = value;
        end
        function result = get.copyable(obj)
            if ismethod(obj, 'get_copyable')
                result = obj.get_copyable();
            else
                if isKey(obj.props_, 'copyable')
                    result = obj.props_('copyable');
                else
                    result = [];
                end
            end
        end
        function obj = set.copyable(obj, value)
            obj.props_('copyable') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'char');
            end
            if isKey(obj.props_, 'editions')
                result('editions') = obj.props_('editions').toJson();
            end
            if isKey(obj.props_, 'providers')
                result('providers') = obj.props_('providers').toJson();
            end
            if isKey(obj.props_, 'ldap_sync')
                result('ldap_sync') = obj.props_('ldap_sync').toJson();
            end
            if isKey(obj.props_, 'permissions')
                result('permissions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('permissions'));
            end
            if isKey(obj.props_, 'copyable')
                result('copyable') = flywheel.ModelBase.serializeValue(obj.props_('copyable'), 'logical');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'editions')
                result.editions = struct(obj.props_('editions'));
            else
                result.editions = [];
            end
            if isKey(obj.props_, 'providers')
                result.providers = struct(obj.props_('providers'));
            else
                result.providers = [];
            end
            if isKey(obj.props_, 'ldap_sync')
                result.ldapSync = struct(obj.props_('ldap_sync'));
            else
                result.ldapSync = [];
            end
            if isKey(obj.props_, 'permissions')
                result.permissions = flywheel.ModelBase.cellmap(@struct, obj.props_('permissions'));
            else
                result.permissions = [];
            end
            if isKey(obj.props_, 'copyable')
                result.copyable = obj.props_('copyable');
            else
                result.copyable = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'editions')
                    propList.editions = obj.props_('editions');
                else
                    propList.editions = [];
                end
                if isKey(obj.props_, 'providers')
                    propList.providers = obj.props_('providers');
                else
                    propList.providers = [];
                end
                if isKey(obj.props_, 'ldap_sync')
                    propList.ldapSync = obj.props_('ldap_sync');
                else
                    propList.ldapSync = [];
                end
                if isKey(obj.props_, 'permissions')
                    propList.permissions = obj.props_('permissions');
                else
                    propList.permissions = [];
                end
                if isKey(obj.props_, 'copyable')
                    propList.copyable = obj.props_('copyable');
                else
                    propList.copyable = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectInput;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'char');
            end
            if isfield(json, 'editions')
                obj.props_('editions') = flywheel.model.Edition.fromJson(json.editions, context);
            end
            if isfield(json, 'providers')
                obj.props_('providers') = flywheel.model.Providers.fromJson(json.providers, context);
            end
            if isfield(json, 'ldap_sync')
                obj.props_('ldap_sync') = flywheel.model.LdapSyncConfig.fromJson(json.ldap_sync, context);
            end
            if isfield(json, 'permissions')
                obj.props_('permissions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RolePermission.fromJson(x, context), json.permissions);
            end
            if isfield(json, 'copyable')
                obj.props_('copyable') = flywheel.ModelBase.deserializeValue(json.copyable, 'logical');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectInput')
                    obj = flywheel.model.ProjectInput(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'description')
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'editions')
                    obj.props_('editions') =  flywheel.model.Edition.ensureIsInstance(obj.props_('editions'));
                end
                if isKey(obj.props_, 'providers')
                    obj.props_('providers') =  flywheel.model.Providers.ensureIsInstance(obj.props_('providers'));
                end
                if isKey(obj.props_, 'ldap_sync')
                    obj.props_('ldap_sync') =  flywheel.model.LdapSyncConfig.ensureIsInstance(obj.props_('ldap_sync'));
                end
                if isKey(obj.props_, 'permissions')
                    obj.props_('permissions') = flywheel.ModelBase.cellmap(@flywheel.model.RolePermission.ensureIsInstance, obj.props_('permissions'));
                end
                if isKey(obj.props_, 'copyable')
                end
                if isKey(obj.props_, 'info')
                end
            end
        end
    end
end
