% ProjectSettingsOutput
%
% ProjectSettingsOutput Properties:
%    viewerApps        
%    deidProfile       
%    forms             
%    externalRoutingId 
%    sharing           
%    workspaces        
%
% ProjectSettingsOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectSettingsOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'viewerApps', 'deidProfile', 'forms', 'externalRoutingId', 'sharing', 'workspaces' }, ...
            { 'viewer_apps', 'deid_profile', 'forms', 'external_routing_id', 'sharing', 'workspaces' });
    end
    properties(Dependent)
        viewerApps
        deidProfile
        forms
        externalRoutingId
        sharing
        workspaces
    end
    methods
        function obj = ProjectSettingsOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectSettingsOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'viewerApps', []);
                addParameter(p, 'deidProfile', []);
                addParameter(p, 'forms', []);
                addParameter(p, 'externalRoutingId', []);
                addParameter(p, 'sharing', []);
                addParameter(p, 'workspaces', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.viewerApps)
                    obj.props_('viewer_apps') = p.Results.viewerApps;
                end
                if ~isempty(p.Results.deidProfile)
                    obj.props_('deid_profile') = p.Results.deidProfile;
                end
                if ~isempty(p.Results.forms)
                    obj.props_('forms') = p.Results.forms;
                end
                if ~isempty(p.Results.externalRoutingId)
                    obj.props_('external_routing_id') = p.Results.externalRoutingId;
                end
                if ~isempty(p.Results.sharing)
                    obj.props_('sharing') = p.Results.sharing;
                end
                if ~isempty(p.Results.workspaces)
                    obj.props_('workspaces') = p.Results.workspaces;
                end
            end
        end
        function result = get.viewerApps(obj)
            if ismethod(obj, 'get_viewerApps')
                result = obj.get_viewerApps();
            else
                if isKey(obj.props_, 'viewer_apps')
                    result = obj.props_('viewer_apps');
                else
                    result = [];
                end
            end
        end
        function obj = set.viewerApps(obj, value)
            obj.props_('viewer_apps') = value;
        end
        function result = get.deidProfile(obj)
            if ismethod(obj, 'get_deidProfile')
                result = obj.get_deidProfile();
            else
                if isKey(obj.props_, 'deid_profile')
                    result = obj.props_('deid_profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.deidProfile(obj, value)
            obj.props_('deid_profile') = value;
        end
        function result = get.forms(obj)
            if ismethod(obj, 'get_forms')
                result = obj.get_forms();
            else
                if isKey(obj.props_, 'forms')
                    result = obj.props_('forms');
                else
                    result = [];
                end
            end
        end
        function obj = set.forms(obj, value)
            obj.props_('forms') = value;
        end
        function result = get.externalRoutingId(obj)
            if ismethod(obj, 'get_externalRoutingId')
                result = obj.get_externalRoutingId();
            else
                if isKey(obj.props_, 'external_routing_id')
                    result = obj.props_('external_routing_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.externalRoutingId(obj, value)
            obj.props_('external_routing_id') = value;
        end
        function result = get.sharing(obj)
            if ismethod(obj, 'get_sharing')
                result = obj.get_sharing();
            else
                if isKey(obj.props_, 'sharing')
                    result = obj.props_('sharing');
                else
                    result = [];
                end
            end
        end
        function obj = set.sharing(obj, value)
            obj.props_('sharing') = value;
        end
        function result = get.workspaces(obj)
            if ismethod(obj, 'get_workspaces')
                result = obj.get_workspaces();
            else
                if isKey(obj.props_, 'workspaces')
                    result = obj.props_('workspaces');
                else
                    result = [];
                end
            end
        end
        function obj = set.workspaces(obj, value)
            obj.props_('workspaces') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'viewer_apps')
                result('viewer_apps') = flywheel.ModelBase.cellmap(@toJson, obj.props_('viewer_apps'));
            end
            if isKey(obj.props_, 'deid_profile')
                result('deid_profile') = flywheel.ModelBase.serializeValue(obj.props_('deid_profile'), 'containers.Map');
            end
            if isKey(obj.props_, 'forms')
                result('forms') = flywheel.ModelBase.serializeValue(obj.props_('forms'), 'containers.Map[String, vector[FormDefinition]]');
            end
            if isKey(obj.props_, 'external_routing_id')
                result('external_routing_id') = flywheel.ModelBase.serializeValue(obj.props_('external_routing_id'), 'char');
            end
            if isKey(obj.props_, 'sharing')
                result('sharing') = obj.props_('sharing').toJson();
            end
            if isKey(obj.props_, 'workspaces')
                result('workspaces') = obj.props_('workspaces').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'viewer_apps')
                result.viewerApps = flywheel.ModelBase.cellmap(@struct, obj.props_('viewer_apps'));
            else
                result.viewerApps = [];
            end
            if isKey(obj.props_, 'deid_profile')
                result.deidProfile = obj.props_('deid_profile');
            else
                result.deidProfile = [];
            end
            if isKey(obj.props_, 'forms')
                result.forms = obj.props_('forms');
            else
                result.forms = [];
            end
            if isKey(obj.props_, 'external_routing_id')
                result.externalRoutingId = obj.props_('external_routing_id');
            else
                result.externalRoutingId = [];
            end
            if isKey(obj.props_, 'sharing')
                result.sharing = struct(obj.props_('sharing'));
            else
                result.sharing = [];
            end
            if isKey(obj.props_, 'workspaces')
                result.workspaces = struct(obj.props_('workspaces'));
            else
                result.workspaces = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'viewer_apps')
                    propList.viewerApps = obj.props_('viewer_apps');
                else
                    propList.viewerApps = [];
                end
                if isKey(obj.props_, 'deid_profile')
                    propList.deidProfile = obj.props_('deid_profile');
                else
                    propList.deidProfile = [];
                end
                if isKey(obj.props_, 'forms')
                    propList.forms = obj.props_('forms');
                else
                    propList.forms = [];
                end
                if isKey(obj.props_, 'external_routing_id')
                    propList.externalRoutingId = obj.props_('external_routing_id');
                else
                    propList.externalRoutingId = [];
                end
                if isKey(obj.props_, 'sharing')
                    propList.sharing = obj.props_('sharing');
                else
                    propList.sharing = [];
                end
                if isKey(obj.props_, 'workspaces')
                    propList.workspaces = obj.props_('workspaces');
                else
                    propList.workspaces = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectSettingsOutput;
            if isfield(json, 'viewer_apps')
                obj.props_('viewer_apps') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ViewerApp.fromJson(x, context), json.viewer_apps);
            end
            if isfield(json, 'deid_profile')
                obj.props_('deid_profile') = flywheel.ModelBase.deserializeValue(json.deid_profile, 'containers.Map');
            end
            if isfield(json, 'forms')
                obj.props_('forms') = flywheel.ModelBase.deserializeValue(json.forms, 'containers.Map[String, vector[FormDefinition]]');
            end
            if isfield(json, 'external_routing_id')
                obj.props_('external_routing_id') = flywheel.ModelBase.deserializeValue(json.external_routing_id, 'char');
            end
            if isfield(json, 'sharing')
                obj.props_('sharing') = flywheel.model.ProjectSettingsSharing.fromJson(json.sharing, context);
            end
            if isfield(json, 'workspaces')
                obj.props_('workspaces') = flywheel.model.AllOfProjectSettingsOutputWorkspaces.fromJson(json.workspaces, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectSettingsOutput')
                    obj = flywheel.model.ProjectSettingsOutput(obj);
                end
                if isKey(obj.props_, 'viewer_apps')
                    obj.props_('viewer_apps') = flywheel.ModelBase.cellmap(@flywheel.model.ViewerApp.ensureIsInstance, obj.props_('viewer_apps'));
                end
                if isKey(obj.props_, 'deid_profile')
                end
                if isKey(obj.props_, 'forms')
                end
                if isKey(obj.props_, 'external_routing_id')
                end
                if isKey(obj.props_, 'sharing')
                    obj.props_('sharing') =  flywheel.model.ProjectSettingsSharing.ensureIsInstance(obj.props_('sharing'));
                end
                if isKey(obj.props_, 'workspaces')
                    obj.props_('workspaces') =  flywheel.model.AllOfProjectSettingsOutputWorkspaces.ensureIsInstance(obj.props_('workspaces'));
                end
            end
        end
    end
end
