% ProjectSettingsWorkspacesInput
%
% ProjectSettingsWorkspacesInput Properties:
%    jupyterhub 
%    azureml    
%
% ProjectSettingsWorkspacesInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectSettingsWorkspacesInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'jupyterhub', 'azureml' }, ...
            { 'jupyterhub', 'azureml' });
    end
    properties(Dependent)
        jupyterhub
        azureml
    end
    methods
        function obj = ProjectSettingsWorkspacesInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectSettingsWorkspacesInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'jupyterhub', []);
                addParameter(p, 'azureml', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.jupyterhub)
                    obj.props_('jupyterhub') = p.Results.jupyterhub;
                end
                if ~isempty(p.Results.azureml)
                    obj.props_('azureml') = p.Results.azureml;
                end
            end
        end
        function result = get.jupyterhub(obj)
            if ismethod(obj, 'get_jupyterhub')
                result = obj.get_jupyterhub();
            else
                if isKey(obj.props_, 'jupyterhub')
                    result = obj.props_('jupyterhub');
                else
                    result = [];
                end
            end
        end
        function obj = set.jupyterhub(obj, value)
            obj.props_('jupyterhub') = value;
        end
        function result = get.azureml(obj)
            if ismethod(obj, 'get_azureml')
                result = obj.get_azureml();
            else
                if isKey(obj.props_, 'azureml')
                    result = obj.props_('azureml');
                else
                    result = [];
                end
            end
        end
        function obj = set.azureml(obj, value)
            obj.props_('azureml') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'jupyterhub')
                result('jupyterhub') = obj.props_('jupyterhub').toJson();
            end
            if isKey(obj.props_, 'azureml')
                result('azureml') = obj.props_('azureml').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'jupyterhub')
                result.jupyterhub = struct(obj.props_('jupyterhub'));
            else
                result.jupyterhub = [];
            end
            if isKey(obj.props_, 'azureml')
                result.azureml = struct(obj.props_('azureml'));
            else
                result.azureml = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'jupyterhub')
                    propList.jupyterhub = obj.props_('jupyterhub');
                else
                    propList.jupyterhub = [];
                end
                if isKey(obj.props_, 'azureml')
                    propList.azureml = obj.props_('azureml');
                else
                    propList.azureml = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectSettingsWorkspacesInput;
            if isfield(json, 'jupyterhub')
                obj.props_('jupyterhub') = flywheel.model.JupyterhubWorkspace.fromJson(json.jupyterhub, context);
            end
            if isfield(json, 'azureml')
                obj.props_('azureml') = flywheel.model.AzureMLIntegration.fromJson(json.azureml, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectSettingsWorkspacesInput')
                    obj = flywheel.model.ProjectSettingsWorkspacesInput(obj);
                end
                if isKey(obj.props_, 'jupyterhub')
                    obj.props_('jupyterhub') =  flywheel.model.JupyterhubWorkspace.ensureIsInstance(obj.props_('jupyterhub'));
                end
                if isKey(obj.props_, 'azureml')
                    obj.props_('azureml') =  flywheel.model.AzureMLIntegration.ensureIsInstance(obj.props_('azureml'));
                end
            end
        end
    end
end
