% ProjectStats
%
% ProjectStats Properties:
%    numberOf     
%    ageGroups    
%    measurements 
%    modalities   
%    fileTypes    
%
% ProjectStats Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectStats < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'numberOf', 'ageGroups', 'measurements', 'modalities', 'fileTypes' }, ...
            { 'number_of', 'age_groups', 'measurements', 'modalities', 'file_types' });
    end
    properties(Dependent)
        numberOf
        ageGroups
        measurements
        modalities
        fileTypes
    end
    methods
        function obj = ProjectStats(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectStats.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'numberOf', []);
                addParameter(p, 'ageGroups', []);
                addParameter(p, 'measurements', []);
                addParameter(p, 'modalities', []);
                addParameter(p, 'fileTypes', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.numberOf)
                    obj.props_('number_of') = p.Results.numberOf;
                end
                if ~isempty(p.Results.ageGroups)
                    obj.props_('age_groups') = p.Results.ageGroups;
                end
                if ~isempty(p.Results.measurements)
                    obj.props_('measurements') = p.Results.measurements;
                end
                if ~isempty(p.Results.modalities)
                    obj.props_('modalities') = p.Results.modalities;
                end
                if ~isempty(p.Results.fileTypes)
                    obj.props_('file_types') = p.Results.fileTypes;
                end
            end
        end
        function result = get.numberOf(obj)
            if ismethod(obj, 'get_numberOf')
                result = obj.get_numberOf();
            else
                if isKey(obj.props_, 'number_of')
                    result = obj.props_('number_of');
                else
                    result = [];
                end
            end
        end
        function obj = set.numberOf(obj, value)
            obj.props_('number_of') = value;
        end
        function result = get.ageGroups(obj)
            if ismethod(obj, 'get_ageGroups')
                result = obj.get_ageGroups();
            else
                if isKey(obj.props_, 'age_groups')
                    result = obj.props_('age_groups');
                else
                    result = [];
                end
            end
        end
        function obj = set.ageGroups(obj, value)
            obj.props_('age_groups') = value;
        end
        function result = get.measurements(obj)
            if ismethod(obj, 'get_measurements')
                result = obj.get_measurements();
            else
                if isKey(obj.props_, 'measurements')
                    result = obj.props_('measurements');
                else
                    result = [];
                end
            end
        end
        function obj = set.measurements(obj, value)
            obj.props_('measurements') = value;
        end
        function result = get.modalities(obj)
            if ismethod(obj, 'get_modalities')
                result = obj.get_modalities();
            else
                if isKey(obj.props_, 'modalities')
                    result = obj.props_('modalities');
                else
                    result = [];
                end
            end
        end
        function obj = set.modalities(obj, value)
            obj.props_('modalities') = value;
        end
        function result = get.fileTypes(obj)
            if ismethod(obj, 'get_fileTypes')
                result = obj.get_fileTypes();
            else
                if isKey(obj.props_, 'file_types')
                    result = obj.props_('file_types');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileTypes(obj, value)
            obj.props_('file_types') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'number_of')
                result('number_of') = obj.props_('number_of').toJson();
            end
            if isKey(obj.props_, 'age_groups')
                result('age_groups') = flywheel.ModelBase.serializeValue(obj.props_('age_groups'), 'vector[char]');
            end
            if isKey(obj.props_, 'measurements')
                result('measurements') = flywheel.ModelBase.serializeValue(obj.props_('measurements'), 'vector[char]');
            end
            if isKey(obj.props_, 'modalities')
                result('modalities') = flywheel.ModelBase.serializeValue(obj.props_('modalities'), 'vector[char]');
            end
            if isKey(obj.props_, 'file_types')
                result('file_types') = flywheel.ModelBase.serializeValue(obj.props_('file_types'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'number_of')
                result.numberOf = struct(obj.props_('number_of'));
            else
                result.numberOf = [];
            end
            if isKey(obj.props_, 'age_groups')
                result.ageGroups = obj.props_('age_groups');
            else
                result.ageGroups = [];
            end
            if isKey(obj.props_, 'measurements')
                result.measurements = obj.props_('measurements');
            else
                result.measurements = [];
            end
            if isKey(obj.props_, 'modalities')
                result.modalities = obj.props_('modalities');
            else
                result.modalities = [];
            end
            if isKey(obj.props_, 'file_types')
                result.fileTypes = obj.props_('file_types');
            else
                result.fileTypes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'number_of')
                    propList.numberOf = obj.props_('number_of');
                else
                    propList.numberOf = [];
                end
                if isKey(obj.props_, 'age_groups')
                    propList.ageGroups = obj.props_('age_groups');
                else
                    propList.ageGroups = [];
                end
                if isKey(obj.props_, 'measurements')
                    propList.measurements = obj.props_('measurements');
                else
                    propList.measurements = [];
                end
                if isKey(obj.props_, 'modalities')
                    propList.modalities = obj.props_('modalities');
                else
                    propList.modalities = [];
                end
                if isKey(obj.props_, 'file_types')
                    propList.fileTypes = obj.props_('file_types');
                else
                    propList.fileTypes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectStats;
            if isfield(json, 'number_of')
                obj.props_('number_of') = flywheel.model.ProjectCounters.fromJson(json.number_of, context);
            end
            if isfield(json, 'age_groups')
                obj.props_('age_groups') = flywheel.ModelBase.deserializeValue(json.age_groups, 'vector[char]');
            end
            if isfield(json, 'measurements')
                obj.props_('measurements') = flywheel.ModelBase.deserializeValue(json.measurements, 'vector[char]');
            end
            if isfield(json, 'modalities')
                obj.props_('modalities') = flywheel.ModelBase.deserializeValue(json.modalities, 'vector[char]');
            end
            if isfield(json, 'file_types')
                obj.props_('file_types') = flywheel.ModelBase.deserializeValue(json.file_types, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectStats')
                    obj = flywheel.model.ProjectStats(obj);
                end
                if isKey(obj.props_, 'number_of')
                    obj.props_('number_of') =  flywheel.model.ProjectCounters.ensureIsInstance(obj.props_('number_of'));
                end
                if isKey(obj.props_, 'age_groups')
                end
                if isKey(obj.props_, 'measurements')
                end
                if isKey(obj.props_, 'modalities')
                end
                if isKey(obj.props_, 'file_types')
                end
            end
        end
    end
end
