% ProjectTemplate
%
% ProjectTemplate Properties:
%    session      
%    acquisitions 
%
% ProjectTemplate Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectTemplate < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'session', 'acquisitions' }, ...
            { 'session', 'acquisitions' });
    end
    properties(Dependent)
        session
        acquisitions
    end
    methods
        function obj = ProjectTemplate(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectTemplate.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'session', []);
                addParameter(p, 'acquisitions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.session)
                    obj.props_('session') = p.Results.session;
                end
                if ~isempty(p.Results.acquisitions)
                    obj.props_('acquisitions') = p.Results.acquisitions;
                end
            end
        end
        function result = get.session(obj)
            if ismethod(obj, 'get_session')
                result = obj.get_session();
            else
                if isKey(obj.props_, 'session')
                    result = obj.props_('session');
                else
                    result = [];
                end
            end
        end
        function obj = set.session(obj, value)
            obj.props_('session') = value;
        end
        function result = get.acquisitions(obj)
            if ismethod(obj, 'get_acquisitions')
                result = obj.get_acquisitions();
            else
                if isKey(obj.props_, 'acquisitions')
                    result = obj.props_('acquisitions');
                else
                    result = [];
                end
            end
        end
        function obj = set.acquisitions(obj, value)
            obj.props_('acquisitions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'session')
                result('session') = obj.props_('session').toJson();
            end
            if isKey(obj.props_, 'acquisitions')
                result('acquisitions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('acquisitions'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'session')
                result.session = struct(obj.props_('session'));
            else
                result.session = [];
            end
            if isKey(obj.props_, 'acquisitions')
                result.acquisitions = flywheel.ModelBase.cellmap(@struct, obj.props_('acquisitions'));
            else
                result.acquisitions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'session')
                    propList.session = obj.props_('session');
                else
                    propList.session = [];
                end
                if isKey(obj.props_, 'acquisitions')
                    propList.acquisitions = obj.props_('acquisitions');
                else
                    propList.acquisitions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectTemplate;
            if isfield(json, 'session')
                obj.props_('session') = flywheel.model.SessionTemplateOptions.fromJson(json.session, context);
            end
            if isfield(json, 'acquisitions')
                obj.props_('acquisitions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.AcquisitionTemplateOptions.fromJson(x, context), json.acquisitions);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectTemplate')
                    obj = flywheel.model.ProjectTemplate(obj);
                end
                if isKey(obj.props_, 'session')
                    obj.props_('session') =  flywheel.model.SessionTemplateOptions.ensureIsInstance(obj.props_('session'));
                end
                if isKey(obj.props_, 'acquisitions')
                    obj.props_('acquisitions') = flywheel.ModelBase.cellmap(@flywheel.model.AcquisitionTemplateOptions.ensureIsInstance, obj.props_('acquisitions'));
                end
            end
        end
    end
end
