% ProjectTemplateListInput
%
% ProjectTemplateListInput Properties:
%    templates 
%
% ProjectTemplateListInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProjectTemplateListInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'templates' }, ...
            { 'templates' });
    end
    properties(Dependent)
        templates
    end
    methods
        function obj = ProjectTemplateListInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProjectTemplateListInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'templates', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.templates)
                    obj.props_('templates') = p.Results.templates;
                end
            end
        end
        function result = get.templates(obj)
            if ismethod(obj, 'get_templates')
                result = obj.get_templates();
            else
                if isKey(obj.props_, 'templates')
                    result = obj.props_('templates');
                else
                    result = [];
                end
            end
        end
        function obj = set.templates(obj, value)
            obj.props_('templates') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'templates')
                result('templates') = flywheel.ModelBase.cellmap(@toJson, obj.props_('templates'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'templates')
                result.templates = flywheel.ModelBase.cellmap(@struct, obj.props_('templates'));
            else
                result.templates = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'templates')
                    propList.templates = obj.props_('templates');
                else
                    propList.templates = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProjectTemplateListInput;
            if isfield(json, 'templates')
                obj.props_('templates') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ProjectTemplateInput.fromJson(x, context), json.templates);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProjectTemplateListInput')
                    obj = flywheel.model.ProjectTemplateListInput(obj);
                end
                if isKey(obj.props_, 'templates')
                    obj.props_('templates') = flywheel.ModelBase.cellmap(@flywheel.model.ProjectTemplateInput.ensureIsInstance, obj.props_('templates'));
                end
            end
        end
    end
end
