% ProviderDeletionStatus - Model to show status of Provider deletion
%
% ProviderDeletionStatus Properties:
%    filesDeleted  
%    filesToDelete 
%
% ProviderDeletionStatus Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ProviderDeletionStatus < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'filesDeleted', 'filesToDelete' }, ...
            { 'files_deleted', 'files_to_delete' });
    end
    properties(Dependent)
        filesDeleted
        filesToDelete
    end
    methods
        function obj = ProviderDeletionStatus(varargin)
            obj@flywheel.ModelBase(flywheel.model.ProviderDeletionStatus.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'filesDeleted', []);
                addParameter(p, 'filesToDelete', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.filesDeleted)
                    obj.props_('files_deleted') = p.Results.filesDeleted;
                end
                if ~isempty(p.Results.filesToDelete)
                    obj.props_('files_to_delete') = p.Results.filesToDelete;
                end
            end
        end
        function result = get.filesDeleted(obj)
            if ismethod(obj, 'get_filesDeleted')
                result = obj.get_filesDeleted();
            else
                if isKey(obj.props_, 'files_deleted')
                    result = obj.props_('files_deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.filesDeleted(obj, value)
            obj.props_('files_deleted') = value;
        end
        function result = get.filesToDelete(obj)
            if ismethod(obj, 'get_filesToDelete')
                result = obj.get_filesToDelete();
            else
                if isKey(obj.props_, 'files_to_delete')
                    result = obj.props_('files_to_delete');
                else
                    result = [];
                end
            end
        end
        function obj = set.filesToDelete(obj, value)
            obj.props_('files_to_delete') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'files_deleted')
                result('files_deleted') = flywheel.ModelBase.serializeValue(obj.props_('files_deleted'), 'integer');
            end
            if isKey(obj.props_, 'files_to_delete')
                result('files_to_delete') = flywheel.ModelBase.serializeValue(obj.props_('files_to_delete'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'files_deleted')
                result.filesDeleted = obj.props_('files_deleted');
            else
                result.filesDeleted = [];
            end
            if isKey(obj.props_, 'files_to_delete')
                result.filesToDelete = obj.props_('files_to_delete');
            else
                result.filesToDelete = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'files_deleted')
                    propList.filesDeleted = obj.props_('files_deleted');
                else
                    propList.filesDeleted = [];
                end
                if isKey(obj.props_, 'files_to_delete')
                    propList.filesToDelete = obj.props_('files_to_delete');
                else
                    propList.filesToDelete = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ProviderDeletionStatus;
            if isfield(json, 'files_deleted')
                obj.props_('files_deleted') = flywheel.ModelBase.deserializeValue(json.files_deleted, 'integer');
            end
            if isfield(json, 'files_to_delete')
                obj.props_('files_to_delete') = flywheel.ModelBase.deserializeValue(json.files_to_delete, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ProviderDeletionStatus')
                    obj = flywheel.model.ProviderDeletionStatus(obj);
                end
                if isKey(obj.props_, 'files_deleted')
                end
                if isKey(obj.props_, 'files_to_delete')
                end
            end
        end
    end
end
